/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;

public class PacketSyncDictionary
implements IMessage {
    public Map<String, Integer> componentIds;

    public void toBytes(ByteBuf buf) {
        buf.writeInt(GlobalDictionary.GLOBAL_DICTIONARY.size());
        for (Map.Entry<String, DictionaryEntry> info : GlobalDictionary.GLOBAL_DICTIONARY.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)info.getKey());
            buf.writeInt(info.getValue().globalID);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.componentIds = new HashMap<String, Integer>();
        int componentCount = buf.readInt();
        for (int i = 0; i < componentCount; ++i) {
            String refString = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int globalID = buf.readInt();
            this.componentIds.put(refString, globalID);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncDictionary, IMessage> {
        public IMessage onMessage(PacketSyncDictionary message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSyncDictionary message, MessageContext ctx) {
            for (Map.Entry<String, Integer> component : message.componentIds.entrySet()) {
                DictionaryEntry componentInfo = GlobalDictionary.getComponentInfo(component.getKey());
                if (componentInfo == null) {
                    ReactorBuilder.logger.error("Dictionary Sync: Missing component on client side REF: {} ID: {}", (Object)component.getKey(), (Object)component.getValue());
                    continue;
                }
                componentInfo.globalID = component.getValue();
            }
            ReactorBuilder.logger.info("Synced {} component types", (Object)message.componentIds.size());
        }
    }
}

