/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.network.PacketTemplateUploadHeaderAck;
import sonar.reactorbuilder.network.templates.TemplateManager;

public class PacketTemplateUploadHeader
implements IMessage {
    public AbstractTemplate template;
    public BlockPos dest;

    public PacketTemplateUploadHeader() {
    }

    public PacketTemplateUploadHeader(AbstractTemplate template, @Nullable BlockPos dest) {
        this.template = template;
        this.dest = dest;
    }

    public void toBytes(ByteBuf buf) {
        AbstractTemplate.writeTemplateHeaderToByteBuf(buf, this.template);
        buf.writeBoolean(this.dest != null);
        if (this.dest != null) {
            buf.writeLong(this.dest.func_177986_g());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.template = AbstractTemplate.readTemplateHeaderFromByteBuf(buf);
        if (buf.readBoolean()) {
            this.dest = BlockPos.func_177969_a((long)buf.readLong());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketTemplateUploadHeader, IMessage> {
        public IMessage onMessage(PacketTemplateUploadHeader message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return new PacketTemplateUploadHeaderAck(message.template.templateID);
        }

        private void handle(PacketTemplateUploadHeader message, MessageContext ctx) {
            TileEntity tileEntity;
            EntityPlayer player = ReactorBuilder.proxy.getPlayer(ctx);
            ReactorBuilderTileEntity builder = null;
            if (message.dest != null && (tileEntity = player.func_130014_f_().func_175625_s(message.dest)) instanceof ReactorBuilderTileEntity) {
                builder = (ReactorBuilderTileEntity)tileEntity;
            }
            TemplateManager.getDownloadHandler(ctx.side.isClient()).receiveHeaderPacket(message.template, player, builder);
        }
    }
}

