/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.network.PacketTemplateUploadPayloadAck;
import sonar.reactorbuilder.network.templates.TemplateManager;

public class PacketTemplateUploadPayload
implements IMessage {
    public AbstractTemplate template;
    public int templateID;
    public int start;
    public int end;
    public ByteBuf byteBuf;

    public PacketTemplateUploadPayload() {
    }

    public PacketTemplateUploadPayload(AbstractTemplate template, int start, int end) {
        this.template = template;
        this.start = start;
        this.end = end;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.template.templateID);
        buf.writeInt(this.start);
        buf.writeInt(this.end);
        this.template.writePayloadToBuf(buf, this.start, this.end);
    }

    public void fromBytes(ByteBuf buf) {
        this.templateID = buf.readInt();
        this.start = buf.readInt();
        this.end = buf.readInt();
        this.byteBuf = buf.retain();
    }

    public static class Handler
    implements IMessageHandler<PacketTemplateUploadPayload, IMessage> {
        public IMessage onMessage(PacketTemplateUploadPayload message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return new PacketTemplateUploadPayloadAck(message.templateID);
        }

        private void handle(PacketTemplateUploadPayload message, MessageContext ctx) {
            TemplateManager.getDownloadHandler(ctx.side.isClient()).receivePayloadPacket(message);
        }
    }
}

