/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.network.EnumSyncPacket;

public class PacketTileSync
implements IMessage {
    public ReactorBuilderTileEntity te;
    public BlockPos builder;
    public EnumSyncPacket type;
    public ByteBuf byteBuf;

    public PacketTileSync() {
    }

    public PacketTileSync(ReactorBuilderTileEntity tileEntity, EnumSyncPacket type) {
        this.te = tileEntity;
        this.builder = tileEntity.func_174877_v();
        this.type = type;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.builder.func_177986_g());
        buf.writeInt(this.type.ordinal());
        this.te.writeSyncPacket(buf, this.type);
    }

    public void fromBytes(ByteBuf buf) {
        this.builder = BlockPos.func_177969_a((long)buf.readLong());
        this.type = EnumSyncPacket.values()[buf.readInt()];
        this.byteBuf = buf.retain();
    }

    public static class Handler
    implements IMessageHandler<PacketTileSync, IMessage> {
        public IMessage onMessage(PacketTileSync message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTileSync message, MessageContext ctx) {
            EntityPlayer player = ReactorBuilder.proxy.getPlayer(ctx);
            TileEntity tileEntity = player.func_130014_f_().func_175625_s(message.builder);
            if (tileEntity instanceof ReactorBuilderTileEntity) {
                ReactorBuilderTileEntity builder = (ReactorBuilderTileEntity)tileEntity;
                builder.readSyncPacket(message.byteBuf, message.type);
            }
        }
    }
}

