/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.network.PacketHandler;
import sonar.reactorbuilder.network.PacketTemplateRequest;
import sonar.reactorbuilder.network.PacketTemplateUploadHeader;
import sonar.reactorbuilder.network.PacketTemplateUploadHeaderAck;
import sonar.reactorbuilder.network.PacketTemplateUploadPayload;
import sonar.reactorbuilder.network.PacketTemplateUploadPayloadAck;
import sonar.reactorbuilder.network.templates.TemplateManager;
import sonar.reactorbuilder.network.templates.TemplateTransfer;

public abstract class DownloadHandler {
    public TemplateManager manager;
    public List<Integer> requested = new ArrayList<Integer>();
    public Map<Integer, TemplateTransfer> downloading = new HashMap<Integer, TemplateTransfer>();
    public Map<Integer, TemplateTransfer> uploading = new HashMap<Integer, TemplateTransfer>();

    public void setManager(TemplateManager manager) {
        this.manager = manager;
    }

    public void clear() {
        this.requested.clear();
        this.downloading.clear();
        this.uploading.clear();
    }

    public void tick() {
        if (this.uploading.isEmpty()) {
            return;
        }
        for (TemplateTransfer transfer : this.uploading.values()) {
            switch (transfer.stage) {
                case REQUESTED: {
                    this.sendHeaderPacket(transfer);
                    break;
                }
                case HEADER_SENT: {
                    break;
                }
                case HEADER_ACK: {
                    this.sendPayloadPacket(transfer);
                    break;
                }
                case PAYLOAD_SENT: {
                    break;
                }
                case PAYLOAD_ACK: {
                    this.sendPayloadPacket(transfer);
                    break;
                }
            }
        }
    }

    public void sendRequestPacket(int templateID) {
        if (!this.requested.contains(templateID)) {
            this.requested.add(templateID);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTemplateRequest(templateID));
        }
    }

    public void receiveRequestPacket(int templateID, EntityPlayer player) {
        AbstractTemplate template = this.manager.getTemplate(templateID);
        if (template != null) {
            TemplateTransfer transfer = new TemplateTransfer(template, TemplateTransfer.TransferStage.REQUESTED);
            transfer.player = player;
            this.uploading.put(templateID, transfer);
        }
    }

    public void sendLocalTemplate(AbstractTemplate template, EntityPlayer player, ReactorBuilderTileEntity dest) {
        TemplateTransfer transfer = new TemplateTransfer(template, TemplateTransfer.TransferStage.REQUESTED);
        transfer.player = player;
        transfer.dest = dest;
        this.uploading.put(template.templateID, transfer);
    }

    public void sendHeaderPacket(TemplateTransfer transfer) {
        this.sendPacket(transfer, new PacketTemplateUploadHeader(transfer.template, transfer.dest != null ? transfer.dest.func_174877_v() : null));
        transfer.stage = TemplateTransfer.TransferStage.HEADER_SENT;
    }

    public void receiveHeaderPacket(AbstractTemplate template, EntityPlayer player, @Nullable ReactorBuilderTileEntity dest) {
        TemplateTransfer transfer = new TemplateTransfer(template, TemplateTransfer.TransferStage.HEADER_ACK);
        transfer.player = player;
        transfer.dest = dest;
        this.downloading.put(template.templateID, transfer);
    }

    public void headerPacketAck(PacketTemplateUploadHeaderAck message) {
        TemplateTransfer template = this.getUpload(message.templateID);
        template.stage = TemplateTransfer.TransferStage.HEADER_ACK;
    }

    public void sendPayloadPacket(TemplateTransfer transfer) {
        int start = transfer.getPayloadStart();
        int end = transfer.getPayloadEnd();
        this.sendPacket(transfer, new PacketTemplateUploadPayload(transfer.template, start, end));
        transfer.stage = TemplateTransfer.TransferStage.PAYLOAD_SENT;
        transfer.index = end;
    }

    public void receivePayloadPacket(PacketTemplateUploadPayload message) {
        TemplateTransfer template = this.getDownload(message.templateID);
        template.template.readPayloadFromBuf(message.byteBuf, message.start, message.end);
        template.index = message.end;
        if (!template.requiresPayloadPacket()) {
            template.stage = TemplateTransfer.TransferStage.FINISHED;
            int templateID = this.manager.addTemplate(template.template);
            template.template.updateAdditionalInfo();
            template.template.sortAdditionalInfo();
            if (template.dest != null) {
                template.dest.changeTemplate(templateID);
            }
            this.requested.remove((Object)templateID);
        }
    }

    public void payloadPacketAck(PacketTemplateUploadPayloadAck message) {
        TemplateTransfer template = this.getUpload(message.templateID);
        template.stage = template.requiresPayloadPacket() ? TemplateTransfer.TransferStage.PAYLOAD_ACK : TemplateTransfer.TransferStage.FINISHED;
    }

    public TemplateTransfer getUpload(int templateID) {
        return this.uploading.get(templateID);
    }

    public TemplateTransfer getDownload(int templateID) {
        return this.downloading.get(templateID);
    }

    public abstract void sendPacket(TemplateTransfer var1, IMessage var2);

    public static class Server
    extends DownloadHandler {
        @Override
        public void sendPacket(TemplateTransfer transfer, IMessage packet) {
            PacketHandler.INSTANCE.sendTo(packet, (EntityPlayerMP)transfer.player);
        }
    }

    public static class Client
    extends DownloadHandler {
        @Override
        public void sendPacket(TemplateTransfer transfer, IMessage packet) {
            PacketHandler.INSTANCE.sendToServer(packet);
        }
    }
}

