/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network.templates;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.network.templates.DownloadHandler;
import sonar.reactorbuilder.network.templates.TemplateServerData;

public abstract class TemplateManager {
    protected DownloadHandler downloader;

    public TemplateManager(DownloadHandler handler) {
        this.downloader = handler;
        handler.setManager(this);
    }

    public void clear() {
        this.downloader.clear();
    }

    public DownloadHandler getDownloadHandler() {
        return this.downloader;
    }

    @Nullable
    public abstract AbstractTemplate getTemplate(int var1);

    public abstract int addTemplate(AbstractTemplate var1);

    public static DownloadHandler getDownloadHandler(boolean isRemote) {
        return isRemote ? Client.INSTANCE.getDownloadHandler() : Server.INSTANCE.getDownloadHandler();
    }

    public static TemplateManager getTemplateManager(boolean isRemote) {
        return isRemote ? Client.INSTANCE : Server.INSTANCE;
    }

    public static class Server
    extends TemplateManager {
        public static Server INSTANCE = new Server();

        public Server() {
            super(new DownloadHandler.Server());
        }

        @Override
        @Nullable
        public AbstractTemplate getTemplate(int templateID) {
            return TemplateServerData.get().templates.get(templateID);
        }

        @Override
        public int addTemplate(AbstractTemplate template) {
            template.templateID = TemplateServerData.get().getNextID();
            TemplateServerData.get().templates.put(template.templateID, template);
            TemplateServerData.get().func_76185_a();
            return template.templateID;
        }
    }

    public static class Client
    extends TemplateManager {
        public static Client INSTANCE = new Client();
        public Map<Integer, AbstractTemplate> templates = new HashMap<Integer, AbstractTemplate>();

        public Client() {
            super(new DownloadHandler.Client());
        }

        @Override
        public void clear() {
            super.clear();
            this.templates.clear();
        }

        @Override
        @Nullable
        public AbstractTemplate getTemplate(int templateID) {
            AbstractTemplate template = this.templates.get(templateID);
            if (template != null) {
                return template;
            }
            if (templateID != -1) {
                this.downloader.sendRequestPacket(templateID);
            }
            return null;
        }

        @Override
        public int addTemplate(AbstractTemplate template) {
            this.templates.put(template.templateID, template);
            return template.templateID;
        }
    }
}

