/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network.templates;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;

public class TemplateServerData
extends WorldSavedData {
    private static final String TEMPLATE_DATA = "reactorbuilderdata";
    private static String TEMPLATE_LIST = "templates";
    private static TemplateServerData data;
    public Map<Integer, AbstractTemplate> templates = new HashMap<Integer, AbstractTemplate>();
    private int nextID;

    public TemplateServerData(String key) {
        super(key);
    }

    public TemplateServerData() {
        super(TEMPLATE_DATA);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.nextID = compound.func_74762_e("nextID");
        NBTTagList list = compound.func_150295_c(TEMPLATE_LIST, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound templateTag = list.func_150305_b(i);
            AbstractTemplate template = AbstractTemplate.readTemplateFromNBT(templateTag);
            if (template == null) continue;
            this.templates.put(template.templateID, template);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("nextID", this.nextID);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Integer, AbstractTemplate> entry : this.templates.entrySet()) {
            NBTTagCompound templateTag = new NBTTagCompound();
            AbstractTemplate.writeTemplateToNBT(templateTag, entry.getValue());
            list.func_74742_a((NBTBase)templateTag);
        }
        compound.func_74782_a(TEMPLATE_LIST, (NBTBase)list);
        return compound;
    }

    public int getNextID() {
        return this.nextID++;
    }

    public static TemplateServerData get() {
        if (data == null) {
            TemplateServerData.load();
        }
        return data;
    }

    private static void load() {
        WorldServer world = DimensionManager.getWorld((int)0);
        MapStorage mapStorage = world.func_175693_T();
        TemplateServerData savedData = (TemplateServerData)mapStorage.func_75742_a(TemplateServerData.class, TEMPLATE_DATA);
        if (savedData == null) {
            savedData = new TemplateServerData();
            mapStorage.func_75745_a(TEMPLATE_DATA, (WorldSavedData)savedData);
        }
        data = savedData;
        ReactorBuilder.logger.info("Template Data has loaded {} templates", (Object)TemplateServerData.data.templates.size());
    }

    public static void release() {
        if (data != null) {
            data = null;
            ReactorBuilder.logger.info("Template Data has been unloaded");
        }
    }
}

