/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.network.templates;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;

public class TemplateTransfer {
    public static final int MAX_PAYLOAD = 4096;
    public TransferStage stage;
    public AbstractTemplate template;
    public int index;
    @Nullable
    public EntityPlayer player;
    @Nullable
    public ReactorBuilderTileEntity dest;

    public TemplateTransfer(AbstractTemplate template, TransferStage stage) {
        this.template = template;
        this.stage = stage;
    }

    public int getPayloadStart() {
        return this.index;
    }

    public int getPayloadEnd() {
        return Math.min(this.index + 4096, this.template.getIndexSize());
    }

    public boolean requiresPayloadPacket() {
        return this.index < this.template.getIndexSize();
    }

    public static enum TransferStage {
        REQUESTED,
        HEADER_SENT,
        HEADER_ACK,
        PAYLOAD_SENT,
        PAYLOAD_ACK,
        FINISHED;

    }
}

