/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.proxy;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.ReactorBuilderBlock;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.network.PacketHandler;
import sonar.reactorbuilder.network.PacketSyncDictionary;
import sonar.reactorbuilder.network.templates.TemplateManager;
import sonar.reactorbuilder.proxy.GuiProxy;
import sonar.reactorbuilder.registry.RBBlocks;
import sonar.reactorbuilder.registry.RBConfig;
import sonar.reactorbuilder.registry.RBTab;

@Mod.EventBusSubscriber
public class CommonProxy {
    public boolean isOverhaul;
    public int recipeCount;

    public void preInit(FMLPreInitializationEvent e) {
        ReactorBuilder.logger.info("Registering packets");
        PacketHandler.registerMessages("reactorbuilder");
        ReactorBuilder.logger.info("Loading config");
        RBConfig.init(e.getModConfigurationDirectory());
    }

    public void init(FMLInitializationEvent e) {
        ReactorBuilder.logger.info("Registering gui handler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ReactorBuilder.instance, (IGuiHandler)new GuiProxy());
        this.addShapedOreRecipe(new ItemStack((Block)RBBlocks.reactorBuilder), "PLP", "SCS", "PLP", Character.valueOf('C'), "chassis", Character.valueOf('S'), "solenoidCopper", Character.valueOf('P'), "plateBasic", Character.valueOf('L'), "ingotLead");
    }

    public void addShapedOreRecipe(ItemStack input, Object ... outputs) {
        ResourceLocation location = new ResourceLocation("reactorbuilder", "recipe" + this.recipeCount);
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(location, input, outputs).setRegistryName(location));
        ++this.recipeCount;
    }

    public void postInit(FMLPostInitializationEvent e) {
        boolean isNCLoaded = Loader.isModLoaded((String)"nuclearcraft");
        if (!isNCLoaded) {
            ReactorBuilder.logger.info("NuclearCraft isn't loaded!");
            return;
        }
        ModContainer ncContainer = (ModContainer)Loader.instance().getIndexedModList().get("nuclearcraft");
        String version = ncContainer.getVersion();
        this.isOverhaul = version.startsWith("2o");
        ReactorBuilder.logger.info("Detected NuclearCraft Version: {} - Overhaul: {}", (Object)version, (Object)this.isOverhaul);
        ReactorBuilder.logger.info("Building reactor dictionary");
        GlobalDictionary.initDictionary(this.isOverhaul);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ReactorBuilder.logger.info("Registering blocks");
        event.getRegistry().register((IForgeRegistryEntry)new ReactorBuilderBlock("reactorbuilder").func_149647_a(RBTab.INSTANCE));
        event.getRegistry().register((IForgeRegistryEntry)new ReactorBuilderBlock.Creative("creativereactorbuilder").func_149647_a(RBTab.INSTANCE));
        ReactorBuilder.logger.info("Registering tile entities");
        GameRegistry.registerTileEntity(ReactorBuilderTileEntity.class, (ResourceLocation)new ResourceLocation("reactorbuilder", "reactorbuilder"));
        GameRegistry.registerTileEntity(ReactorBuilderTileEntity.Creative.class, (ResourceLocation)new ResourceLocation("reactorbuilder", "creativereactorbuilder"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ReactorBuilder.logger.info("Registering blocks");
        event.getRegistry().register(new ItemBlock((Block)RBBlocks.reactorBuilder).setRegistryName(RBBlocks.reactorBuilder.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)RBBlocks.creativeReactorBuilder).setRegistryName(RBBlocks.creativeReactorBuilder.getRegistryName()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ReactorBuilder.logger.info("Sending Reactor Dictionary to player: {}", (Object)event.player.func_146103_bH().getName());
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncDictionary(), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void clientDisconnection(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        TemplateManager.getTemplateManager(true).clear();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        TemplateManager.getDownloadHandler(true).tick();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        TemplateManager.getDownloadHandler(false).tick();
    }

    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }
}

