/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="supermartijn642configlib", name="SuperMartijn642's Config Library", version="1.0.9", acceptedMinecraftVersions="[1.12.2]")
public class ConfigLib {
    public static final String MODID = "supermartijn642configlib";
    public static final String NAME = "SuperMartijn642's Config Library";
    public static final String VERSION = "1.0.9";
    private static final List<ModConfig> CONFIGS = new ArrayList<ModConfig>();
    private static final Map<ModConfig.Type, List<ModConfig>> CONFIGS_PER_TYPE = new EnumMap<ModConfig.Type, List<ModConfig>>(ModConfig.Type.class);
    private static final Map<String, Map<ModConfig.Type, ModConfig>> CONFIGS_PER_MOD;
    private static final List<ModConfig> SYNCABLE_CONFIGS;
    public static SimpleNetworkWrapper channel;

    public ConfigLib() {
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("supermartijnconfig");
        channel.registerMessage(ConfigSyncPacket.class, ConfigSyncPacket.class, 0, Side.CLIENT);
    }

    protected static synchronized void addConfig(ModConfig config) {
        CONFIGS.add(config);
        CONFIGS_PER_MOD.putIfAbsent(config.getModid(), new EnumMap(ModConfig.Type.class));
        CONFIGS_PER_MOD.get(config.getModid()).put(config.getType(), config);
        CONFIGS_PER_TYPE.get((Object)config.getType()).add(config);
        if (config.getType() == ModConfig.Type.SERVER || config.getType() == ModConfig.Type.COMMON) {
            SYNCABLE_CONFIGS.add(config);
        }
    }

    protected static synchronized ModConfig getConfig(String modid, ModConfig.Type type) {
        Map<ModConfig.Type, ModConfig> configs = CONFIGS_PER_MOD.get(modid);
        if (configs != null) {
            return configs.get((Object)type);
        }
        return null;
    }

    protected static void clearSyncedValues() {
        for (ModConfig config : SYNCABLE_CONFIGS) {
            config.clearSyncedValues();
        }
    }

    static {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            CONFIGS_PER_TYPE.put(type, new ArrayList());
        }
        CONFIGS_PER_MOD = new HashMap<String, Map<ModConfig.Type, ModConfig>>();
        SYNCABLE_CONFIGS = new ArrayList<ModConfig>();
    }

    @Mod.EventBusSubscriber
    public static class ConfigEvents {
        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load e) {
            if (e.getWorld().field_72995_K || e.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
                return;
            }
            for (ModConfig config : CONFIGS) {
                config.updateValues();
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
            if (!e.player.field_70170_p.field_72995_K) {
                for (ModConfig config : SYNCABLE_CONFIGS) {
                    channel.sendTo((IMessage)new ConfigSyncPacket(config), (EntityPlayerMP)e.player);
                }
            }
        }

        @SubscribeEvent
        public static void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
            ConfigLib.clearSyncedValues();
        }
    }
}

