/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ClientProxy;
import com.supermartijn642.configlib.ConfigLib;
import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;

public class ConfigSyncPacket
implements IMessage,
IMessageHandler<ConfigSyncPacket, IMessage> {
    private String modid;
    private ModConfig.Type type;
    private final Map<String, Object> values = new HashMap<String, Object>();

    protected ConfigSyncPacket(ModConfig config) {
        this.modid = config.getModid();
        this.type = config.getType();
        this.values.putAll(config.getValuesToSync());
    }

    public ConfigSyncPacket() {
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.modid);
        buffer.writeInt(this.type.ordinal());
        buffer.writeInt(this.values.size());
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey());
            Object object = entry.getValue();
            if (object instanceof Boolean) {
                buffer.writeByte(1);
                buffer.writeBoolean(((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Integer) {
                buffer.writeByte(2);
                buffer.writeInt(((Integer)object).intValue());
                continue;
            }
            if (object instanceof Double) {
                buffer.writeByte(3);
                buffer.writeDouble(((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                buffer.writeByte(4);
                buffer.writeFloat(((Float)object).floatValue());
                continue;
            }
            if (object instanceof Enum) {
                byte[] bytes = null;
                try {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                    stream.writeObject(object);
                    stream.flush();
                    stream.close();
                    bytes = byteStream.toByteArray();
                }
                catch (Exception e) {
                    System.err.println("Failed to write enum: " + object.getClass() + "#" + object);
                    e.printStackTrace();
                    buffer.writeInt(0);
                }
                if (bytes == null) continue;
                buffer.writeByte(5);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
                continue;
            }
            System.err.println("Don't know how to write object: " + object.getClass());
            buffer.writeByte(0);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.modid = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        int typeIndex = buffer.readInt();
        if (typeIndex < 0 || typeIndex >= ModConfig.Type.values().length) {
            this.type = ModConfig.Type.COMMON;
            System.err.println("Received invalid ordinal '" + typeIndex + "' for enum " + ModConfig.Type.class);
            return;
        }
        this.type = ModConfig.Type.values()[typeIndex];
        ModConfig config = ConfigLib.getConfig(this.modid, this.type);
        if (config == null) {
            System.out.println("Failed to find config: " + this.modid + "-" + this.type.name().toLowerCase(Locale.ROOT));
            return;
        }
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Object object;
            String path = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            byte objectType = buffer.readByte();
            switch (objectType) {
                case 1: {
                    object = buffer.readBoolean();
                    break;
                }
                case 2: {
                    object = buffer.readInt();
                    break;
                }
                case 3: {
                    object = buffer.readDouble();
                    break;
                }
                case 4: {
                    object = Float.valueOf(buffer.readFloat());
                    break;
                }
                case 5: {
                    byte[] bytes = new byte[buffer.readInt()];
                    buffer.readBytes(bytes);
                    try {
                        ValidatingObjectInputStream stream = new ValidatingObjectInputStream((InputStream)new ByteArrayInputStream(bytes));
                        config.getExpectedValueTypes().forEach(xva$0 -> stream.accept(new Class[]{xva$0}));
                        object = (Enum)stream.readObject();
                    }
                    catch (Exception e) {
                        System.err.println("Failed to decode enum value:");
                        e.printStackTrace();
                        object = null;
                    }
                    break;
                }
                default: {
                    object = null;
                }
            }
            if (object == null) continue;
            this.values.put(path, object);
        }
    }

    public IMessage onMessage(ConfigSyncPacket message, MessageContext ctx) {
        EntityPlayer player;
        Object object = player = ctx.side == Side.SERVER ? ctx.getServerHandler().field_147369_b : ClientProxy.getPlayer();
        if (player != null && player.field_70170_p != null) {
            if (ctx.side == Side.SERVER) {
                player.func_184102_h().func_152344_a(() -> this.handle(message, player, player.field_70170_p));
            } else {
                ClientProxy.queTask(() -> this.handle(message, player, player.field_70170_p));
            }
        }
        return null;
    }

    protected void handle(ConfigSyncPacket message, EntityPlayer player, World world) {
        ModConfig config = ConfigLib.getConfig(message.modid, message.type);
        if (config == null) {
            System.out.println("Failed to find config: " + message.modid + "-" + message.type.name().toLowerCase(Locale.ROOT));
        } else {
            for (Map.Entry<String, Object> entry : message.values.entrySet()) {
                config.setSyncValue(entry.getKey(), entry.getValue());
            }
        }
    }
}

