/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.client.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.Util;
import com.vladmarica.energymeters.block.BlockEnergyMeter;
import com.vladmarica.energymeters.client.Sprites;
import com.vladmarica.energymeters.client.gui.GuiButtonConfigEnum;
import com.vladmarica.energymeters.client.gui.GuiButtonEnergyAlias;
import com.vladmarica.energymeters.client.gui.GuiButtonSideConfig;
import com.vladmarica.energymeters.client.gui.GuiIconButton;
import com.vladmarica.energymeters.client.gui.IHasTooltip;
import com.vladmarica.energymeters.client.gui.RelativeBlockSide;
import com.vladmarica.energymeters.client.model.TextureLocations;
import com.vladmarica.energymeters.energy.EnergyType;
import com.vladmarica.energymeters.network.PacketUpdateMeterConfig;
import com.vladmarica.energymeters.network.PacketUpdateMeterSides;
import com.vladmarica.energymeters.network.PacketUpdateRateLimit;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import com.vladmarica.energymeters.tile.config.EnumRedstoneControlState;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEnergyMeter
extends GuiScreen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("energymeters", "textures/gui/energymeter.png");
    private static final NumberFormat RATE_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private static final NumberFormat TOTAL_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 148;
    private static final int COLOR_GREY = 0x404040;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int CONFIG_BUTTONS_OFFSET_X = 168;
    private static final int CONFIG_BUTTONS_OFFSET_Y = 24;
    private GuiIconButton rateLimitButton;
    private GuiButtonEnergyAlias energyAliasButton;
    private GuiButtonConfigEnum<EnumRedstoneControlState> redstoneControlButton;
    private GuiButton setRateLimitButton;
    private TileEntityEnergyMeterBase tile;
    private BiMap<RelativeBlockSide, EnumFacing> sideToFaceMap;
    private Map<RelativeBlockSide, GuiButtonSideConfig> sideToButtonMap = new HashMap<RelativeBlockSide, GuiButtonSideConfig>();
    private ResourceLocation sideTexture;
    private ResourceLocation inputTexture;
    private ResourceLocation outputTexture;
    private ResourceLocation screenTexture;
    private GuiTextField rateLimitTextField;
    private boolean isEditingLimit = false;

    public GuiEnergyMeter(TileEntityEnergyMeterBase tile) {
        this.tile = tile;
        this.updateSideMapping();
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        BlockEnergyMeter.MeterType type = (BlockEnergyMeter.MeterType)((Object)state.func_177229_b(BlockEnergyMeter.PROP_TYPE));
        this.sideTexture = TextureLocations.getGuiResource(TextureLocations.getSideTexture(type));
        this.inputTexture = TextureLocations.getGuiResource(TextureLocations.getInputTexture(type));
        this.outputTexture = TextureLocations.getGuiResource(TextureLocations.getOutputTexture(type));
        this.screenTexture = TextureLocations.getGuiResource(TextureLocations.getScreenTexture(type));
    }

    private void updateSideMapping() {
        EnumFacing screenFace = this.tile.getScreenSide();
        this.sideToFaceMap = HashBiMap.create();
        this.sideToFaceMap.put((Object)RelativeBlockSide.TOP, (Object)EnumFacing.UP);
        this.sideToFaceMap.put((Object)RelativeBlockSide.BOTTOM, (Object)EnumFacing.DOWN);
        this.sideToFaceMap.put((Object)RelativeBlockSide.FRONT, (Object)screenFace);
        this.sideToFaceMap.put((Object)RelativeBlockSide.LEFT, (Object)Util.getLeftFace(screenFace));
        this.sideToFaceMap.put((Object)RelativeBlockSide.RIGHT, (Object)Util.getRightFace(screenFace));
        this.sideToFaceMap.put((Object)RelativeBlockSide.BACK, (Object)Util.getBackFace(screenFace));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 148) / 2;
        this.rateLimitButton = new GuiIconButton(0, x + 168, y + 24, Sprites.SPECTRAL_ARROW);
        this.field_146292_n.add(this.rateLimitButton);
        this.energyAliasButton = new GuiButtonEnergyAlias(1, x + 168 + 20 + 5, y + 24, this.tile.getEnergyAlias());
        this.field_146292_n.add(this.energyAliasButton);
        this.redstoneControlButton = new GuiButtonConfigEnum<EnumRedstoneControlState>(2, "Redstone Control", x + 168 + 40 + 10, y + 24, EnumRedstoneControlState.class, this.tile.getRedstoneControlState());
        this.field_146292_n.add(this.redstoneControlButton);
        int startX = 195;
        int startY = 87;
        this.sideToButtonMap = new HashMap<RelativeBlockSide, GuiButtonSideConfig>();
        this.sideToButtonMap.put(RelativeBlockSide.FRONT, new GuiButtonSideConfig(x + startX, y + startY, RelativeBlockSide.FRONT, this.screenTexture, true));
        this.sideToButtonMap.put(RelativeBlockSide.BACK, new GuiButtonSideConfig(x + startX + 20, y + startY + 20, RelativeBlockSide.BACK, this.screenTexture));
        this.sideToButtonMap.put(RelativeBlockSide.TOP, new GuiButtonSideConfig(x + startX, y + startY - 20, RelativeBlockSide.TOP, this.screenTexture));
        this.sideToButtonMap.put(RelativeBlockSide.BOTTOM, new GuiButtonSideConfig(x + startX, y + startY + 20, RelativeBlockSide.BOTTOM, this.screenTexture));
        this.sideToButtonMap.put(RelativeBlockSide.LEFT, new GuiButtonSideConfig(x + startX - 20, y + startY, RelativeBlockSide.LEFT, this.screenTexture));
        this.sideToButtonMap.put(RelativeBlockSide.RIGHT, new GuiButtonSideConfig(x + startX + 20, y + startY, RelativeBlockSide.RIGHT, this.screenTexture));
        this.updateConfigButtonTextures();
        this.rateLimitTextField = new GuiTextField(4, this.field_146289_q, x + 18, y + 67, 70, 12);
        this.rateLimitTextField.func_175205_a(Util::isValidRateLimitString);
        this.rateLimitTextField.func_146189_e(false);
        this.setRateLimitButton = new GuiButtonExt(3, x + 117, y + 65, 25, 16, "Set");
        this.field_146292_n.add(this.setRateLimitButton);
        this.setRateLimitButton.field_146125_m = false;
        if (!this.tile.getEnergyType().isLimitable()) {
            this.rateLimitButton.field_146124_l = false;
        }
    }

    private void updateConfigButtonTextures() {
        for (GuiButtonSideConfig button : this.sideToButtonMap.values()) {
            button.setTexture(this.getTextureForSide(button.getSide()));
        }
    }

    private ResourceLocation getTextureForSide(RelativeBlockSide side) {
        if (side == RelativeBlockSide.FRONT) {
            return this.screenTexture;
        }
        EnumFacing face = (EnumFacing)this.sideToFaceMap.get((Object)side);
        if (face == this.tile.getInputSide()) {
            return this.inputTexture;
        }
        if (face == this.tile.getOutputSide()) {
            return this.outputTexture;
        }
        return this.sideTexture;
    }

    public void func_73876_c() {
        if (this.tile.getEnergyType().isLimitable()) {
            this.rateLimitTextField.func_146178_a();
            this.rateLimitTextField.func_146189_e(this.isEditingLimit);
            this.rateLimitButton.field_146124_l = !this.isEditingLimit;
            this.setRateLimitButton.field_146125_m = this.isEditingLimit;
        }
        super.func_73876_c();
    }

    private String getStatusString() {
        if (!this.tile.isFullyConnected()) {
            return TextFormatting.GOLD + "Not Connected";
        }
        if (this.tile.isDisabled()) {
            return TextFormatting.RED + "Disabled";
        }
        return TextFormatting.GREEN + "Active";
    }

    private String getRateLimitString() {
        return this.tile.getRateLimit() == -1 ? "Unlimited" : Integer.toString(this.tile.getRateLimit());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 148) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(x, y, 0, 0, 256, 148);
        int titleWidth = this.field_146289_q.func_78256_a("Energy Meter");
        int titleX = (256 - titleWidth) / 2;
        this.field_146289_q.func_78276_b("Energy Meter", x + titleX, y + 7, 0x404040);
        int leftPanelOffset = 18;
        int statYIncr = 28;
        int statY = y + 28;
        String units = this.tile.getEnergyAlias().getDisplayName();
        this.field_146289_q.func_78276_b(TextFormatting.GRAY + "Transfer Rate", x + leftPanelOffset, statY, 0xFFFFFF);
        this.field_146289_q.func_78276_b(RATE_FORMAT.format(this.tile.getTransferRate() / (float)this.tile.getEnergyScale()) + " " + units + "/t", x + leftPanelOffset, statY + 11, 0xFFFFFF);
        this.field_146289_q.func_78276_b(TextFormatting.GRAY + "Transfer Rate Limit", x + leftPanelOffset, statY += statYIncr, 0xFFFFFF);
        if (!this.isEditingLimit) {
            this.field_146289_q.func_78276_b(this.getRateLimitString() + " " + units + "/t", x + leftPanelOffset, statY + 11, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b(TextFormatting.GRAY + "Total Transferred", x + leftPanelOffset, statY += statYIncr, 0xFFFFFF);
        this.field_146289_q.func_78276_b(TOTAL_FORMAT.format(this.tile.getTotalEnergyTransferred() / (long)this.tile.getEnergyScale()) + " " + units, x + leftPanelOffset, statY + 11, 0xFFFFFF);
        this.field_146289_q.func_78276_b(TextFormatting.GRAY + "Status", x + leftPanelOffset, statY += statYIncr, 0xFFFFFF);
        this.field_146289_q.func_78276_b(this.getStatusString(), x + leftPanelOffset, statY + 11, 0xFFFFFF);
        this.updateConfigButtonTextures();
        for (GuiButtonSideConfig sideConfigButton : this.sideToButtonMap.values()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            sideConfigButton.draw(mouseX, mouseY);
        }
        this.rateLimitTextField.func_146194_f();
        if (this.isEditingLimit) {
            this.field_146289_q.func_78276_b(this.energyAliasButton.getAlias().getDisplayName() + "/t", this.rateLimitTextField.field_146209_f + this.rateLimitTextField.field_146218_h + 4, this.rateLimitTextField.field_146210_g + 2, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButtonSideConfig sideConfigButton : this.sideToButtonMap.values()) {
            if (!sideConfigButton.isMouseHovered()) continue;
            ArrayList<String> lines = new ArrayList<String>(1);
            lines.add(sideConfigButton.getSide().getLabel());
            if (sideConfigButton.getSide() == RelativeBlockSide.FRONT) {
                lines.add(TextFormatting.GRAY + "Screen");
            }
            if (this.sideToFaceMap.get((Object)sideConfigButton.getSide()) == this.tile.getInputSide()) {
                lines.add(TextFormatting.GRAY + "Input");
            }
            if (this.sideToFaceMap.get((Object)sideConfigButton.getSide()) == this.tile.getOutputSide()) {
                lines.add(TextFormatting.GRAY + "Output");
            }
            this.func_146283_a(lines, mouseX, mouseY);
            break;
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof IHasTooltip) || !button.func_146115_a()) continue;
            this.func_146283_a(((IHasTooltip)button).getTooltipLines(), mouseX, mouseY);
        }
        if (this.rateLimitButton.func_146115_a()) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Transfer Rate Limit");
            lines.add(TextFormatting.GRAY + this.getRateLimitString() + " " + units + "/t");
            if (!this.tile.getEnergyType().isLimitable()) {
                lines.add(TextFormatting.RED + this.tile.getEnergyType().getName() + " meters cannot be limited");
            }
            this.func_146283_a(lines, mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            String str;
            for (GuiButtonSideConfig button : this.sideToButtonMap.values()) {
                if (button.isDisabled() || !button.isMouseHovered()) continue;
                this.sideConfigButtonClicked(button);
                break;
            }
            if (this.setRateLimitButton.func_146115_a() && this.setRateLimitButton.field_146125_m && this.tile.getEnergyType().isLimitable() && this.isEditingLimit && Util.isValidRateLimitString(str = this.rateLimitTextField.func_146179_b())) {
                int rateLimit = str.isEmpty() ? -1 : Integer.parseInt(str);
                this.isEditingLimit = false;
                this.tile.setRateLimit(rateLimit);
                EnergyMetersMod.NETWORK.sendToServer((IMessage)new PacketUpdateRateLimit(this.tile.func_174877_v(), rateLimit));
            }
            if (this.rateLimitButton.func_146115_a() && this.tile.getEnergyType().isLimitable() && !this.isEditingLimit) {
                this.isEditingLimit = true;
                this.rateLimitTextField.func_146180_a(this.tile.getRateLimit() == -1 ? "" : Integer.toString(this.tile.getRateLimit()));
            }
            this.rateLimitTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.rateLimitTextField.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private void sideConfigButtonClicked(GuiButtonSideConfig button) {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        EnumFacing face = (EnumFacing)this.sideToFaceMap.get((Object)button.getSide());
        if (face == this.tile.getInputSide()) {
            this.tile.setOutputSide(face);
            this.tile.setInputSide(null);
        } else if (face == this.tile.getOutputSide()) {
            this.tile.setOutputSide(null);
        } else if (this.tile.getInputSide() != null && this.tile.getOutputSide() == null) {
            this.tile.setOutputSide(face);
        } else {
            this.tile.setInputSide(face);
        }
        EnergyMetersMod.NETWORK.sendToServer((IMessage)new PacketUpdateMeterSides(this.tile.func_174877_v(), this.tile.getInputSide(), this.tile.getOutputSide()));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        boolean sendUpdatePacket = false;
        if (button == this.redstoneControlButton) {
            EnumRedstoneControlState newState = this.redstoneControlButton.cycle();
            this.tile.setRedstoneControlState(newState);
            sendUpdatePacket = true;
        }
        if (button == this.energyAliasButton) {
            EnergyType.EnergyAlias newAlias = this.energyAliasButton.cycle();
            this.tile.setEnergyAlias(newAlias);
            sendUpdatePacket = true;
        }
        if (sendUpdatePacket) {
            EnergyMetersMod.NETWORK.sendToServer((IMessage)new PacketUpdateMeterConfig(this.tile.func_174877_v(), this.tile.getRedstoneControlState(), this.tile.getEnergyAlias().getIndex()));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        RATE_FORMAT.setMinimumFractionDigits(1);
        RATE_FORMAT.setMaximumFractionDigits(1);
        TOTAL_FORMAT.setMaximumFractionDigits(0);
    }
}

