/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.client.model;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TexturedQuadCache {
    public static final TexturedQuadCache INSTANCE = new TexturedQuadCache();
    private Map<ResourceLocation, TextureAtlasSprite> spriteMap;
    private Map<EnumFacing, BakedQuad> cubeQuadMap;
    private Map<EnumFacing, Map<ResourceLocation, BakedQuadRetextured>> texturedQuadCache = new HashMap<EnumFacing, Map<ResourceLocation, BakedQuadRetextured>>();

    public BakedQuadRetextured getBakedQuad(EnumFacing side, ResourceLocation texture) {
        if (this.texturedQuadCache.get(side).containsKey(texture)) {
            return this.texturedQuadCache.get(side).get(texture);
        }
        BakedQuadRetextured retexturedQuad = this.buildRetexturedQuad(side, texture);
        this.texturedQuadCache.get(side).put(texture, retexturedQuad);
        return retexturedQuad;
    }

    private BakedQuadRetextured buildRetexturedQuad(EnumFacing side, ResourceLocation texture) {
        BakedQuad originalQuad = this.cubeQuadMap.get(side);
        TextureAtlasSprite sprite = this.spriteMap.get(texture);
        return new BakedQuadRetextured(originalQuad, sprite);
    }

    public void setTextureMap(Map<ResourceLocation, TextureAtlasSprite> spriteMap) {
        this.spriteMap = spriteMap;
    }

    public void setCubeQuadMap(Map<EnumFacing, BakedQuad> cubeQuadMap) {
        if (cubeQuadMap.size() != 6) {
            throw new RuntimeException(String.format("Cube quad map has %d quads, expected 6", cubeQuadMap.size()));
        }
        this.cubeQuadMap = cubeQuadMap;
        for (EnumFacing side : this.cubeQuadMap.keySet()) {
            this.texturedQuadCache.put(side, new HashMap());
        }
    }

    private TexturedQuadCache() {
    }
}

