/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain.config;

import java.time.MonthDay;
import java.util.ArrayList;
import java.util.List;
import naqaden.namepain.NamePain;
import naqaden.namepain.Util;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static List<IConfigElement> configElements;
    private static ConfigCategory confCatSettings;
    public static boolean applyToMobs;
    public static boolean seeInjuredNames;
    public static boolean injuredAlwaysNamed;
    public static boolean tamesAlwaysNamed;
    public static boolean villagersAlwaysNamed;
    public static boolean seeYourName;
    public static boolean applyToScores;
    public static boolean stripFormat;
    public static boolean namesWithoutHUD;
    public static int visibleRange;
    private static ConfigCategory confCatNameMax;
    public static int nameMaxR;
    public static int nameMaxG;
    public static int nameMaxB;
    public static int nameMaxA;
    private static ConfigCategory confCatNameMin;
    public static int nameMinR;
    public static int nameMinG;
    public static int nameMinB;
    public static int nameMinA;
    private static ConfigCategory confCatPlateMax;
    public static int plateMaxR;
    public static int plateMaxG;
    public static int plateMaxB;
    public static int plateMaxA;
    private static ConfigCategory confCatPlateMin;
    public static int plateMinR;
    public static int plateMinG;
    public static int plateMinB;
    public static int plateMinA;
    private static ConfigCategory confCatSurprise;
    private static String strCatSurprise;
    public static boolean doValentines;
    public static boolean doAprilFools;
    public static Class<?> playerClass;
    public static int visibleRangeSq;
    public static float nameMaxV;
    public static float nameMinV;
    public static float plateMaxV;
    public static float plateMinV;

    public static Property getProperty(Configuration config, String category, String key, String defaultValue, Property.Type type) {
        ConfigCategory cat = config.getCategory(category);
        if (cat.containsKey(key)) {
            Property prop = cat.get(key);
            if (prop.getType() != type) {
                prop = new Property(prop.getName(), prop.getString(), type);
                cat.put(key, prop);
            }
            prop.setDefaultValue(defaultValue);
            return prop;
        }
        if (defaultValue != null) {
            Property prop = new Property(key, defaultValue, type);
            prop.setValue(defaultValue);
            cat.put(key, prop);
            prop.setDefaultValue(defaultValue);
            return prop;
        }
        return null;
    }

    public static boolean getBoolean(Configuration config, String category, String name, boolean defaultValue, String comment) {
        Property prop = Config.getProperty(config, category, name, Boolean.toString(defaultValue), Property.Type.BOOLEAN);
        prop.setLanguageKey(name);
        prop.setComment(comment);
        try {
            return Boolean.parseBoolean(prop.getString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static int getInt(Configuration config, String category, String name, int defaultValue, int minValue, int maxValue, String comment) {
        Property prop = Config.getProperty(config, category, name, Integer.toString(defaultValue), Property.Type.INTEGER);
        prop.setLanguageKey(name);
        prop.setComment(comment);
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        try {
            int parseInt = Integer.parseInt(prop.getString());
            return parseInt < minValue ? minValue : (parseInt > maxValue ? maxValue : parseInt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static float getFloat(Configuration config, String category, String name, float defaultValue, float minValue, float maxValue, String comment) {
        Property prop = Config.getProperty(config, category, name, Float.toString(defaultValue), Property.Type.DOUBLE);
        prop.setLanguageKey(name);
        prop.setComment(comment);
        prop.setMinValue((double)minValue);
        prop.setMaxValue((double)maxValue);
        try {
            float parseFloat = Float.parseFloat(prop.getString());
            return parseFloat < minValue ? minValue : (parseFloat > maxValue ? maxValue : parseFloat);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("namepain")) {
            Config.reload();
        }
    }

    public static void reload() {
        try {
            if (NamePain.config.hasChanged()) {
                NamePain.config.save();
            }
            NamePain.config.load();
            Config.initCategories();
        }
        catch (Exception ex) {
            System.out.println("Problem accessing " + NamePain.configFile.getAbsolutePath() + ":");
            ex.printStackTrace(System.out);
        }
        finally {
            if (NamePain.config.hasChanged()) {
                NamePain.config.save();
            }
        }
    }

    public static void initCategories() {
        configElements = new ArrayList<IConfigElement>();
        String strCatSettings = I18n.func_135052_a((String)"config.namepain.settings", (Object[])new Object[0]);
        ArrayList<String> strOrderSettings = new ArrayList<String>(10);
        confCatSettings = NamePain.config.getCategory(strCatSettings);
        confCatSettings.setComment(Config.forgeComment("config.namepain.settings.comment"));
        String strApplyToMobs = I18n.func_135052_a((String)"config.namepain.applyToMobs", (Object[])new Object[0]);
        strOrderSettings.add(strApplyToMobs);
        applyToMobs = Config.getBoolean(NamePain.config, strCatSettings, strApplyToMobs, applyToMobs, Config.forgeComment("config.namepain.applyToMobs.comment", "false"));
        String strSeeInjuredNames = I18n.func_135052_a((String)"config.namepain.seeInjuredNames", (Object[])new Object[0]);
        strOrderSettings.add(strSeeInjuredNames);
        seeInjuredNames = Config.getBoolean(NamePain.config, strCatSettings, strSeeInjuredNames, seeInjuredNames, Config.forgeComment("config.namepain.seeInjuredNames.comment", "false"));
        String strInjuredAlwaysNamed = I18n.func_135052_a((String)"config.namepain.injuredAlwaysNamed", (Object[])new Object[0]);
        strOrderSettings.add(strInjuredAlwaysNamed);
        injuredAlwaysNamed = Config.getBoolean(NamePain.config, strCatSettings, strInjuredAlwaysNamed, injuredAlwaysNamed, Config.forgeComment("config.namepain.injuredAlwaysNamed.comment"));
        String strTamesAlwaysNamed = I18n.func_135052_a((String)"config.namepain.tamesAlwaysNamed", (Object[])new Object[0]);
        strOrderSettings.add(strTamesAlwaysNamed);
        tamesAlwaysNamed = Config.getBoolean(NamePain.config, strCatSettings, strTamesAlwaysNamed, tamesAlwaysNamed, Config.forgeComment("config.namepain.tamesAlwaysNamed.comment", "false"));
        String strVillagersAlwaysNamed = I18n.func_135052_a((String)"config.namepain.villagersAlwaysNamed", (Object[])new Object[0]);
        strOrderSettings.add(strVillagersAlwaysNamed);
        villagersAlwaysNamed = Config.getBoolean(NamePain.config, strCatSettings, strVillagersAlwaysNamed, villagersAlwaysNamed, Config.forgeComment("config.namepain.villagersAlwaysNamed.comment", "false"));
        String strSeeYourName = I18n.func_135052_a((String)"config.namepain.seeYourName", (Object[])new Object[0]);
        strOrderSettings.add(strSeeYourName);
        playerClass = Config.getBoolean(NamePain.config, strCatSettings, strSeeYourName, seeYourName, Config.forgeComment("config.namepain.seeYourName.comment", "false")) ? AbstractClientPlayer.class : EntityOtherPlayerMP.class;
        String strApplyToScores = I18n.func_135052_a((String)"config.namepain.applyToScores", (Object[])new Object[0]);
        strOrderSettings.add(strApplyToScores);
        applyToScores = Config.getBoolean(NamePain.config, strCatSettings, strApplyToScores, applyToScores, Config.forgeComment("config.namepain.applyToScores.comment", "false"));
        String strStripFormat = I18n.func_135052_a((String)"config.namepain.stripFormat", (Object[])new Object[0]);
        strOrderSettings.add(strStripFormat);
        stripFormat = Config.getBoolean(NamePain.config, strCatSettings, strStripFormat, stripFormat, Config.forgeComment("config.namepain.stripFormat.comment", "false"));
        String strShowWithoutHUD = I18n.func_135052_a((String)"config.namepain.namesWithoutHUD", (Object[])new Object[0]);
        strOrderSettings.add(strShowWithoutHUD);
        namesWithoutHUD = Config.getBoolean(NamePain.config, strCatSettings, strShowWithoutHUD, namesWithoutHUD, Config.forgeComment("config.namepain.namesWithoutHUD.comment", "false"));
        String strVisibleRange = I18n.func_135052_a((String)"config.namepain.visibleRange", (Object[])new Object[0]);
        strOrderSettings.add(strVisibleRange);
        visibleRangeSq = (int)Math.pow(Config.getInt(NamePain.config, strCatSettings, strVisibleRange, visibleRange, 0, 64, Config.forgeComment("config.namepain.visibleRange.comment", "64")), 2.0);
        confCatSettings.get(strVisibleRange).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        Config.finishCategory(configElements, confCatSettings, strOrderSettings);
        ArrayList<String> strOrderRGBA = new ArrayList<String>();
        strOrderRGBA.add(I18n.func_135052_a((String)"config.namepain.colorR", (Object[])new Object[0]));
        strOrderRGBA.add(I18n.func_135052_a((String)"config.namepain.colorG", (Object[])new Object[0]));
        strOrderRGBA.add(I18n.func_135052_a((String)"config.namepain.colorB", (Object[])new Object[0]));
        strOrderRGBA.add(I18n.func_135052_a((String)"config.namepain.colorA", (Object[])new Object[0]));
        String strCatNameMax = I18n.func_135052_a((String)"config.namepain.nameMax", (Object[])new Object[0]);
        confCatNameMax = NamePain.config.getCategory(strCatNameMax);
        confCatNameMax.setComment(Config.forgeComment("config.namepain.nameMax.comment"));
        nameMaxR = Config.getInt(NamePain.config, strCatNameMax, I18n.func_135052_a((String)"config.namepain.colorR", (Object[])new Object[0]), nameMaxR, 0, 255, Config.forgeComment("", "255"));
        nameMaxG = Config.getInt(NamePain.config, strCatNameMax, I18n.func_135052_a((String)"config.namepain.colorG", (Object[])new Object[0]), nameMaxG, 0, 255, Config.forgeComment("", "255"));
        nameMaxB = Config.getInt(NamePain.config, strCatNameMax, I18n.func_135052_a((String)"config.namepain.colorB", (Object[])new Object[0]), nameMaxB, 0, 255, Config.forgeComment("", "255"));
        nameMaxA = Math.round(255.0f * Config.getFloat(NamePain.config, strCatNameMax, I18n.func_135052_a((String)"config.namepain.colorA", (Object[])new Object[0]), 1.0f, 0.0f, 1.0f, Config.forgeComment("config.namepain.colorA.comment", "1.0")));
        nameMaxV = Util.getVibrancy(nameMaxR, nameMaxG, nameMaxB);
        Config.rgbaSliders(confCatNameMax);
        Config.finishCategory(configElements, confCatNameMax, strOrderRGBA);
        String strCatNameMin = I18n.func_135052_a((String)"config.namepain.nameMin", (Object[])new Object[0]);
        confCatNameMin = NamePain.config.getCategory(strCatNameMin);
        confCatNameMin.setComment(Config.forgeComment("config.namepain.nameMin.comment"));
        nameMinR = Config.getInt(NamePain.config, strCatNameMin, I18n.func_135052_a((String)"config.namepain.colorR", (Object[])new Object[0]), nameMinR, 0, 255, Config.forgeComment("", "255"));
        nameMinG = Config.getInt(NamePain.config, strCatNameMin, I18n.func_135052_a((String)"config.namepain.colorG", (Object[])new Object[0]), nameMinG, 0, 255, Config.forgeComment("", "255"));
        nameMinB = Config.getInt(NamePain.config, strCatNameMin, I18n.func_135052_a((String)"config.namepain.colorB", (Object[])new Object[0]), nameMinB, 0, 255, Config.forgeComment("", "255"));
        nameMinA = Math.round(255.0f * Config.getFloat(NamePain.config, strCatNameMin, I18n.func_135052_a((String)"config.namepain.colorA", (Object[])new Object[0]), 1.0f, 0.0f, 1.0f, Config.forgeComment("config.namepain.colorA.comment", "1.0")));
        nameMinV = Util.getVibrancy(nameMinR, nameMinG, nameMinB);
        Config.rgbaSliders(confCatNameMin);
        Config.finishCategory(configElements, confCatNameMin, strOrderRGBA);
        String strCatPlateMax = I18n.func_135052_a((String)"config.namepain.plateMax", (Object[])new Object[0]);
        confCatPlateMax = NamePain.config.getCategory(strCatPlateMax);
        confCatPlateMax.setComment(Config.forgeComment("config.namepain.plateMax.comment"));
        plateMaxR = Config.getInt(NamePain.config, strCatPlateMax, I18n.func_135052_a((String)"config.namepain.colorR", (Object[])new Object[0]), plateMaxR, 0, 255, Config.forgeComment("", "255"));
        plateMaxG = Config.getInt(NamePain.config, strCatPlateMax, I18n.func_135052_a((String)"config.namepain.colorG", (Object[])new Object[0]), plateMaxG, 0, 255, Config.forgeComment("", "255"));
        plateMaxB = Config.getInt(NamePain.config, strCatPlateMax, I18n.func_135052_a((String)"config.namepain.colorB", (Object[])new Object[0]), plateMaxB, 0, 255, Config.forgeComment("", "255"));
        plateMaxA = Math.round(255.0f * Config.getFloat(NamePain.config, strCatPlateMax, I18n.func_135052_a((String)"config.namepain.colorA", (Object[])new Object[0]), 0.25f, 0.0f, 1.0f, Config.forgeComment("config.namepain.colorA.comment", "0.25")));
        plateMaxV = Util.getVibrancy(plateMaxR, plateMaxG, plateMaxB);
        Config.rgbaSliders(confCatPlateMax);
        Config.finishCategory(configElements, confCatPlateMax, strOrderRGBA);
        String strCatPlateMin = I18n.func_135052_a((String)"config.namepain.plateMin", (Object[])new Object[0]);
        confCatPlateMin = NamePain.config.getCategory(strCatPlateMin);
        confCatPlateMin.setComment(Config.forgeComment("config.namepain.plateMin.comment"));
        plateMinR = Config.getInt(NamePain.config, strCatPlateMin, I18n.func_135052_a((String)"config.namepain.colorR", (Object[])new Object[0]), plateMinR, 0, 255, Config.forgeComment("", "255"));
        plateMinG = Config.getInt(NamePain.config, strCatPlateMin, I18n.func_135052_a((String)"config.namepain.colorG", (Object[])new Object[0]), plateMinG, 0, 255, Config.forgeComment("", "255"));
        plateMinB = Config.getInt(NamePain.config, strCatPlateMin, I18n.func_135052_a((String)"config.namepain.colorB", (Object[])new Object[0]), plateMinB, 0, 255, Config.forgeComment("", "255"));
        plateMinA = Math.round(255.0f * Config.getFloat(NamePain.config, strCatPlateMin, I18n.func_135052_a((String)"config.namepain.colorA", (Object[])new Object[0]), 0.25f, 0.0f, 1.0f, Config.forgeComment("config.namepain.colorA.comment", "0.25")));
        plateMinV = Util.getVibrancy(plateMinR, plateMinG, plateMinB);
        Config.rgbaSliders(confCatPlateMin);
        Config.finishCategory(configElements, confCatPlateMin, strOrderRGBA);
        if (Config.isValentines() || Config.isAprilFools()) {
            confCatSurprise = NamePain.config.getCategory(strCatSurprise);
            if (Config.isValentines()) {
                doValentines = Config.getBoolean(NamePain.config, strCatSurprise, I18n.func_135052_a((String)"config.namepain.doValentines", (Object[])new Object[0]), true, Config.forgeComment("config.namepain.doValentines.comment"));
            } else if (Config.isAprilFools()) {
                doAprilFools = Config.getBoolean(NamePain.config, strCatSurprise, I18n.func_135052_a((String)"config.namepain.doAprilFools", (Object[])new Object[0]), true, Config.forgeComment("config.namepain.doAprilFools.comment"));
            }
            configElements.add((IConfigElement)new ConfigElement(confCatSurprise));
        }
    }

    private static String forgeComment(String key) {
        return Config.forgeComment(key, "");
    }

    private static String forgeComment(String key, String vanilla) {
        int line = 0;
        String comment = "";
        while (!I18n.func_135052_a((String)(key + line), (Object[])new Object[0]).equals(key + line)) {
            comment = comment + (line == 0 ? TextFormatting.RESET : "\n") + I18n.func_135052_a((String)(key + line), (Object[])new Object[0]);
            ++line;
        }
        if (!vanilla.isEmpty()) {
            comment = comment + (line == 0 ? TextFormatting.RESET : "\n") + I18n.func_135052_a((String)"config.namepain.vanilla", (Object[])new Object[]{vanilla});
            ++line;
        }
        return comment;
    }

    private static void rgbaSliders(ConfigCategory cat) {
        cat.get(I18n.func_135052_a((String)"config.namepain.colorR", (Object[])new Object[0])).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        cat.get(I18n.func_135052_a((String)"config.namepain.colorG", (Object[])new Object[0])).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        cat.get(I18n.func_135052_a((String)"config.namepain.colorB", (Object[])new Object[0])).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        cat.get(I18n.func_135052_a((String)"config.namepain.colorA", (Object[])new Object[0])).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
    }

    private static void finishCategory(List<IConfigElement> elements, ConfigCategory cat, List<String> order) {
        for (String optionFromFile : cat.getPropertyOrder()) {
            if (order.contains(optionFromFile)) continue;
            cat.remove((Object)optionFromFile);
        }
        cat.setPropertyOrder(order);
        elements.add((IConfigElement)new ConfigElement(cat));
    }

    public static boolean isValentines() {
        return MonthDay.now().getMonthValue() == 2 && MonthDay.now().getDayOfMonth() == 14;
    }

    public static boolean isAprilFools() {
        return MonthDay.now().getMonthValue() == 4 && MonthDay.now().getDayOfMonth() == 1;
    }

    static {
        applyToMobs = true;
        seeInjuredNames = false;
        injuredAlwaysNamed = false;
        tamesAlwaysNamed = true;
        villagersAlwaysNamed = true;
        seeYourName = false;
        applyToScores = false;
        stripFormat = false;
        namesWithoutHUD = false;
        visibleRange = 64;
        nameMaxR = 255;
        nameMaxG = 255;
        nameMaxB = 255;
        nameMaxA = 255;
        nameMinR = 255;
        nameMinG = 0;
        nameMinB = 0;
        nameMinA = 255;
        plateMaxR = 0;
        plateMaxG = 0;
        plateMaxB = 0;
        plateMaxA = 32;
        plateMinR = 192;
        plateMinG = 0;
        plateMinB = 0;
        plateMinA = 32;
        strCatSurprise = "?";
        doValentines = false;
        doAprilFools = false;
        playerClass = EntityOtherPlayerMP.class;
        visibleRangeSq = 4096;
        nameMaxV = 255.0f;
        nameMinV = 255.0f;
        plateMaxV = 0.0f;
        plateMinV = 192.0f;
    }
}

