/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.ClientProxy;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkLoaderBlock
extends Block {
    public static final AxisAlignedBB SINGLE_SHAPE = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    public static final AxisAlignedBB BASIC_SHAPE = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    public static final AxisAlignedBB ADVANCED_SHAPE = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125);
    public static final AxisAlignedBB ULTIMATE_SHAPE = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125);
    private final AxisAlignedBB shape;
    private final Supplier<? extends TileEntity> tileProvider;
    private final int gridSize;

    public ChunkLoaderBlock(String registryName, AxisAlignedBB shape, Supplier<? extends TileEntity> tileProvider, int gridSize) {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.setRegistryName(registryName);
        this.func_149663_c("chunkloaders." + registryName);
        this.func_149711_c(1.5f);
        this.func_149752_b(6.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(CreativeTabs.field_78027_g);
        this.shape = shape;
        this.tileProvider = tileProvider;
        this.gridSize = gridSize;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            ClientProxy.openScreen(this, worldIn, pos);
        }
        return true;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.shape;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.shape;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.tileProvider.get();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ChunkLoaderTile) {
            ((ChunkLoaderTile)tile).loadAll();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ChunkLoaderTile) {
            ((ChunkLoaderTile)tile).unloadAll();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.gridSize == 1) {
            tooltip.add(new TextComponentTranslation("chunkloaders.chunk_loader.info.single", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("chunkloaders.chunk_loader.info.multiple", new Object[]{this.gridSize}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150254_d());
        }
    }
}

