/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderUtil;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;

public class ChunkLoaderTile
extends TileEntity {
    public final int animationOffset = new Random().nextInt(20000);
    private int gridSize;
    private int radius;
    private boolean[][] grid;
    private boolean dataChanged = false;

    public ChunkLoaderTile(int gridSize) {
        this.gridSize = gridSize;
        this.radius = (gridSize - 1) / 2;
        this.grid = new boolean[gridSize][gridSize];
    }

    public void unloadAll() {
        ChunkLoaderUtil.ChunkTracker tracker = (ChunkLoaderUtil.ChunkTracker)this.field_145850_b.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY, null);
        if (tracker != null) {
            ChunkPos pos = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
            for (int x = 0; x < this.gridSize; ++x) {
                for (int z = 0; z < this.gridSize; ++z) {
                    if (!this.grid[x][z]) continue;
                    tracker.remove(new ChunkPos(pos.field_77276_a + x - this.radius, pos.field_77275_b + z - this.radius), this.field_174879_c);
                }
            }
        }
    }

    public void loadAll() {
        ChunkLoaderUtil.ChunkTracker tracker = (ChunkLoaderUtil.ChunkTracker)this.field_145850_b.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY, null);
        if (tracker != null) {
            ChunkPos pos = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
            for (int x = 0; x < this.gridSize; ++x) {
                for (int z = 0; z < this.gridSize; ++z) {
                    this.grid[x][z] = true;
                    tracker.add(new ChunkPos(pos.field_77276_a + x - this.radius, pos.field_77275_b + z - this.radius), this.field_174879_c);
                }
            }
        }
        this.dataChanged();
    }

    public void toggle(int xOffset, int zOffset) {
        ChunkLoaderUtil.ChunkTracker tracker = (ChunkLoaderUtil.ChunkTracker)this.field_145850_b.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY, null);
        if (tracker != null) {
            ChunkPos pos = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
            if (this.grid[xOffset + this.radius][zOffset + this.radius]) {
                tracker.remove(new ChunkPos(pos.field_77276_a + xOffset, pos.field_77275_b + zOffset), this.field_174879_c);
            } else {
                tracker.add(new ChunkPos(pos.field_77276_a + xOffset, pos.field_77275_b + zOffset), this.field_174879_c);
            }
            this.grid[xOffset + this.radius][zOffset + this.radius] = !this.grid[xOffset + this.radius][zOffset + this.radius];
        }
        this.dataChanged();
    }

    public boolean isLoaded(int xOffset, int zOffset) {
        return this.grid[xOffset + this.radius][zOffset + this.radius];
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void dataChanged() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.dataChanged = true;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 2);
    }

    private NBTTagCompound getChangedData() {
        if (this.dataChanged) {
            this.dataChanged = false;
            return this.getData();
        }
        return null;
    }

    private NBTTagCompound getData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("gridSize", this.gridSize);
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                tag.func_74757_a(x + ";" + z, this.grid[x][z]);
            }
        }
        return tag;
    }

    private void handleData(NBTTagCompound tag) {
        int n = tag.func_74764_b("gridSize") ? tag.func_74762_e("gridSize") : (this instanceof SingleChunkLoaderTile ? 1 : (this instanceof BasicChunkLoaderTile ? 3 : (this instanceof AdvancedChunkLoaderTile ? 5 : (this.gridSize = this instanceof UltimateChunkLoaderTile ? 7 : -1))));
        if (this.gridSize < 1 || this.gridSize % 2 == 0) {
            this.gridSize = 1;
        }
        this.radius = (this.gridSize - 1) / 2;
        this.grid = new boolean[this.gridSize][this.gridSize];
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                this.grid[x][z] = tag.func_74764_b(x + ";" + z) && tag.func_74767_n(x + ";" + z);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("data", (NBTBase)this.getData());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handleData(compound.func_74775_l("data"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("data", (NBTBase)this.getData());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.handleData(tag.func_74775_l("data"));
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.getChangedData();
        return tag == null || tag.func_82582_d() ? null : new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleData(pkt.func_148857_g());
    }

    private IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public static class UltimateChunkLoaderTile
    extends ChunkLoaderTile {
        public UltimateChunkLoaderTile() {
            super(ChunkLoadersConfig.ultimateChunkLoaderRadius.get() * 2 - 1);
        }
    }

    public static class AdvancedChunkLoaderTile
    extends ChunkLoaderTile {
        public AdvancedChunkLoaderTile() {
            super(ChunkLoadersConfig.advancedChunkLoaderRadius.get() * 2 - 1);
        }
    }

    public static class BasicChunkLoaderTile
    extends ChunkLoaderTile {
        public BasicChunkLoaderTile() {
            super(ChunkLoadersConfig.basicChunkLoaderRadius.get() * 2 - 1);
        }
    }

    public static class SingleChunkLoaderTile
    extends ChunkLoaderTile {
        public SingleChunkLoaderTile() {
            super(ChunkLoadersConfig.singleChunkLoaderRadius.get() * 2 - 1);
        }
    }
}

