/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ChunkLoaderUtil {
    @CapabilityInject(value=ChunkTracker.class)
    public static Capability<ChunkTracker> TRACKER_CAPABILITY;

    public static void register() {
        CapabilityManager.INSTANCE.register(ChunkTracker.class, (Capability.IStorage)new Capability.IStorage<ChunkTracker>(){

            public NBTBase writeNBT(Capability<ChunkTracker> capability, ChunkTracker instance, EnumFacing side) {
                return instance.write();
            }

            public void readNBT(Capability<ChunkTracker> capability, ChunkTracker instance, EnumFacing side, NBTBase nbt) {
                instance.read((NBTTagCompound)nbt);
            }
        }, ChunkTracker::new);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ChunkLoaders.instance, (tickets, world) -> {
            ChunkTracker tracker;
            if (tickets.size() > 0 && (tracker = (ChunkTracker)world.getCapability(TRACKER_CAPABILITY, null)) != null) {
                tracker.invalidateTicket();
                tracker.ticket = (ForgeChunkManager.Ticket)tickets.get(0);
            }
        });
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        final ChunkTracker tracker = new ChunkTracker((WorldServer)world);
        e.addCapability(new ResourceLocation("chunkloaders", "chunk_tracker"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){

            public NBTBase serializeNBT() {
                return TRACKER_CAPABILITY.writeNBT((Object)tracker, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                TRACKER_CAPABILITY.readNBT((Object)tracker, null, nbt);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == TRACKER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(capability == TRACKER_CAPABILITY ? TRACKER_CAPABILITY.cast((Object)tracker) : null);
            }
        });
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load e) {
        ChunkTracker tracker = (ChunkTracker)e.getWorld().getCapability(TRACKER_CAPABILITY, null);
        if (tracker != null) {
            for (Pair pair : tracker.pending) {
                tracker.add((ChunkPos)pair.getKey(), (BlockPos)pair.getValue());
            }
            tracker.pending.clear();
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload e) {
        World world = e.getWorld();
        ChunkTracker tracker = (ChunkTracker)world.getCapability(TRACKER_CAPABILITY, null);
        if (tracker != null) {
            tracker.invalidateTicket();
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !(e.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)e.world;
        int tickSpeed = world.func_82736_K().func_180263_c("randomTickSpeed");
        ChunkTracker tracker = (ChunkTracker)world.getCapability(TRACKER_CAPABILITY, null);
        if (tickSpeed > 0 && tracker != null) {
            for (ChunkPos pos : tracker.chunks.keySet()) {
                if (world.func_184164_w().func_152621_a(pos.field_77276_a, pos.field_77275_b)) continue;
                ChunkLoaderUtil.tickEnvironment(world, pos, tickSpeed);
            }
        }
    }

    private static void tickEnvironment(WorldServer world, ChunkPos pos, int tickSpeed) {
        Chunk chunk = world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
        int j = chunk.field_76635_g * 16;
        int k = chunk.field_76647_h * 16;
        for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
            if (extendedblockstorage == Chunk.field_186036_a || !extendedblockstorage.func_76675_b()) continue;
            for (int i1 = 0; i1 < tickSpeed; ++i1) {
                int z;
                int y;
                int x = world.field_73012_v.nextInt(16);
                IBlockState iblockstate = extendedblockstorage.func_177485_a(x, y = world.field_73012_v.nextInt(16), z = world.field_73012_v.nextInt(16));
                Block block = iblockstate.func_177230_c();
                if (!block.func_149653_t()) continue;
                block.func_180645_a((World)world, new BlockPos(j + x, extendedblockstorage.func_76662_d() + y, k + z), iblockstate, world.field_73012_v);
            }
        }
    }

    public static class ChunkTracker {
        private final WorldServer world;
        private final Map<ChunkPos, List<BlockPos>> chunks = new HashMap<ChunkPos, List<BlockPos>>();
        private final LinkedList<Pair<ChunkPos, BlockPos>> pending = new LinkedList();
        private ForgeChunkManager.Ticket ticket;

        public ChunkTracker(WorldServer world) {
            this.world = world;
        }

        public ChunkTracker() {
            this.world = null;
        }

        public void add(ChunkPos chunk, BlockPos loader) {
            if (this.chunks.containsKey(chunk) && this.chunks.get(chunk).contains(loader)) {
                return;
            }
            if (!this.chunks.containsKey(chunk)) {
                this.chunks.put(chunk, new LinkedList());
                if (this.ticket == null) {
                    this.ticket = ForgeChunkManager.requestTicket((Object)ChunkLoaders.instance, (World)this.world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)chunk);
            }
            this.chunks.get(chunk).add(loader);
        }

        public void remove(ChunkPos chunk, BlockPos loader) {
            if (!this.chunks.containsKey(chunk) || !this.chunks.get(chunk).contains(loader)) {
                return;
            }
            if (this.chunks.get(chunk).size() == 1) {
                if (this.ticket == null) {
                    this.ticket = ForgeChunkManager.requestTicket((Object)ChunkLoaders.instance, (World)this.world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                }
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)chunk);
                this.chunks.remove(chunk);
            } else {
                this.chunks.get(chunk).remove(loader);
            }
        }

        public NBTTagCompound write() {
            NBTTagCompound compound = new NBTTagCompound();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                NBTTagCompound chunkTag = new NBTTagCompound();
                chunkTag.func_74768_a("chunkX", entry.getKey().field_77276_a);
                chunkTag.func_74768_a("chunkY", entry.getKey().field_77275_b);
                ArrayList coords = new ArrayList(entry.getValue().size() * 3);
                entry.getValue().forEach(pos -> {
                    coords.add(pos.func_177958_n());
                    coords.add(pos.func_177956_o());
                    coords.add(pos.func_177952_p());
                });
                NBTTagIntArray blocks = new NBTTagIntArray(coords);
                chunkTag.func_74782_a("blocks", (NBTBase)blocks);
                compound.func_74782_a(entry.getKey().field_77276_a + ";" + entry.getKey().field_77275_b, (NBTBase)chunkTag);
            }
            return compound;
        }

        public void read(NBTTagCompound compound) {
            for (String key : compound.func_150296_c()) {
                NBTTagCompound chunkTag = compound.func_74775_l(key);
                ChunkPos chunk = new ChunkPos(chunkTag.func_74762_e("chunkX"), chunkTag.func_74762_e("chunkY"));
                NBTTagIntArray blocks = (NBTTagIntArray)chunkTag.func_74781_a("blocks");
                int[] arr = blocks.func_150302_c();
                for (int i = 0; i < arr.length; i += 3) {
                    this.pending.add(new Pair<ChunkPos, BlockPos>(chunk, new BlockPos(arr[i], arr[i + 1], arr[i + 2])));
                }
            }
        }

        public void invalidateTicket() {
            if (this.ticket != null) {
                this.ticket = null;
            }
        }
    }
}

