/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.ChunkLoaderTileRenderer;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.screen.ChunkLoaderScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy {
    private static final Map<Block, BiFunction<World, BlockPos, ChunkLoaderScreen>> screens = new HashMap<Block, BiFunction<World, BlockPos, ChunkLoaderScreen>>();

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ChunkLoaders.single_chunk_loader), (int)0, (ModelResourceLocation)new ModelResourceLocation(ChunkLoaders.single_chunk_loader.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ChunkLoaders.basic_chunk_loader), (int)0, (ModelResourceLocation)new ModelResourceLocation(ChunkLoaders.basic_chunk_loader.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ChunkLoaders.advanced_chunk_loader), (int)0, (ModelResourceLocation)new ModelResourceLocation(ChunkLoaders.advanced_chunk_loader.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ChunkLoaders.ultimate_chunk_loader), (int)0, (ModelResourceLocation)new ModelResourceLocation(ChunkLoaders.ultimate_chunk_loader.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        ClientRegistry.bindTileEntitySpecialRenderer(ChunkLoaderTile.SingleChunkLoaderTile.class, (TileEntitySpecialRenderer)new ChunkLoaderTileRenderer(() -> ChunkLoaders.single_chunk_loader, false));
        ClientRegistry.bindTileEntitySpecialRenderer(ChunkLoaderTile.BasicChunkLoaderTile.class, (TileEntitySpecialRenderer)new ChunkLoaderTileRenderer(() -> ChunkLoaders.basic_chunk_loader, false));
        ClientRegistry.bindTileEntitySpecialRenderer(ChunkLoaderTile.AdvancedChunkLoaderTile.class, (TileEntitySpecialRenderer)new ChunkLoaderTileRenderer(() -> ChunkLoaders.advanced_chunk_loader, true));
        ClientRegistry.bindTileEntitySpecialRenderer(ChunkLoaderTile.UltimateChunkLoaderTile.class, (TileEntitySpecialRenderer)new ChunkLoaderTileRenderer(() -> ChunkLoaders.ultimate_chunk_loader, true));
    }

    @SubscribeEvent
    public static void registerScreens(RegistryEvent.Register<Item> e) {
        screens.put(ChunkLoaders.single_chunk_loader, (world, pos) -> new ChunkLoaderScreen("single_chunk_loader", (World)world, (BlockPos)pos));
        screens.put(ChunkLoaders.basic_chunk_loader, (world, pos) -> new ChunkLoaderScreen("basic_chunk_loader", (World)world, (BlockPos)pos));
        screens.put(ChunkLoaders.advanced_chunk_loader, (world, pos) -> new ChunkLoaderScreen("advanced_chunk_loader", (World)world, (BlockPos)pos));
        screens.put(ChunkLoaders.ultimate_chunk_loader, (world, pos) -> new ChunkLoaderScreen("ultimate_chunk_loader", (World)world, (BlockPos)pos));
    }

    public static void openScreen(Block block, World world, BlockPos pos) {
        if (screens.containsKey(block)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)screens.get(block).apply(world, pos));
        }
    }
}

