/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.packet;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class ChunkLoaderPacket<T extends ChunkLoaderPacket>
implements IMessage,
IMessageHandler<T, IMessage> {
    protected BlockPos pos;

    public ChunkLoaderPacket(BlockPos pos) {
        this.pos = pos;
    }

    public ChunkLoaderPacket() {
    }

    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
    }

    protected void decodeBuffer(ByteBuf buffer) {
        this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    protected abstract void handle(T var1, EntityPlayer var2, World var3, ChunkLoaderTile var4);

    public void fromBytes(ByteBuf buffer) {
        this.decodeBuffer(buffer);
    }

    public void toBytes(ByteBuf buffer) {
        this.encode(buffer);
    }

    public IMessage onMessage(T message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player == null || player.func_180425_c().func_177951_i((Vec3i)((ChunkLoaderPacket)message).pos) > 1024.0) {
            return null;
        }
        WorldServer world = player.func_71121_q();
        if (world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(((ChunkLoaderPacket)message).pos);
        if (tile instanceof ChunkLoaderTile) {
            world.func_152344_a(() -> this.handle(message, (EntityPlayer)player, (World)world, (ChunkLoaderTile)tile));
        }
        return null;
    }
}

