/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.chunkloaders.screen.ChunkImage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChunkButton
extends GuiButton {
    private static final ResourceLocation BUTTON_OFF = new ResourceLocation("chunkloaders", "textures/gui/button_off.png");
    private static final ResourceLocation BUTTON_ON = new ResourceLocation("chunkloaders", "textures/gui/button_on.png");
    public final int xOffset;
    public final int zOffset;
    private final Supplier<ChunkLoaderTile> tileSupplier;
    private final ChunkImage image;

    public ChunkButton(int buttonId, int x, int y, int xOffset, int zOffset, Supplier<ChunkLoaderTile> tileSupplier, World world, ChunkPos chunk) {
        super(buttonId, x, y, 15, 15, "");
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.tileSupplier = tileSupplier;
        this.image = new ChunkImage(world, chunk);
        this.image.createTexture();
    }

    public void onPress() {
        ChunkLoaderTile tile = this.tileSupplier.get();
        if (tile != null) {
            ChunkLoaders.channel.sendToServer((IMessage)new PacketToggleChunk(tile.func_174877_v(), this.xOffset, this.zOffset));
        }
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.isLoaded() ? BUTTON_ON : BUTTON_OFF);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawTexture(this.field_146128_h, this.field_146129_i, 15, 15);
        this.image.updateTexture();
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)this.image.textureId);
        this.drawTexture(this.field_146128_h + 2, this.field_146129_i + 2, 11, 11);
        if (!this.isLoaded()) {
            this.func_73733_a(this.field_146128_h + 2, this.field_146129_i + 2, this.field_146128_h + 13, this.field_146129_i + 13, -1442840576, -1442840576);
        }
    }

    public boolean isLoaded() {
        ChunkLoaderTile tile = this.tileSupplier.get();
        return tile != null && tile.isLoaded(this.xOffset, this.zOffset);
    }

    public boolean isHovered() {
        return this.field_146123_n;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g;
    }

    private void drawTexture(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        boolean z = false;
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

