/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.screen.ChunkButton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ChunkLoaderScreen
extends GuiScreen {
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("chunkloaders", "textures/gui/background.png");
    protected World world;
    protected BlockPos pos;
    protected int left;
    protected int top;
    private final int backgroundSize;
    private boolean doDrag = false;
    private boolean dragState = false;
    private List<ChunkButton> draggedButtons = new ArrayList<ChunkButton>();

    public ChunkLoaderScreen(String type, World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        ChunkLoaderTile tile = this.getTileOrClose();
        int gridSize = tile == null ? 1 : tile.getGridSize();
        this.backgroundSize = gridSize * 15 + (gridSize - 1) + 16;
    }

    public void func_73866_w_() {
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.left = (this.field_146294_l - this.backgroundSize) / 2;
        this.top = (this.field_146295_m - this.backgroundSize) / 2;
        int radius = (tile.getGridSize() - 1) / 2;
        for (int x = 0; x < tile.getGridSize(); ++x) {
            for (int y = 0; y < tile.getGridSize(); ++y) {
                int index = x * tile.getGridSize() + y;
                this.func_189646_b(new ChunkButton(index, this.left + 8 + x * 16, this.top + 8 + y * 16, -radius + x, -radius + y, this::getTileOrClose, this.world, new ChunkPos((this.pos.func_177958_n() >> 4) - radius + x, (this.pos.func_177952_p() >> 4) - radius + y)));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.field_146292_n.stream().filter(ChunkButton.class::isInstance).map(ChunkButton.class::cast).forEach(button -> {
            if (button.isHovered()) {
                this.renderToolTip(true, "chunkloaders.gui." + (tile.isLoaded(button.xOffset, button.zOffset) ? "loaded" : "unloaded"), mouseX, mouseY);
            }
        });
    }

    private void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.drawScreenBackground(this.left, this.top, this.backgroundSize, this.backgroundSize);
    }

    protected void drawCenteredString(ITextComponent text, float x, float y) {
        this.drawCenteredString(text.func_150254_d(), x, y);
    }

    protected void drawCenteredString(String s, float x, float y) {
        this.field_146289_q.func_78276_b(s, (int)((float)this.left + x - (float)this.field_146289_q.func_78256_a(s) / 2.0f), (int)((float)this.top + y), 0x404040);
    }

    protected void drawString(ITextComponent text, float x, float y) {
        this.drawString(text.func_150254_d(), x, y);
    }

    protected void drawString(String s, float x, float y) {
        this.field_146289_q.func_78276_b(s, (int)((float)this.left + x), (int)((float)this.top + y), 0x404040);
    }

    public void renderToolTip(boolean translate, String string, int x, int y) {
        super.func_146279_a(translate ? new TextComponentTranslation(string, new Object[0]).func_150254_d() : string, x, y);
    }

    public ChunkLoaderTile getTileOrClose() {
        TileEntity tile;
        if (this.world != null && this.pos != null && (tile = this.world.func_175625_s(this.pos)) instanceof ChunkLoaderTile) {
            return (ChunkLoaderTile)tile;
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        return null;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (button == 0) {
            for (GuiButton listener : this.field_146292_n) {
                ChunkButton chunkButton;
                if (!(listener instanceof ChunkButton) || !(chunkButton = (ChunkButton)listener).isMouseOver(mouseX, mouseY)) continue;
                this.doDrag = true;
                this.dragState = !chunkButton.isLoaded();
                this.draggedButtons.clear();
                this.draggedButtons.add(chunkButton);
                chunkButton.onPress();
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long timeSinceLastClick) {
        if (this.doDrag && button == 0) {
            for (GuiButton listener : this.field_146292_n) {
                ChunkButton chunkButton;
                if (!(listener instanceof ChunkButton) || this.draggedButtons.contains(listener) || !(chunkButton = (ChunkButton)listener).isMouseOver(mouseX, mouseY) || chunkButton.isLoaded() == this.dragState) continue;
                chunkButton.onPress();
                this.draggedButtons.add(chunkButton);
                return;
            }
        }
        super.func_146273_a(mouseX, mouseY, button, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.doDrag = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ChunkButton) {
            ((ChunkButton)button).onPress();
        }
    }

    public void drawScreenBackground(float x, float y, float width, float height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SCREEN_BACKGROUND);
        this.drawTexture(x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        this.drawTexture(x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        this.drawTexture(x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        this.drawTexture(x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        this.drawTexture(x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        this.drawTexture(x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        this.drawTexture(x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        this.drawTexture(x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        this.drawTexture(x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public void drawTexture(float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        boolean z = false;
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

