/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.beebetteratbees.common.integration;

import com.google.common.collect.Maps;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import hellfirepvp.beebetteratbees.common.data.Config;
import hellfirepvp.beebetteratbees.common.integration.jei.BeeTreeRecipeWrapper;
import hellfirepvp.beebetteratbees.common.integration.jei.CategoryBeeTree;
import hellfirepvp.beebetteratbees.common.util.BeeUtil;
import java.util.HashMap;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;

@JEIPlugin
public class ModIntegrationJEI
implements IModPlugin {
    public static IBeeRoot beeRoot;
    public static final String idBeeTree = "beebetteratbees.beetree";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryBeeTree(guiHelper)});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (root == null || !(root instanceof IBeeRoot)) {
            throw new IllegalStateException("Forestry bee root not enabled! Is forestry not installed or the bee module not enabled?");
        }
        beeRoot = (IBeeRoot)root;
        HashMap foundRoots = Maps.newHashMap();
        for (IBeeMutation possibleMutation : beeRoot.getMutations(false)) {
            if (!Config.shouldShowSecretRecipes && possibleMutation.isSecret()) {
                return;
            }
            IAlleleBeeSpecies rootOfMutation = BeeUtil.getMutationRoot(possibleMutation);
            int count = foundRoots.getOrDefault(rootOfMutation.getUID(), 0);
            jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)new BeeTreeRecipeWrapper(rootOfMutation, count), idBeeTree);
            foundRoots.put(rootOfMutation.getUID(), ++count);
        }
    }
}

