/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.config;

import java.io.File;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.config.Config;

@Config(modid="mowziesmobs", category="", name="mowziesmobs")
public class ConfigHandler {
    @Config.Ignore
    public static File configDir;
    @Config.Ignore
    private static final String LANG_PREFIX = "config.mowziesmobs.";
    @Config.Name(value="mobs")
    @Config.LangKey(value="config.mowziesmobs.mobs")
    public static final Mobs MOBS;
    @Config.Name(value="tools_and_abilities")
    @Config.LangKey(value="config.mowziesmobs.tools_and_abilities")
    public static final ToolsAndAbilities TOOLS_AND_ABILITIES;
    @Config.Name(value="general")
    @Config.LangKey(value="config.mowziesmobs.general")
    public static final General GENERAL;

    static {
        MOBS = new Mobs();
        TOOLS_AND_ABILITIES = new ToolsAndAbilities();
        GENERAL = new General();
    }

    public static class General {
        @Config.Name(value="freeze_blacklist")
        @Config.LangKey(value="config.mowziesmobs.freeze_blacklist")
        @Config.Comment(value={"Add a mob's full name here to prevent it from being frozen or taking damage from ice magic."})
        public String[] freeze_blacklist = new String[]{"mowziesmobs:frostmaw", "minecraft:ender_dragon"};
    }

    public static class ToolsAndAbilities {
        @Config.Name(value="suns_blessing_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.suns_blessing_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float sunsBlessingAttackMultiplier = 1.0f;
        @Config.Name(value="geomancy_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.geomancy_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float geomancyAttackMultiplier = 1.0f;
        @Config.Name(value="wrought_helm")
        @Config.LangKey(value="config.mowziesmobs.wrought_helm")
        public WroughtHelm WROUGHT_HELM = new WroughtHelm();
        @Config.Name(value="axe_of_a_thousand_metals")
        @Config.LangKey(value="config.mowziesmobs.axe_of_a_thousand_metals")
        public AxeOfAThousandMetals AXE_OF_A_THOUSAND_METALS = new AxeOfAThousandMetals();
        @Config.Name(value="sol_visage")
        @Config.LangKey(value="config.mowziesmobs.sol_visage")
        public SolVisage SOL_VISAGE = new SolVisage();
        @Config.Name(value="ice_crystal")
        @Config.LangKey(value="config.mowziesmobs.ice_crystal")
        public IceCrystal ICE_CRYSTAL = new IceCrystal();
        @Config.Name(value="barakoa_mask")
        @Config.LangKey(value="config.mowziesmobs.barakoa_mask")
        public BarakoaMask BARAKOA_MASK = new BarakoaMask();
        @Config.Name(value="barakoa_spear")
        @Config.LangKey(value="config.mowziesmobs.barakoa_spear")
        public BarakoaSpear BARAKOA_SPEAR = new BarakoaSpear();
        @Config.Name(value="naga_fang_dagger")
        @Config.LangKey(value="config.mowziesmobs.naga_fang_dagger")
        public NagaFangDagger NAGA_FANG_DAGGER = new NagaFangDagger();
        @Config.Name(value="blow_gun")
        @Config.LangKey(value="config.mowziesmobs.blow_gun")
        public BlowGun BLOW_GUN = new BlowGun();
    }

    public static class Mobs {
        @Config.Name(value="frostmaw")
        @Config.LangKey(value="config.mowziesmobs.frostmaw")
        public Frostmaw FROSTMAW = new Frostmaw();
        @Config.Name(value="barako")
        @Config.LangKey(value="config.mowziesmobs.barako")
        public Barako BARAKO = new Barako();
        @Config.Name(value="ferrous_wroughtnaut")
        @Config.LangKey(value="config.mowziesmobs.ferrous_wroughtnaut")
        public Ferrous_Wroughtnaut FERROUS_WROUGHTNAUT = new Ferrous_Wroughtnaut();
        @Config.Name(value="grottol")
        @Config.LangKey(value="config.mowziesmobs.grottol")
        public Grottol GROTTOL = new Grottol();
        @Config.Name(value="lantern")
        @Config.LangKey(value="config.mowziesmobs.lantern")
        public Lantern LANTERN = new Lantern();
        @Config.Name(value="barakoa")
        @Config.LangKey(value="config.mowziesmobs.barakoa")
        public Barakoa BARAKOA = new Barakoa();
        @Config.Name(value="naga")
        @Config.LangKey(value="config.mowziesmobs.naga")
        public Naga NAGA = new Naga();
        @Config.Name(value="foliaath")
        @Config.LangKey(value="config.mowziesmobs.foliaath")
        public Foliaath FOLIAATH = new Foliaath();
    }

    public static class BlowGun {
        @Config.Name(value="attack_damage")
        @Config.LangKey(value="config.mowziesmobs.attack_damage")
        @Config.RangeDouble(min=0.0, max=100000.0)
        @Config.RequiresMcRestart
        public float attackDamage = 1.0f;
        @Config.Name(value="poison_duration")
        @Config.LangKey(value="config.mowziesmobs.poison_duration")
        @Config.Comment(value={"Duration in ticks of the poison effect (20 ticks = 1 second)."})
        @Config.RangeInt(min=0, max=100000)
        public int poisonDuration = 40;
    }

    public static class NagaFangDagger {
        @Config.Name(value="tool_data")
        @Config.LangKey(value="config.mowziesmobs.tool_data")
        @Config.Comment(value={"Shared controls for melee weapons and tools"})
        public ToolData toolData = new ToolData(3.0f, 2.0f);
        @Config.Name(value="poison_duration")
        @Config.LangKey(value="config.mowziesmobs.poison_duration")
        @Config.Comment(value={"Duration in ticks of the poison effect (20 ticks = 1 second)."})
        @Config.RangeInt(min=0, max=100000)
        public int poisonDuration = 40;
        @Config.Name(value="bonus_damage")
        @Config.LangKey(value="config.mowziesmobs.bonus_damage")
        @Config.Comment(value={"Bonus damage when attacking from behind"})
        @Config.RangeDouble(min=0.0, max=100000.0)
        public float bonusDamage = 3.0f;
    }

    public static class BarakoaSpear {
        @Config.Name(value="tool_data")
        @Config.LangKey(value="config.mowziesmobs.tool_data")
        @Config.Comment(value={"Shared controls for melee weapons and tools"})
        public ToolData toolData = new ToolData(5.0f, 1.6f);
    }

    public static class IceCrystal {
        @Config.Name(value="ice_crystal_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.ice_crystal_attack_multiplier")
        @Config.Comment(value={"Multiply all damage done with the ice crystal by this amount."})
        @Config.RangeDouble(min=0.0, max=100.0)
        public float attackMultiplier = 1.0f;
        @Config.Name(value="ice_crystal_breakable")
        @Config.LangKey(value="config.mowziesmobs.ice_crystal_breakable")
        @Config.Comment(value={"Set to true for the ice crystal to have limited durability.", "Prevents regeneration in inventory."})
        @Config.RequiresMcRestart
        public boolean breakable = false;
        @Config.Name(value="durability")
        @Config.LangKey(value="config.mowziesmobs.durability")
        @Config.Comment(value={"Ice crystal durability"})
        @Config.RangeInt(min=1, max=100000000)
        @Config.RequiresMcRestart
        public int durability = 600;
    }

    public static class BarakoaMask {
        @Config.Name(value="armor_data")
        @Config.LangKey(value="config.mowziesmobs.armor_data")
        @Config.Comment(value={"Shared controls for armor"})
        public ArmorData armorData = new ArmorData(ItemArmor.ArmorMaterial.LEATHER.func_78044_b(EntityEquipmentSlot.HEAD), ItemArmor.ArmorMaterial.LEATHER.func_189416_e());
    }

    public static class SolVisage {
        @Config.Name(value="armor_data")
        @Config.LangKey(value="config.mowziesmobs.armor_data")
        @Config.Comment(value={"Shared controls for armor"})
        public ArmorData armorData = new ArmorData(ItemArmor.ArmorMaterial.GOLD.func_78044_b(EntityEquipmentSlot.HEAD), ItemArmor.ArmorMaterial.GOLD.func_189416_e());
        @Config.Name(value="breakable")
        @Config.LangKey(value="config.mowziesmobs.breakable")
        @Config.Comment(value={"Set to true for the Sol Visage to have limited durability."})
        @Config.RequiresMcRestart
        public boolean breakable = false;
    }

    public static class AxeOfAThousandMetals {
        @Config.Name(value="tool_data")
        @Config.LangKey(value="config.mowziesmobs.tool_data")
        @Config.Comment(value={"Shared controls for melee weapons and tools"})
        public ToolData toolData = new ToolData(9.0f, 0.9f);
        @Config.Name(value="breakable")
        @Config.LangKey(value="config.mowziesmobs.breakable")
        @Config.Comment(value={"Set to true for the Axe of a Thousand Metals to have limited durability."})
        @Config.RequiresMcRestart
        public boolean breakable = false;
    }

    public static class WroughtHelm {
        @Config.Name(value="armor_data")
        @Config.LangKey(value="config.mowziesmobs.armor_data")
        @Config.Comment(value={"Shared controls for armor"})
        public ArmorData armorData = new ArmorData(ItemArmor.ArmorMaterial.IRON.func_78044_b(EntityEquipmentSlot.HEAD), ItemArmor.ArmorMaterial.IRON.func_189416_e());
        @Config.Name(value="breakable")
        @Config.LangKey(value="config.mowziesmobs.breakable")
        @Config.Comment(value={"Set to true for the Wrought Helm to have limited durability."})
        @Config.RequiresMcRestart
        public boolean breakable = false;
    }

    public static class Frostmaw {
        @Config.Name(value="generation_data")
        @Config.LangKey(value="config.mowziesmobs.generation_data")
        @Config.Comment(value={"Controls for spawning mob/structure with world generation"})
        public GenerationData generationData = new GenerationData(12, 0.8f, new BiomeData(new String[]{"SNOWY,!OCEAN,!RIVER,!BEACH"}, new String[0], new String[0]), 50.0f, 100.0f);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
        @Config.Name(value="stealable_ice_crystal")
        @Config.LangKey(value="config.mowziesmobs.stealable_ice_crystal")
        @Config.Comment(value={"Allow players to steal frostmaws' ice crystals (only using specific means!)"})
        public boolean stealableIceCrystal = true;
        @Config.Name(value="has_boss_bar")
        @Config.LangKey(value="config.mowziesmobs.has_boss_bar")
        @Config.Comment(value={"Disable/enable frostmaws' boss health bar"})
        @Config.RequiresWorldRestart
        public boolean hasBossBar = true;
        @Config.Name(value="heals_out_of_battle")
        @Config.LangKey(value="config.mowziesmobs.heals_out_of_battle")
        @Config.Comment(value={"Disable/enable frostmaw healing while asleep"})
        public boolean healsOutOfBattle = true;
    }

    public static class Barako {
        @Config.Name(value="generation_data")
        @Config.LangKey(value="config.mowziesmobs.generation_data")
        @Config.Comment(value={"Controls for spawning mob/structure with world generation", "Generation controls for Barakoa villages"})
        public GenerationData generationData = new GenerationData(12, 0.8f, new BiomeData(new String[]{"SAVANNA"}, new String[0], new String[0]), 50.0f, 100.0f);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
        @Config.Name(value="has_boss_bar")
        @Config.LangKey(value="config.mowziesmobs.has_boss_bar")
        @Config.Comment(value={"Disable/enable Barako's boss health bar"})
        @Config.RequiresWorldRestart
        public boolean hasBossBar = true;
        @Config.Name(value="heals_out_of_battle")
        @Config.LangKey(value="config.mowziesmobs.heals_out_of_battle")
        @Config.Comment(value={"Disable/enable Barako healing while not in combat"})
        public boolean healsOutOfBattle = true;
    }

    public static class Ferrous_Wroughtnaut {
        @Config.Name(value="generation_data")
        @Config.LangKey(value="config.mowziesmobs.generation_data")
        @Config.Comment(value={"Controls for spawning mob/structure with world generation"})
        public GenerationData generationData = new GenerationData(2, 0.5f, new BiomeData(new String[]{""}, new String[0], new String[0]), 30.0f, 55.0f);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
        @Config.Name(value="has_boss_bar")
        @Config.LangKey(value="config.mowziesmobs.has_boss_bar")
        @Config.Comment(value={"Disable/enable Ferrous Wroughtnauts' boss health bar"})
        @Config.RequiresWorldRestart
        public boolean hasBossBar = true;
        @Config.Name(value="heals_out_of_battle")
        @Config.LangKey(value="config.mowziesmobs.heals_out_of_battle")
        @Config.Comment(value={"Disable/enable Ferrous Wroughtnaut healing while not active"})
        public boolean healsOutOfBattle = true;
    }

    public static class Grottol {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(2, 1, 1, new BiomeData(new String[]{""}, new String[0], new String[0]), new String[0], 55, -1, false, false, true);
        @Config.Name(value="health_multiplier")
        @Config.LangKey(value="config.mowziesmobs.health_multiplier")
        @Config.Comment(value={"Scale mob health by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public float healthMultiplier = 1.0f;
    }

    public static class Lantern {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(5, 1, 2, new BiomeData(new String[]{"FOREST,MAGICAL,!SNOWY"}, new String[]{"roofed_forest", "mutated_roofed_forest"}, new String[0]), new String[]{"grass", "leaves", "leaves2", "log", "log2"}, -1, 60, true, false, false);
        @Config.Name(value="health_multiplier")
        @Config.LangKey(value="config.mowziesmobs.health_multiplier")
        @Config.Comment(value={"Scale mob health by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public float healthMultiplier = 1.0f;
        @Config.Name(value="glow_effect")
        @Config.LangKey(value="config.mowziesmobs.glow_effect")
        public boolean glowEffect = true;
    }

    public static class Naga {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(3, 1, 3, new BiomeData(new String[]{"BEACH,MOUNTAIN", "BEACH,HILLS"}, new String[]{"stone_beach"}, new String[0]), new String[]{"grass", "stone", "sand"}, -1, -1, false, true, false);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Barakoa {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning", "Controls spawning for Barakoana hunting groups", "Group size controls how many elites spawn, not followers", "See Barako config for village controls"})
        public SpawnData spawnData = new SpawnData(4, 1, 1, new BiomeData(new String[]{"SAVANNA"}, new String[0], new String[0]), new String[]{"grass", "stone", "sand"}, -1, 60, false, false, false);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Foliaath {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(20, 1, 3, new BiomeData(new String[]{"JUNGLE"}, new String[0], new String[0]), new String[]{"grass", "leaves", "leaves2", "log", "log2"}, -1, 60, false, false, false);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class ArmorData {
        @Config.Name(value="damage_reduction")
        @Config.LangKey(value="config.mowziesmobs.damage_reduction")
        @Config.Comment(value={"See official Minecraft Wiki for an explanation of how armor damage reduction works."})
        @Config.RangeInt(min=0, max=10000)
        @Config.RequiresMcRestart
        public int damageReduction = 1;
        @Config.Name(value="toughness")
        @Config.LangKey(value="config.mowziesmobs.toughness")
        @Config.Comment(value={"See official Minecraft Wiki for an explanation of how armor toughness works."})
        @Config.RangeDouble(min=0.0, max=10000.0)
        @Config.RequiresMcRestart
        public float toughness = 1.0f;

        ArmorData(int damageReduction, float toughness) {
            this.damageReduction = damageReduction;
            this.toughness = toughness;
        }
    }

    public static class ToolData {
        @Config.Name(value="attack_damage")
        @Config.LangKey(value="config.mowziesmobs.attack_damage")
        @Config.RangeDouble(min=0.0, max=100000.0)
        @Config.RequiresMcRestart
        public float attackDamage = 1.0f;
        @Config.Name(value="attack_speed")
        @Config.LangKey(value="config.mowziesmobs.attack_speed")
        @Config.RangeDouble(min=0.0, max=100000.0)
        @Config.RequiresMcRestart
        public float attackSpeed = 1.0f;

        ToolData(float attackDamage, float attackSpeed) {
            this.attackDamage = attackDamage;
            this.attackSpeed = attackSpeed;
        }
    }

    public static class CombatData {
        @Config.Name(value="health_multiplier")
        @Config.LangKey(value="config.mowziesmobs.health_multiplier")
        @Config.Comment(value={"Scale mob health by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresWorldRestart
        public float healthMultiplier = 1.0f;
        @Config.Name(value="attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.attack_multiplier")
        @Config.Comment(value={"Scale mob attack damage by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresWorldRestart
        public float attackMultiplier = 1.0f;

        CombatData(float healthMultiplier, float attackMultiplier) {
            this.healthMultiplier = healthMultiplier;
            this.attackMultiplier = attackMultiplier;
        }
    }

    public static class GenerationData {
        @Config.Name(value="generation_frequency")
        @Config.LangKey(value="config.mowziesmobs.generation_frequency")
        @Config.Comment(value={"Smaller number causes more generation, 0 to disable spawning", "Maximum number of chunks between placements of this mob/structure"})
        @Config.RangeInt(min=1, max=1000)
        public int generationFrequency = 15;
        @Config.Name(value="generation_chance")
        @Config.LangKey(value="config.mowziesmobs.generation_chance")
        @Config.Comment(value={"Probability that generation succeeds.", "For example, set to 0.5 to randomly not generate half of these structures in the world.", "Set to 1 to allow all generation attempts to succeed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float generationChance = 1.0f;
        @Config.Name(value="biome_data")
        @Config.LangKey(value="config.mowziesmobs.biome_data")
        @Config.Comment(value={"Control which biomes this generation is allowed in"})
        @Config.RequiresMcRestart
        public BiomeData biomeData;
        @Config.Name(value="dimensions")
        @Config.LangKey(value="config.mowziesmobs.dimensions")
        @Config.Comment(value={"IDs of dimensions this mob/structure can generate in"})
        public int[] dimensions = new int[]{0};
        @Config.Name(value="height_min")
        @Config.LangKey(value="config.mowziesmobs.height_min")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Minimum height for generation placement. -1 to ignore"})
        public float heightMin = 0.0f;
        @Config.Name(value="height_max")
        @Config.LangKey(value="config.mowziesmobs.height_max")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Maximum height for generation placement. -1 to ignore"})
        public float heightMax = 255.0f;

        GenerationData(int generationFrequency, float generationChance, BiomeData biomeData, float heightMin, float heightMax) {
            this.generationFrequency = generationFrequency;
            this.generationChance = generationChance;
            this.biomeData = biomeData;
            this.heightMax = heightMax;
            this.heightMin = heightMin;
        }
    }

    public static class SpawnData {
        @Config.Name(value="spawn_rate")
        @Config.LangKey(value="config.mowziesmobs.spawn_rate")
        @Config.Comment(value={"Smaller number causes less spawning, 0 to disable spawning"})
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int spawnRate = 20;
        @Config.Name(value="min_group_size")
        @Config.LangKey(value="config.mowziesmobs.min_group_size")
        @Config.Comment(value={"Minimum number of mobs that appear in a spawn group"})
        @Config.RangeInt(min=1, max=100)
        @Config.RequiresMcRestart
        public int minGroupSize = 1;
        @Config.Name(value="max_group_size")
        @Config.LangKey(value="config.mowziesmobs.max_group_size")
        @Config.Comment(value={"Maximum number of mobs that appear in a spawn group"})
        @Config.RangeInt(min=1, max=100)
        @Config.RequiresMcRestart
        public int maxGroupSize = 3;
        @Config.Name(value="biome_data")
        @Config.LangKey(value="config.mowziesmobs.biome_data")
        @Config.Comment(value={"Control which biomes this spawn is allowed in"})
        @Config.RequiresMcRestart
        public BiomeData biomeData;
        @Config.Name(value="dimensions")
        @Config.LangKey(value="config.mowziesmobs.dimensions")
        @Config.Comment(value={"IDs of dimensions this mob can spawn in"})
        public int[] dimensions = new int[]{0};
        @Config.Name(value="height_min")
        @Config.LangKey(value="config.mowziesmobs.height_min")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Minimum height for this spawn. -1 to ignore."})
        public float heightMin = 0.0f;
        @Config.Name(value="height_max")
        @Config.LangKey(value="config.mowziesmobs.height_max")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Maximum height for this spawn. -1 to ignore."})
        public float heightMax = 255.0f;
        @Config.Name(value="needs_darkness")
        @Config.LangKey(value="config.mowziesmobs.needs_darkness")
        @Config.Comment(value={"Set to true to only allow this mob to spawn in the dark, like zombies and skeletons"})
        public boolean needsDarkness;
        @Config.Name(value="requires_see_sky")
        @Config.LangKey(value="config.mowziesmobs.requires_see_sky")
        @Config.Comment(value={"Set to true to only spawn mob if it can see the sky"})
        public boolean needsSeeSky;
        @Config.Name(value="requires_cant_see_sky")
        @Config.LangKey(value="config.mowziesmobs.requires_cant_see_sky")
        @Config.Comment(value={"Set to true to only spawn mob if it can't see the sky"})
        public boolean needsCantSeeSky;
        @Config.Name(value="allowed_blocks")
        @Config.LangKey(value="config.mowziesmobs.allowed_blocks")
        @Config.Comment(value={"Names of blocks this mob is allowed to spawn on. Leave blank to allow any block."})
        @Config.RequiresMcRestart
        public String[] allowedBlocks = new String[0];

        SpawnData(int spawnRate, int minGroupSize, int maxGroupSize, BiomeData biomeData, String[] allowedBlocks, int heightMax, int heightMin, boolean needsDarkness, boolean needsSeeSky, boolean needsCantSeeSky) {
            this.spawnRate = spawnRate;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.biomeData = biomeData;
            this.allowedBlocks = allowedBlocks;
            this.heightMax = heightMax;
            this.heightMin = heightMin;
            this.needsDarkness = needsDarkness;
            this.needsSeeSky = needsSeeSky;
            this.needsCantSeeSky = needsCantSeeSky;
        }
    }

    public static class BiomeData {
        @Config.Name(value="biome_type")
        @Config.LangKey(value="config.mowziesmobs.biome_type")
        @Config.Comment(value={"Each entry is a combination of allowed biome types.", "Separate types with commas to require biomes to have all types in an entry", "Put a '!' before a biome type to mean NOT that type", "A blank entry means all biomes. No entries means no biomes.", "For example, 'FOREST,MAGICAL,!SNOWY' would mean all biomes that are magical forests but not snowy", "'!MOUNTAIN' would mean all non-mountain biomes"})
        @Config.RequiresMcRestart
        public String[] biomeTypes = new String[0];
        @Config.Name(value="biome_whitelist")
        @Config.LangKey(value="config.mowziesmobs.biome_whitelist")
        @Config.Comment(value={"Allow spawns in these biomes regardless of the biome type settings"})
        @Config.RequiresMcRestart
        public String[] biomeWhitelist = new String[0];
        @Config.Name(value="biome_blacklist")
        @Config.LangKey(value="config.mowziesmobs.biome_blacklist")
        @Config.Comment(value={"Prevent spawns in these biomes regardless of the biome type settings"})
        @Config.RequiresMcRestart
        public String[] biomeBlacklist = new String[0];

        BiomeData(String[] biomeTypes, String[] biomeWhitelist, String[] biomeBlacklist) {
            this.biomeTypes = biomeTypes;
            this.biomeWhitelist = biomeWhitelist;
            this.biomeBlacklist = biomeBlacklist;
        }
    }
}

