/*
 * Decompiled with CFR 0.152.
 */
package somdudewillson.ncradmetabolosis.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="ncradmetabolosis", name="NCRadMetabolosis")
public class NCRMConfig {
    @Config.Comment(value={"The amount of rads which are dissipated per tick"})
    public static double passive_dissipation_amount = 0.0;
    @Config.Comment(value={"Exhaustion per tick to dissipate rads.", "4 exhaustion ~= 1 unit of food."})
    public static double exhaustion_cost = 1.0;
    @Config.Comment(value={"Minimum food bars required for rad dissipation."})
    public static int min_food = 1;
    @Config.Comment(value={"If accelerated rad dissipation by consuming saturation is enabled."})
    public static boolean saturation_dissipation = false;
    @Config.Comment(value={"The max amount of rads which are dissipated per tick with saturation."})
    public static double saturation_max_dissipation = 0.0;
    @Config.Comment(value={"Max saturation consumed per tick to dissipate rads."})
    public static double saturation_cost = 6.0;
    @Config.Ignore
    public static double rads_per_saturation;

    public static void updateCalculatedValues() {
        rads_per_saturation = saturation_max_dissipation / saturation_cost;
    }

    @Mod.EventBusSubscriber(modid="ncradmetabolosis")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ncradmetabolosis")) {
                NCRMConfig.updateCalculatedValues();
                ConfigManager.sync((String)"ncradmetabolosis", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

