/*
 * Decompiled with CFR 0.152.
 */
package somdudewillson.ncradmetabolosis.radiation;

import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.network.PacketHandler;
import nc.network.radiation.PlayerRadsUpdatePacket;
import nc.radiation.RadiationHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.FoodStats;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import somdudewillson.ncradmetabolosis.config.NCRMConfig;

public class RadiationMetabolosisHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void applyEnvironmentalRadiation(TickEvent.PlayerTickEvent event) {
        IEntityRads playerRads;
        EntityPlayerMP player;
        FoodStats food;
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.START || (event.player.field_70170_p.func_82737_E() + (long)event.player.func_110124_au().hashCode()) % (long)NCConfig.radiation_player_tick_rate != 0L) {
            return;
        }
        if (event.side == Side.SERVER && event.player instanceof EntityPlayerMP && (food = (player = (EntityPlayerMP)event.player).func_71024_bL()).func_75116_a() >= NCRMConfig.min_food && !(playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player)).isTotalRadsNegligible()) {
            if (food.func_75115_e() > 0.0f && NCRMConfig.saturation_dissipation && NCRMConfig.saturation_max_dissipation > 0.0) {
                double maxUnitsForFood = food.func_75115_e();
                double maxUnitsForTicks = NCRMConfig.saturation_max_dissipation * (double)NCConfig.radiation_player_tick_rate / NCRMConfig.rads_per_saturation;
                double maxUnitsForRads = playerRads.getTotalRads() / NCRMConfig.rads_per_saturation;
                int appliedUnits = (int)Math.floor(Math.min(Math.min(maxUnitsForFood, maxUnitsForTicks), maxUnitsForRads));
                food.func_75119_b(food.func_75115_e() - (float)appliedUnits);
                double dissipatedRads = -((double)appliedUnits * NCRMConfig.rads_per_saturation);
                playerRads.setTotalRads(Math.max(playerRads.getTotalRads() - dissipatedRads, 0.0), false);
                playerRads.setRadiationLevel(playerRads.getRadiationLevel() - dissipatedRads);
            } else if (NCRMConfig.passive_dissipation_amount > 0.0) {
                double maxUnitsForFood = (double)(food.func_75116_a() - NCRMConfig.min_food) / (NCRMConfig.exhaustion_cost / 4.0) + 1.0;
                double maxUnitsForTicks = NCConfig.radiation_player_tick_rate;
                double maxUnitsForRads = playerRads.getTotalRads() / NCRMConfig.passive_dissipation_amount;
                int appliedUnits = (int)Math.floor(Math.min(Math.min(maxUnitsForFood, maxUnitsForTicks), maxUnitsForRads));
                food.func_75113_a((float)((double)appliedUnits * NCRMConfig.exhaustion_cost));
                double dissipatedRads = (double)appliedUnits * NCRMConfig.passive_dissipation_amount;
                playerRads.setTotalRads(Math.max(playerRads.getTotalRads() - dissipatedRads, 0.0), false);
                playerRads.setRadiationLevel(playerRads.getRadiationLevel() - dissipatedRads);
            }
            PacketHandler.instance.sendTo((IMessage)new PlayerRadsUpdatePacket(playerRads), player);
        }
    }
}

