/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;

public class CommandTBKnownledge
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbknowledge";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2 || args.length > 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandTBKnownledge.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap == null) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_CAP_NULL.getKey(), new Object[0]);
        }
        Action action = Action.getAction(args[1]);
        if (action == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (action) {
            case SHOW: {
                if (args.length == 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                this.showKnowledge(sender, player, cap);
                break;
            }
            case SET: {
                int newKnowledge = CommandTBKnownledge.func_175755_a((String)args[2]);
                this.setKnowledge(sender, player, newKnowledge);
                break;
            }
            case GIVE: {
                int amount = CommandTBKnownledge.func_175755_a((String)args[2]);
                this.giveKnowledge(sender, player, amount);
                break;
            }
            case REMOVE: {
                int amount = CommandTBKnownledge.func_175755_a((String)args[2]);
                this.removeKnowledge(sender, player, amount);
                break;
            }
            case RESET_ANKH: {
                this.resetAnkhCooldown(sender, player, cap);
                break;
            }
        }
    }

    private void setKnowledge(ICommandSender sender, EntityPlayerMP target, long newKnowledge) throws CommandException {
        if (newKnowledge < 0L) {
            throw new CommandException(LangKey.MESSAGE_POSITIVE_INTEGER.getKey(), new Object[0]);
        }
        int adjust = (int)(newKnowledge - EntityHelper.getKnowledge((EntityPlayer)target));
        if (adjust >= 0) {
            this.giveKnowledge(sender, target, adjust);
        } else {
            this.removeKnowledge(sender, target, -adjust);
        }
    }

    private void giveKnowledge(ICommandSender sender, EntityPlayerMP target, int amount) throws CommandException {
        if (amount <= 0) {
            throw new CommandException(LangKey.MESSAGE_POSITIVE_INTEGER.getKey(), new Object[0]);
        }
        EntityHelper.addKnowledge(target, amount);
        if (sender.func_174793_f() != target || !DeathHandler.INSTANCE.getOptionKnowledgeMessage(target.func_110124_au())) {
            LangKey.MESSAGE_EARN_KNOWLEDGE.sendMessage(sender, LangKey.MESSAGE_PLAYER_KNOWLEDGE.getTranslation(target.func_70005_c_()), amount);
        }
    }

    private void removeKnowledge(ICommandSender sender, EntityPlayerMP target, int amount) throws CommandException {
        if (amount <= 0) {
            throw new CommandException(LangKey.MESSAGE_POSITIVE_INTEGER.getKey(), new Object[0]);
        }
        EntityHelper.removeKnowledge(target, amount);
        if (sender.func_174793_f() != target || !DeathHandler.INSTANCE.getOptionKnowledgeMessage(target.func_110124_au())) {
            LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMessage(sender, LangKey.MESSAGE_PLAYER_KNOWLEDGE.getTranslation(target.func_70005_c_()), amount);
        }
    }

    private void showKnowledge(ICommandSender sender, EntityPlayerMP target, ITBCapability cap) {
        LangKey.MESSAGE_SHOW_KNOWLEDGE.sendMessage(sender, target.func_70005_c_(), cap.getKnowledge());
    }

    private void resetAnkhCooldown(ICommandSender sender, EntityPlayerMP target, ITBCapability cap) {
        cap.setNextPray(TimeHelper.worldTicks(target.field_70170_p));
        PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), target);
        LangKey.MESSAGE_RESET_ANKH.sendMessage(sender, target.func_70005_c_());
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTBKnownledge.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandTBKnownledge.func_175762_a((String[])args, (Collection)Stream.of(Action.values()).map(Action::asString).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    static enum Action {
        SHOW,
        SET,
        GIVE,
        REMOVE,
        RESET_ANKH;

        private final String name = this.name().toLowerCase(Locale.US);

        public String asString() {
            return this.name;
        }

        @Nullable
        public static Action getAction(String name) {
            return Arrays.stream(Action.values()).filter(p -> p.asString().equals(name)).findFirst().orElse(null);
        }
    }
}

