/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.capability.IProtectedEntity;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.compatibility.CompatibilityTechguns;
import ovh.corail.tombstone.compatibility.CompatibilityWearableBackpacks;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.ResourceHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.VillageSiegeHandler;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncProtectionMessage;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void fishHookJoinWorldEvent(EntityJoinWorldEvent event) {
        if (this.requireCompatForFishHook(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void fishHookJoinWorldAfterEvent(EntityJoinWorldEvent event) {
        if (event.isCanceled() && this.requireCompatForFishHook(event.getEntity())) {
            event.setCanceled(false);
        }
    }

    private boolean requireCompatForFishHook(Entity fishHook) {
        if (SupportMods.ADVANCED_FISHING.isLoaded() && fishHook instanceof EntityFishHook && fishHook.getClass().equals(EntityFishHook.class)) {
            EntityPlayer player = ((EntityFishHook)fishHook).func_190619_l();
            Item rightHeldItem = player.func_184614_ca().func_77973_b();
            return rightHeldItem instanceof ItemFishingRod ? rightHeldItem == ModItems.fishing_rod_of_misadventure : player.func_184592_cb().func_77973_b() == ModItems.fishing_rod_of_misadventure;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLootTableLoad(LootTableLoadEvent event) {
        String name = event.getName().toString();
        if (event.getName().equals((Object)LootTableList.field_186388_am)) {
            LootPool customPool = event.getLootTableManager().func_186521_a(ResourceHelper.getRL("special")).getPool("lost_tablet");
            customPool.getEntry((String)"tombstone:lost_tablet").field_186364_c = ConfigTombstone.loot.getChanceLootLostTablet();
            customPool.getEntry((String)"empty").field_186364_c = 1000 - ConfigTombstone.loot.getChanceLootLostTablet();
            event.getTable().addPool(customPool);
        } else if (Arrays.stream(ConfigTombstone.loot.treasureLootTable).anyMatch(p -> event.getName().toString().equals(p))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(ResourceHelper.getRL("special")).getPool("chest_treasure"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            long systemTicks = TimeHelper.systemTicks();
            if (TimeHelper.atInterval(systemTicks, TimeHelper.tickFromMinute(1))) {
                if (ConfigTombstone.recovery.recoveryPlayerEnable && TimeHelper.atInterval(systemTicks, TimeHelper.tickFromMinute(ConfigTombstone.recovery.recoveryPlayerTimer))) {
                    CommandTBRecovery.saveAllPlayers(server, success -> (success != false ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).sendLog(new Object[0]));
                }
                CommandTBAcceptTeleport.cleanTickets(systemTicks);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof BlockGraveBase);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        if (ConfigTombstone.general.nerfGhostlyShape && EntityHelper.isPotionActive((EntityLivingBase)event.getPlayer(), ModEffects.ghostly_shape)) {
            event.getPlayer().func_184589_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickChest(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND && ConfigTombstone.general.nerfGhostlyShape && EntityHelper.isPotionActive((EntityLivingBase)event.getEntityPlayer(), ModEffects.ghostly_shape) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockChest) {
            event.getEntityPlayer().func_184589_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            VillageSiegeHandler.instance.checkWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource() == DamageSource.field_180137_b && EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.lightning_resistance)) {
            event.setCanceled(true);
            return;
        }
        if (EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.unstable_intangibleness) && EntityHelper.getPotionDuration(event.getEntityLiving(), ModEffects.unstable_intangibleness) % 100 > 79) {
            event.setCanceled(true);
            return;
        }
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_180425_c())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() != null && EntityHelper.isValidPlayer(event.getSource().func_76346_g())) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (event.getEntityLiving() != player) {
                if (EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape)) {
                    player.func_184589_d(ModEffects.ghostly_shape);
                    if (EntityHelper.isValidPlayerMP((Entity)player)) {
                        ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((EntityPlayerMP)player);
                    }
                }
                if (EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.diversion)) {
                    player.func_184589_d(ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70089_S() && event.getEntityLiving().func_110143_aJ() <= event.getAmount()) {
            Location spawnPos;
            ItemStack soul;
            boolean preventDeathOutsideWorld;
            IProtectedEntity iProtectedEntity = (IProtectedEntity)event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null);
            Location location = Optional.ofNullable(iProtectedEntity).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntityLiving(), false);
                    return cap.getSafeLocation(event.getEntityLiving());
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                WorldServer world;
                event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
                event.getEntityLiving().field_70143_R = 0.0f;
                EntityHelper.clearBadEffects(event.getEntityLiving());
                EntityHelper.addPotion(event.getEntityLiving(), MobEffects.field_76428_l, 600, 9, new boolean[0]);
                if (ConfigTombstone.village_siege.glowingCreatureTest) {
                    EntityHelper.addPotion(event.getEntityLiving(), MobEffects.field_188423_x, 600);
                }
                EntityHelper.addPotion(event.getEntityLiving(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntityLiving().func_184102_h();
                WorldServer worldServer = world = server != null ? server.func_71218_a(location.dim) : null;
                if (world != null && !(spawn = new SpawnHelper(world, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleportEntity(event.getEntityLiving(), spawn);
                }
                EntityHelper.applyAlignmentOnKill(event.getSource(), (Entity)event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            if (!EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
                if (ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
                    event.setCanceled(true);
                    event.getEntityLiving().func_184174_b(false);
                    event.getEntityLiving().func_70106_y();
                }
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            ItemVoodooPoppet.PoppetProtections prot = ModItems.voodoo_poppet.getPoppetProtections(event.getSource());
            if (prot != null && ModItems.voodoo_poppet.preventDeath((EntityPlayer)player, InventoryHelper.findItemInMainInventory((EntityPlayer)player, p -> ModItems.voodoo_poppet.canPreventDeath((ItemStack)p, prot)), prot)) {
                event.setCanceled(true);
                prot.getLangKey().sendSpecialMessage((ICommandSender)player, new Object[0]);
                ModTriggers.PREVENT_DEATH.get((Object)prot).trigger(player);
                return;
            }
            boolean bl = preventDeathOutsideWorld = ConfigTombstone.general.preventDeathOutsideWorld && !Helper.isValidPos(player.field_70170_p, player.func_180425_c());
            ItemStack itemStack = !preventDeathOutsideWorld ? InventoryHelper.findItemInMainInventory((EntityPlayer)player, ModItems.soul_receptacle::isStackValid) : (soul = ItemStack.field_190927_a);
            if (!(!preventDeathOutsideWorld && soul.func_190926_b() || (spawnPos = new SpawnHelper((WorldServer)player.field_70170_p, Helper.getCloserValidPos(player.field_70170_p, new BlockPos((Entity)player))).findSpawnPlace(false)).isOrigin())) {
                event.setCanceled(true);
                if (!preventDeathOutsideWorld) {
                    soul.func_190918_g(1);
                }
                player.func_70606_j(player.func_110138_aP());
                EntityHelper.clearBadEffects((EntityLivingBase)player);
                EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, 1200, 10, new boolean[0]);
                EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                EntityHelper.addPotion((EntityLivingBase)player, ModEffects.diversion, 1200);
                (preventDeathOutsideWorld ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).sendSpecialMessage((ICommandSender)player, new Object[0]);
                Helper.teleportEntity(player, spawnPos);
                player.field_70143_R = 0.0f;
                return;
            }
            if (ConfigTombstone.recovery.backupOnDeath && !((EntityPlayerMP)event.getEntityLiving()).func_175149_v()) {
                CommandTBRecovery.savePlayer((EntityPlayerMP)event.getEntityLiving(), success -> ModTombstone.LOGGER.info((success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getServerTranslation(event.getEntityLiving().func_70005_c_())));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onCheckAttack(LivingAttackEvent event) {
        Entity immediateSource;
        if (Helper.isAprilFoolsDay() && EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && event.getSource() != null && (immediateSource = event.getSource().func_76364_f()) instanceof EntitySnowball && immediateSource.getEntityData().func_74764_b("april_fool_slowness")) {
            EntityHelper.addPotion(event.getEntityLiving(), MobEffects.field_76421_d, 200, 1, new boolean[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCheckAttack(LivingSetAttackTargetEvent event) {
        int lvl;
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || event.getTarget() == null) {
            return;
        }
        EntityLivingBase attacker = event.getEntityLiving();
        if (EntityHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EntityHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
            ((EntityLiving)attacker).field_70696_bz = null;
            if (attacker.field_70755_b == event.getTarget()) {
                attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
            }
            return;
        }
        if (!ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() || ConfigTombstone.enchantments.restrictShadowStepToPlayer && !EntityHelper.isValidPlayer((Entity)event.getTarget())) {
            return;
        }
        if (ConfigTombstone.enchantments.isNerfShadowStep() && !event.getTarget().func_70093_af()) {
            return;
        }
        if (attacker.field_70755_b != event.getTarget() && !event.getTarget().func_184218_aH() && (lvl = Math.min(EntityHelper.getEnchantmentLevel(event.getTarget(), ModEnchantments.shadow_step), 5)) > 0) {
            IAttributeInstance attribute = attacker.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double range = attribute == null ? 16.0 : attribute.func_111126_e();
            double mult = MathHelper.func_151237_a((double)((event.getTarget().func_70093_af() ? 0.6 : 1.0) - (double)lvl * 0.2 + (attacker.field_70170_p.func_72935_r() ? 0.5 : 0.0)), (double)0.05, (double)1.0);
            if ((double)attacker.func_70032_d((Entity)event.getTarget()) < range * mult) {
                attacker.field_70755_b = event.getTarget();
                attacker.field_70756_c = attacker.field_70173_aa;
            } else {
                ((EntityLiving)attacker).field_70696_bz = null;
                if (attacker.field_70755_b == event.getTarget()) {
                    attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidPlayerMP((Entity)event.player) || event.player.func_175149_v()) {
            return;
        }
        EntityHelper.syncTBCapability((EntityPlayerMP)event.player);
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag(event.player);
        NBTTagList stackList = persistentTag.func_150295_c("tb_soulbound_stacks", 10);
        for (int i = 0; i < stackList.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(stackList.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)stack);
        }
        persistentTag.func_82580_o("tb_soulbound_stacks");
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (deathHandler.isPlayerDead(event.player)) {
            if (ConfigTombstone.general.autoEquipOnDeathRespawn) {
                ListIterator it = event.player.field_71071_by.field_70462_a.listIterator();
                while (it.hasNext()) {
                    if (!InventoryHelper.autoequip((ItemStack)it.next(), event.player)) continue;
                    it.set(ItemStack.field_190927_a);
                }
            }
            deathHandler.restorePlayerDead(event.player);
        }
        event.player.field_71069_bz.func_75142_b();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onUndeadDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            DeathHandler.INSTANCE.handleMobDrops(event.getEntityLiving(), event.getSource(), event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void give(PlayerEvent.Clone event) {
        boolean hasPreservation;
        if (!EntityHelper.isValidPlayer(event.getOriginal()) || !EntityHelper.isValidPlayer(event.getEntityPlayer())) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayer original = event.getOriginal();
        ITBCapability originalCap = (ITBCapability)event.getOriginal().getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        ITBCapability cap = (ITBCapability)event.getEntityPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (originalCap != null && cap != null) {
            cap.copyCapability(originalCap);
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (EntityHelper.isValidPlayer(player) && !player.func_175149_v() && ((hasPreservation = EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation)) || ConfigTombstone.general.isHandlingPlayerXp())) {
            NBTTagCompound originalPersistentTag = EntityHelper.getPersistentTag(original);
            int originalExperienceTotal = originalPersistentTag.func_74762_e("tb_experience_total");
            if (hasPreservation || ConfigTombstone.general.getXpLoss() == 0) {
                player.field_71067_cb = originalExperienceTotal;
                player.field_71106_cc = originalPersistentTag.func_74760_g("tb_experience_bar");
                player.field_71068_ca = originalPersistentTag.func_74762_e("tb_experience_level");
            } else {
                int bonus = EntityHelper.getPerkLevelWithBonus(player, ModPerks.memento_mori) * 20;
                EntityHelper.setPlayerXp(player, MathHelper.func_76128_c((double)((double)(originalExperienceTotal * MathHelper.func_76125_a((int)(100 + bonus - ConfigTombstone.general.getXpLoss()), (int)0, (int)100)) / 100.0)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            if (!event.isCanceled() && event.getEntityLiving() != null) {
                EntityHelper.applyAlignmentOnKill(event.getSource(), (Entity)event.getEntityLiving());
            }
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        if (event.isCanceled()) {
            if (ConfigTombstone.general.handlePlayerDeath) {
                LangKey.MESSAGE_DEATH_CANCELED.sendLog(player.func_70005_c_());
            }
        } else {
            ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
            if (cap != null) {
                int knowledgeLoss;
                int n = knowledgeLoss = ConfigTombstone.general.allowBeyondTheGraveDamage && event.getSource() == ModDamages.BEYOND_THE_GRAVE ? 10 : 0;
                if (ConfigTombstone.general.knowledgeLoss > 0) {
                    knowledgeLoss += ConfigTombstone.general.knowledgeLoss;
                }
                if (knowledgeLoss > 0) {
                    cap.removeKnowledgeAndSync(player, knowledgeLoss);
                }
            }
            DeathHandler.INSTANCE.addPlayerDead((EntityPlayer)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (ConfigTombstone.general.isHandlingPlayerXp() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private void storeSoulboundsOnBody(EntityPlayer player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag(player);
        NBTTagList stackList = new NBTTagList();
        persistentTag.func_74782_a("tb_soulbound_stacks", (NBTBase)stackList);
        for (ItemStack key : keys) {
            stackList.func_74742_a((NBTBase)key.serializeNBT());
        }
        keys.clear();
        for (ItemStack soulbound : soulbounds) {
            stackList.func_74742_a((NBTBase)soulbound.serializeNBT());
        }
        soulbounds.clear();
    }

    private void collectKeyAndSoulbound(Iterator<EntityItem> it, List<ItemStack> keys, List<ItemStack> soulbounds) {
        while (it.hasNext()) {
            EntityItem entityItem = it.next();
            if (entityItem == null) {
                it.remove();
                continue;
            }
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_190926_b()) {
                it.remove();
                continue;
            }
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                entityItem.func_92058_a(ItemStack.field_190927_a);
                it.remove();
                continue;
            }
            if (!ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            entityItem.func_92058_a(ItemStack.field_190927_a);
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDrops(PlayerDropsEvent event) {
        boolean needAccess;
        IBlockState state;
        boolean hasGrave;
        TileEntity tile2;
        Location lastGrave;
        boolean hasDrop;
        DeathHandler deathHandler;
        if (!EntityHelper.isValidPlayer(event.getEntityPlayer()) || Helper.isRuleKeepInventory(event.getEntityPlayer())) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        WorldServer world = player.func_71121_q();
        if (event.isCanceled()) {
            LangKey.MESSAGE_DROP_CANCELED.sendLog(player.func_70005_c_());
            return;
        }
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        this.collectKeyAndSoulbound(event.getDrops().iterator(), keys, soulbounds);
        double range = ConfigTombstone.general.snifferRange;
        List itemList = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range));
        this.collectKeyAndSoulbound(itemList.iterator(), keys, soulbounds);
        if (event.getDrops().size() == 0 && itemList.size() == 1 && "cannibalism:playerflesh".equals(((EntityItem)itemList.get(0)).func_92059_d().func_77973_b().getRegistryName().toString())) {
            itemList.remove(0);
        }
        if ((deathHandler = DeathHandler.INSTANCE).getOptionDenyGraveOnDeath(player.func_110124_au())) {
            LangKey.MESSAGE_CHOOSE_NO_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            this.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            return;
        }
        int countDrop = event.getDrops().size() + itemList.size();
        boolean bl = hasDrop = countDrop > 0;
        if (!ConfigTombstone.general.handlePlayerDeath || !hasDrop) {
            if (!hasDrop) {
                ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().orElse(ItemStack.field_190927_a));
                LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            }
            this.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            return;
        }
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            LangKey.MESSAGE_NO_GRAVE_LOCATION.sendSpecialMessage((ICommandSender)player, new Object[0]);
            this.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            return;
        }
        BlockPos initPos = Helper.getCloserValidPos((World)world, new BlockPos((Entity)player));
        Location spawnPos = Location.ORIGIN;
        TileEntityTombstone tileGrave = world.func_175726_f(initPos).func_177434_r().values().stream().filter(tile -> tile instanceof TileEntityTombstone && ((TileEntityTombstone)((Object)tile)).getOwnerName().equals(player.func_70005_c_()) && ((TileEntityTombstone)((Object)tile)).hasEmptySlots(countDrop)).map(tile -> (TileEntityTombstone)((Object)tile)).findFirst().orElse(null);
        if (tileGrave != null) {
            if (world.func_180495_p(tileGrave.func_174877_v()).func_177230_c() instanceof BlockGrave) {
                spawnPos = new Location(tileGrave.func_174877_v(), (World)world);
            } else {
                tileGrave.dropOnGroundAndRemove();
            }
        }
        if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(player.func_70005_c_())).isOrigin() && lastGrave.dim == world.field_73011_w.getDimension() && lastGrave.getPos().func_177951_i((Vec3i)initPos) <= 400.0 && (tile2 = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityTombstone) {
            tileGrave = (TileEntityTombstone)tile2;
            if (world.func_180495_p(lastGrave.getPos()).func_177230_c() instanceof BlockGrave) {
                if (tileGrave.hasEmptySlots(countDrop)) {
                    spawnPos = lastGrave;
                }
            } else {
                tileGrave.dropOnGroundAndRemove();
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave && (spawnPos = new SpawnHelper(world, initPos).findSpawnPlace(true)).isOrigin()) {
            this.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendLog(new Object[0]);
            return;
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((EntityPlayer)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
            EnumFacing facing = player.func_174811_aO().func_176734_d();
            Pair<GraveModel, BlockGraveMarble.MarbleType> favoriteGrave = deathHandler.getFavoriteGraveBlock(player);
            state = ((GraveModel)((Object)favoriteGrave.getLeft())).getPlayerGrave().func_176223_P().func_177226_a((IProperty)BlockGraveBase.FACING, (Comparable)facing).func_177226_a((IProperty)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(((BlockGraveMarble.MarbleType)((Object)favoriteGrave.getRight())).ordinal()));
            Helper.placeNoEvent((World)world, spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        TileEntity tile3 = world.func_175625_s(spawnPos.getPos());
        if (!(tile3 instanceof TileEntityTombstone)) {
            this.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendLog(new Object[0]);
            return;
        }
        deathHandler.setLastDeathLocation((EntityPlayer)player, new Location(spawnPos.x, spawnPos.y + 1, spawnPos.z, spawnPos.dim));
        TileEntityTombstone grave = (TileEntityTombstone)tile3;
        if (hasGrave) {
            grave.resetDeathTime();
            grave.countTicks = 0;
        }
        boolean bl3 = needAccess = ConfigTombstone.general.playerGraveAccess && ConfigTombstone.general.decayTime != 0;
        if (needAccess && ConfigTombstone.general.pvpMode && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            needAccess = false;
        }
        (hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).sendSpecialMessage((ICommandSender)player, LangKey.MESSAGE_JOURNEYMAP.getTranslationWithStyle(StyleType.TOOLTIP_DESC, LangKey.MESSAGE_LAST_GRAVE.getTranslation(new Object[0]), spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim), (needAccess ? LangKey.MESSAGE_LOCKED : LangKey.MESSAGE_UNLOCKED).getTranslationWithStyle(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON, needAccess && ConfigTombstone.general.decayTime > 0 ? ConfigTombstone.general.decayTime + " min" : ""));
        if (ConfigTombstone.general.playerGraveAccess || ConfigTombstone.general.graveKeyOnDeath) {
            ItemStack key;
            if (hasGrave) {
                key = ItemStack.field_190927_a;
                for (ItemStack aKey : keys) {
                    if (!ModItems.grave_key.getTombPos(aKey).equals(spawnPos)) continue;
                    ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, aKey);
                    key = aKey;
                    break;
                }
                if (key.func_190926_b()) {
                    key = new ItemStack((Item)ModItems.grave_key);
                    ModItems.grave_key.setTombPos(key, spawnPos);
                    ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, key);
                    keys.add(0, key);
                }
            } else {
                key = new ItemStack((Item)ModItems.grave_key);
                ModItems.grave_key.setTombPos(key, spawnPos);
                ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, key);
                keys.add(0, key);
            }
        }
        this.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
        grave.setOwner(player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = (IItemHandler)grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (EntityItem entityItem : event.getDrops()) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        for (EntityItem entityItem : itemList) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        if (ConfigTombstone.compatibilities.supportWearableBackpacks && SupportMods.WEARABLE_BACKPACKS.isLoaded()) {
            CompatibilityWearableBackpacks.instance.checkWearableBackPacks((EntityPlayer)player, spawnPos.getPos());
        }
        if (SupportMods.SPONGE.isLoaded() && SupportMods.TECHGUNS.isLoaded()) {
            CompatibilityTechguns.instance.snifferDrops((World)world, player.func_180425_c(), spawnPos.getPos());
        }
        grave.func_70296_d();
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (event.getDrops().size() <= 120) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).orElse("").trim();
        boolean bl = valid = event.getRight().func_77973_b() == Items.field_151042_j && event.getLeft().func_77973_b() == ModItems.grave_plate || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && ItemCraftingIngredient.IconType.GRAVE_DUST.compareStack(event.getRight());
        if (valid) {
            event.setCost(1);
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().func_77946_l(), newName));
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilRepair(AnvilRepairEvent event) {
        if (event.getItemInput().func_77973_b() == ModItems.grave_plate && event.getIngredientInput().func_77973_b() == Items.field_151042_j && EngravableHelper.isEngraved(event.getItemResult()) && EntityHelper.isValidPlayerMP((Entity)event.getEntityPlayer())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void uncancelGraveRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block instanceof BlockGrave) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().field_72995_K && SpawnProtectionHandler.getInstance().isBlockProtected(event.getWorld().field_73011_w.getDimension(), event.getPos())) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().field_70170_p.field_72995_K && TimeHelper.atInterval(event.getEntityLiving().field_70170_p, 20)) {
            if (ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() && ConfigTombstone.client.showShadowStep && (!ConfigTombstone.enchantments.isNerfShadowStep() || event.getEntity().func_70093_af()) && EntityHelper.hasEnchantment(event.getEntityLiving(), ModEnchantments.shadow_step)) {
                ModTombstone.PROXY.produceShadowStep(event.getEntityLiving(), 115.0f);
            }
            if (ConfigTombstone.client.showShieldParticle && Optional.ofNullable(event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null)).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                ModTombstone.PROXY.produceShield(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() == Items.field_151068_bn && EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && PotionUtils.func_185189_a((ItemStack)event.getItem()).size() > 0) {
            event.getEntityLiving().getEntityData().func_74757_a("is_drinking_potion", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (this.isDrinking(event.getEntityLiving())) {
            this.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (this.isDrinking(event.getEntityLiving())) {
            this.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && this.isDrinking(event.getEntityLiving()) && event.getPotionEffect().field_76460_b > 1200 && Helper.isAllowedEffect(event.getPotionEffect())) {
            float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((EntityPlayer)event.getEntityLiving(), ModPerks.alchemist) * 0.1f;
            event.getPotionEffect().field_76460_b = MathHelper.func_76141_d((float)((float)event.getPotionEffect().field_76460_b * bonus));
        }
    }

    private boolean isDrinking(EntityLivingBase entityLiving) {
        return entityLiving.getEntityData().func_150297_b("is_drinking_potion", 1);
    }

    private void resetDrinking(EntityLivingBase entityLiving) {
        entityLiving.getEntityData().func_82580_o("is_drinking_potion");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScaleBeyondTheGraveDamage(LivingDamageEvent event) {
        if (event.getSource() == null || !EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) || !event.getEntityLiving().func_70089_S()) {
            return;
        }
        if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
            int knowledgeLevel;
            ITBCapability cap;
            if (ConfigTombstone.general.allowBeyondTheGraveDamage && (cap = (ITBCapability)event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null && (knowledgeLevel = cap.getTotalPerkPoints()) > 0) {
                event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
            }
        } else {
            int alignmentLevel;
            ITBCapability cap = (ITBCapability)event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
            int n = alignmentLevel = cap == null ? 0 : cap.getAlignmentLevel();
            if (alignmentLevel != 0 && event.getSource().func_76346_g() instanceof EntityLiving) {
                boolean valid;
                boolean bl = ((EntityLiving)event.getSource().func_76346_g()).func_70662_br() ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                if (valid) {
                    float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                    if (amount < 0.5f) {
                        event.setCanceled(true);
                    } else {
                        event.setAmount(amount);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Item heldItem = event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b();
        if (heldItem == ModItems.dust_of_vanishing || heldItem instanceof ItemGraveMagic) {
            event.setCancellationResult(EnumActionResult.PASS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider());
        } else if (event.getObject() instanceof EntityVillager || CompatibilityMinecolonies.instance.isCitizen((Entity)event.getObject())) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider(new ProtectedEntityImpl(EntityHelper::getHomeLocation)));
        }
    }

    @SubscribeEvent
    public void onTrackingStart(PlayerEvent.StartTracking event) {
        IProtectedEntity cap;
        if (EntityHelper.isValidPlayerMP((Entity)event.getEntityPlayer()) && event.getTarget() != null && (cap = (IProtectedEntity)event.getTarget().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null)) != null && cap.isActive()) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncProtectionMessage(event.getTarget().func_145782_y(), true), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidPlayer(event.player) && !event.player.field_70170_p.field_72995_K) {
            WorldServer toDim;
            long toTime;
            EntityHelper.syncTBCapability((EntityPlayerMP)event.player);
            MinecraftServer server = event.player.func_184102_h();
            if (server == null) {
                return;
            }
            WorldServer fromDim = server.func_71218_a(event.fromDim);
            long fromTime = fromDim.func_82737_E();
            if (fromTime != (toTime = (toDim = server.func_71218_a(event.toDim)).func_82737_E())) {
                IItemHandler inventPlayer;
                ITBCapability cap = (ITBCapability)event.player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
                if (cap != null) {
                    long timeToPray = Math.min(Math.max(0L, cap.getNextPray() - fromTime), (long)cap.getMaxPrayTime(event.player));
                    cap.setNextPray(toTime + timeToPray);
                    cap.setNextResetPerks(toTime + cap.getCooldownToResetPerks(event.player));
                    cap.setCooldownToRequestTeleport(toTime + (long)cap.getCooldownToRequestTeleport((EntityPlayerMP)event.player));
                }
                if ((inventPlayer = (IItemHandler)event.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                    IntStream.range(0, inventPlayer.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventPlayer).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.lost_tablet).forEach(stack -> ModItems.lost_tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((World)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10))));
                }
            }
        }
    }
}

