/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TextureHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;

@SideOnly(value=Side.CLIENT)
public class GuiKnowledge
extends TBScreen {
    private final ITBCapability cap;
    private final int iconSize = 16;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;
    private final ItemStack stackSkull = new ItemStack(ModItems.advancement, 1, 0);
    private final ItemStack stackRevive = new ItemStack(ModItems.advancement, 1, 6);
    private final ItemStack stackAnkh = new ItemStack(ModItems.advancement, 1, 3);
    private final double alignmentPos;

    public GuiKnowledge(ITBCapability cap) {
        this.cap = cap;
        for (Perk perk : PerkRegistry.perkRegistry.getValuesCollection()) {
            if (Helper.isDisabledPerk(perk)) continue;
            this.icons.add(new PerkIcon(perk));
        }
        this.alignmentPos = this.getBarRatio();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = this.icons.size() > 12 ? 22 : 31;
        int maxIconByLine = this.icons.size() > 12 ? 8 : 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        this.field_146292_n.add(new TBGuiButton(0, this.guiLeft + 10, this.guiBottom - 25, 70, 15, I18n.func_135052_a((String)"tombstone.compendium.main.title", (Object[])new Object[0])));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean clicked = false;
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk);
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    clicked = true;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                }
            } else if (mouseButton == 1 && Minecraft.func_71410_x().field_71439_g.func_184812_l_() && this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk) > 0) {
                clicked = true;
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
            }
        }
        if (!clicked) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInfo(null));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((EntityPlayer)this.field_146297_k.field_71439_g);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        GlStateManager.func_179094_E();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        String titleName = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getClientTranslation(new Object[0]);
        float f = (float)this.halfWidth - (float)this.field_146289_q.func_78256_a(titleName) / 2.0f;
        float f2 = (float)this.guiTop + 9.0f;
        ((Object)((Object)this)).getClass();
        this.field_146289_q.func_175065_a(titleName, f, f2, -1, false);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 18, -1);
        ((Object)((Object)this)).getClass();
        this.func_73730_a(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.GUI_BAR.bindTexture();
        GuiKnowledge.func_146110_a((int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (float)182.0f, (float)256.0f);
        GuiKnowledge.func_146110_a((int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints + 1))), (int)5, (float)182.0f, (float)256.0f);
        GuiKnowledge.func_146110_a((int)(this.guiLeft + 52), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (float)182.0f, (float)256.0f);
        int startAlignmentY = 44;
        this.func_73732_a(this.field_146289_q, "Alignment", this.halfWidth, this.guiTop + startAlignmentY - 4, -1);
        GuiKnowledge.func_73734_a((int)(this.guiLeft + 20), (int)(this.guiTop + startAlignmentY + 10), (int)(this.guiRight - 20), (int)(this.guiTop + startAlignmentY + 17), (int)-16777216);
        Helper.fillGradient(this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, this.field_73735_i, true);
        Helper.fillGradient(this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, this.field_73735_i, true);
        float step = (float)(this.xSize - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            this.func_73728_b(this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        this.field_146296_j.func_180450_b(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        this.field_146296_j.func_180450_b(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        int adjust = (int)Math.round((double)(this.xSize - 42) / 2.0 * this.alignmentPos);
        this.field_146296_j.func_180450_b(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        float f3 = this.guiLeft + 48 - this.field_146289_q.func_78256_a(levelString);
        float f4 = this.guiTop + 28;
        ((Object)((Object)this)).getClass();
        this.field_146289_q.func_175065_a(levelString, f3, f4, -1, false);
        for (PerkIcon icon : this.icons) {
            this.drawPerk(icon);
        }
        if (Helper.isContributor((EntityPlayer)this.field_146297_k.field_71439_g)) {
            float f5 = this.guiLeft + 30;
            float f6 = this.guiBottom - 45;
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_175065_a("Contributor", f5, f6, 8858573, false);
        }
        if (Helper.isDateAroundHalloween()) {
            String halloweenString = "Halloween";
            float f7 = this.guiRight - 30 - this.field_146289_q.func_78256_a(halloweenString);
            float f8 = this.guiBottom - 45;
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_175065_a(halloweenString, f7, f8, 8858573, false);
        }
        super.func_73863_a(mouseX, mouseY, partialTick);
        this.drawPerkTooltip();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignement = Math.abs(MathHelper.func_76125_a((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignement > 300 ? 0.75 + 0.25 * (double)(alignement - 300) * 0.005 : (alignement > 150 ? 0.5 + 0.25 * (double)(alignement - 150) / 150.0 : (alignement > 50 ? 0.25 + 0.25 * (double)(alignement - 50) * 0.01 : 0.25 * (double)alignement * 0.02));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(PerkIcon icon) {
        int n;
        int levelWithBonus = this.cap.getPerkLevelWithBonus((EntityPlayer)this.field_146297_k.field_71439_g, icon.perk);
        boolean isHovered = icon == this.hoveredIcon;
        boolean isMax = this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, icon.perk) == icon.perk.getLevelMax();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.func_73734_a((int)(icon.getMinX() - 1), (int)(icon.getMinY() - 1), (int)(icon.getMaxX() + 1), (int)(icon.getMaxY() + 1 + 10), (int)-15329733);
        if (isHovered) {
            int n2;
            if (isMax) {
                ((Object)((Object)this)).getClass();
                n2 = -1980292;
            } else {
                n2 = -7096363;
            }
            int color = n2;
            this.func_73730_a(icon.minX - 2, icon.maxX + 1, icon.minY - 2, color);
            this.func_73730_a(icon.minX - 2, icon.maxX + 1, icon.minY + 27, color);
            this.func_73728_b(icon.minX - 2, icon.minY - 2, icon.minY + 27, color);
            this.func_73728_b(icon.minX + 17, icon.minY - 2, icon.minY + 27, color);
        }
        if (levelWithBonus == 0 && !isHovered) {
            this.func_73733_a(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -13421773, -13421773);
            GlStateManager.func_179131_c((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
        } else {
            this.func_73733_a(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -16703669, -7096363);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ResourceLocation texture = icon.perk.getIcon();
        if (texture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(texture);
            GuiKnowledge.func_152125_a((int)icon.getMinX(), (int)icon.getMinY(), (float)0.0f, (float)0.0f, (int)64, (int)64, (int)this.iconSize, (int)this.iconSize, (float)64.0f, (float)64.0f);
        }
        boolean hasBonus = icon.perk.getLevelBonus((EntityPlayer)this.field_146297_k.field_71439_g) != 0;
        String string = "" + levelWithBonus;
        float f = (float)icon.getMinX() + (levelWithBonus > 9 ? 2.5f : 5.5f);
        float f2 = icon.getMinY() + 18;
        if (hasBonus) {
            ((Object)((Object)this)).getClass();
            n = 8858573;
        } else if (isMax) {
            ((Object)((Object)this)).getClass();
            n = -1980292;
        } else if (levelWithBonus > 0) {
            ((Object)((Object)this)).getClass();
            n = -12562177;
        } else {
            ((Object)((Object)this)).getClass();
            n = -8355712;
        }
        this.field_146289_q.func_175065_a(string, f, f2, n, false);
        GlStateManager.func_179121_F();
    }

    private void drawPerkTooltip() {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk);
            ArrayList<String> list = new ArrayList<String>(){
                {
                    this.add(((GuiKnowledge)GuiKnowledge.this).hoveredIcon.perk.getClientTranslation());
                }
            };
            String specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (!specialInfo.isEmpty()) {
                list.add(specialInfo);
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                String info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (!info.isEmpty()) {
                    list.add((this.hoveredPerkLevel >= i ? TextFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? TextFormatting.DARK_PURPLE : TextFormatting.DARK_GRAY)).toString() + i + " -> " + info);
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean canUpgrade = this.leftPerkPoints >= cost;
                list.add((canUpgrade ? TextFormatting.AQUA : TextFormatting.RED) + LangKey.MESSAGE_COST.getClientTranslation(cost));
                list.add(canUpgrade ? TextFormatting.BLUE + LangKey.MESSAGE_CLICK_TO_UPGRADE.getClientTranslation(new Object[0]) : TextFormatting.RED + LangKey.MESSAGE_CANT_UPGRADE.getClientTranslation(new Object[0]));
            } else {
                list.add(TextFormatting.GOLD + LangKey.MESSAGE_MAX.getClientTranslation(new Object[0]));
            }
            this.drawHoveringText((List<String>)list, this.hoveredIcon.minX + 10, this.hoveredIcon.minY + 10, this.field_146289_q);
        }
    }

    public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        int maxTextWidth = 200;
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = x + 12;
            if (tooltipX + tooltipTextWidth + 4 > this.field_146294_l && (tooltipX = x - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = x > this.field_146294_l / 2 ? x - 12 - 8 : this.field_146294_l - 16 - x;
                needsWrap = true;
            }
            if (tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = x > this.field_146294_l / 2 ? x - 16 - tooltipTextWidth : x + 12;
            }
            int tooltipY = y - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > this.field_146295_m) {
                tooltipY = this.field_146295_m - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            int perkLine = 0;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                boolean isPerkLine;
                String line = textLines.get(lineNumber);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String[] splits = line.split(" -> ");
                boolean bl = isPerkLine = splits.length > 1;
                if (isPerkLine && this.hoveredIcon.perk.isEncrypted() && perkLine > this.cap.getPerkLevelWithBonus((EntityPlayer)this.field_146297_k.field_71439_g, this.hoveredIcon.perk)) {
                    String subString = splits[0] + " -> ";
                    font.func_175065_a(subString, (float)tooltipX, (float)tooltipY, -1980292, false);
                    Minecraft.func_71410_x().field_71464_q.func_175065_a(TextFormatting.DARK_GRAY + splits[1], (float)(tooltipX + font.func_78256_a(subString)), (float)tooltipY, -1980292, false);
                } else {
                    font.func_175065_a(line, (float)tooltipX, (float)tooltipY, -1980292, false);
                }
                if (isPerkLine) {
                    ++perkLine;
                }
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public class PerkIcon {
        public final Perk perk;
        public int minX;
        public int minY;
        public int maxX;
        public int maxY;

        public PerkIcon(Perk perk) {
            this.perk = perk;
        }

        public void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        public boolean contains(int x, int y) {
            return x >= this.minX && y >= this.minY && x <= this.maxX && y <= this.maxY + 10;
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxY() {
            return this.maxY;
        }
    }
}

