/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    public final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    public final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private final HashMap<UUID, Pair<GraveModel, BlockGraveMarble.MarbleType>> optionFavoriteGrave = new HashMap();
    private final HashMap<UUID, Boolean> optionEquipElytraInPriority = new HashMap();
    private final HashMap<UUID, Boolean> optionKnowledgeMessage = new HashMap();
    private final HashMap<UUID, Boolean> optionPriorizeToolOnHotbar = new HashMap();
    private final Map<UUID, Boolean> optionActivateGraveBySneaking = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> optionDenyGraveOnDeath = new HashMap<UUID, Boolean>();
    private final HashMap<String, Location> lastGraveList = new HashMap();

    private DeathHandler() {
    }

    public List<String> getLastGraveList() {
        return new ArrayList<String>(this.lastGraveList.keySet());
    }

    public Location getLastGrave(String playerName) {
        return this.lastGraveList.getOrDefault(playerName, Location.ORIGIN);
    }

    public void removeGrave(Location pos) {
        Iterator<Map.Entry<String, Location>> it = this.lastGraveList.entrySet().iterator();
        while (it.hasNext()) {
            Location gravePos = it.next().getValue();
            if (!gravePos.equals(pos)) continue;
            it.remove();
        }
    }

    public void logLastGrave(@Nullable EntityPlayer player, int x, int y, int z, int dim) {
        if (player == null) {
            return;
        }
        this.lastGraveList.put(player.func_70005_c_(), new Location(x, y, z, dim));
        if (ConfigTombstone.general.logPlayerGrave) {
            LangKey.MESSAGE_LOG_LAST_GRAVE.sendLog(player.func_70005_c_(), LangKey.MESSAGE_LAST_GRAVE.getServerTranslation(new Object[0]), x, y, z, dim);
        }
    }

    public boolean isNoGraveLocation(Location location) {
        for (int i = 0; i < ConfigTombstone.general.noGraveLocation.length; ++i) {
            String[] res;
            if (ConfigTombstone.general.noGraveLocation[i].isEmpty() || !((res = ConfigTombstone.general.noGraveLocation[i].split(",")).length == 5 ? new Location(Integer.valueOf(res[0].trim()), Integer.valueOf(res[1].trim()), Integer.valueOf(res[2].trim()), (int)Integer.valueOf(res[3].trim())).isInRangeAndDimension(location, Integer.valueOf(res[4].trim())) : res.length == 1 && location.dim == Integer.valueOf(res[0].trim()))) continue;
            return true;
        }
        return false;
    }

    public void setLastDeathLocation(EntityPlayer player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), "tb_last_death_location", location);
    }

    public Location getLastDeathLocation(EntityPlayer player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), "tb_last_death_location");
    }

    public void addPlayerDead(EntityPlayer player) {
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag(player);
        persistentTag.func_74757_a("tb_is_player_dead", true);
        this.setLastDeathLocation(player, new Location((Entity)player));
        if (ConfigTombstone.general.restoreEffectsOnDeath || EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation)) {
            NBTTagList effectsList = new NBTTagList();
            player.func_70651_bq().stream().filter(Helper::isAllowedEffect).forEach(effect -> {
                NBTTagCompound effectData = new NBTTagCompound();
                effectData.func_74778_a("id", effect.func_188419_a().getRegistryName().toString());
                effectData.func_74768_a("amplifier", effect.func_76458_c());
                effectData.func_74768_a("duration", effect.func_76459_b());
                effectsList.func_74742_a((NBTBase)effectData);
            });
            persistentTag.func_74782_a("tb_preserved_effects", (NBTBase)effectsList);
        }
        persistentTag.func_74768_a("tb_experience_total", EntityHelper.getPlayerTotalXp(player));
        persistentTag.func_74768_a("tb_experience_level", player.field_71068_ca);
        persistentTag.func_74776_a("tb_experience_bar", player.field_71106_cc);
    }

    public void restorePlayerDead(EntityPlayer player) {
        if (!this.isPlayerDead(player)) {
            return;
        }
        if (!(Helper.isDisabledPerk(ModPerks.ghostly_shape) || SupportMods.DIM_DOORS.isLoaded() && player.field_70170_p.field_73011_w.func_186058_p().func_186065_b().equals("limbo"))) {
            EntityHelper.addPotion((EntityLivingBase)player, ModEffects.ghostly_shape, ConfigTombstone.general.getGhostlyShapeDuration() * 20, EntityHelper.getPerkLevelWithBonus(player, ModPerks.ghostly_shape), new boolean[0]);
        }
        NBTTagCompound persistantTag = EntityHelper.getPersistentTag(player);
        persistantTag.func_82580_o("tb_is_player_dead");
        if (persistantTag.func_150297_b("tb_preserved_effects", 9)) {
            NBTTagList effectList = persistantTag.func_150295_c("tb_preserved_effects", 10);
            for (int i = 0; i < effectList.func_74745_c(); ++i) {
                Potion effect;
                NBTTagCompound effectData = (NBTTagCompound)effectList.func_179238_g(i);
                String id = effectData.func_74779_i("id");
                if (id.length() <= 0 || !Helper.isAllowedEffect(effect = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(id)))) continue;
                EntityHelper.addPotion((EntityLivingBase)player, effect, effectData.func_74762_e("duration"), effectData.func_74762_e("amplifier"), new boolean[0]);
            }
            persistantTag.func_82580_o("tb_preserved_effects");
        }
    }

    public boolean isPlayerDead(EntityPlayer player) {
        return EntityHelper.getPersistentTag(player).func_74767_n("tb_is_player_dead");
    }

    public DeathHandler setOptionFavoriteGrave(UUID id, @Nullable GraveModel graveType, @Nullable BlockGraveMarble.MarbleType marbleType) {
        this.optionFavoriteGrave.put(id, (Pair<GraveModel, BlockGraveMarble.MarbleType>)Pair.of((Object)((Object)(graveType != null ? graveType : GraveModel.getDefault())), (Object)((Object)(marbleType != null ? marbleType : BlockGraveMarble.MarbleType.getDefault()))));
        return this;
    }

    public Pair<GraveModel, BlockGraveMarble.MarbleType> getFavoriteGraveBlock(EntityPlayerMP player) {
        return this.optionFavoriteGrave.getOrDefault(player.func_110124_au(), (Pair<GraveModel, BlockGraveMarble.MarbleType>)Pair.of((Object)((Object)GraveModel.getDefault()), (Object)((Object)BlockGraveMarble.MarbleType.getDefault())));
    }

    public DeathHandler setOptionEquipElytraInPriority(UUID id, boolean value) {
        this.optionEquipElytraInPriority.put(id, value);
        return this;
    }

    public boolean getOptionEquipElytraInPriority(UUID id) {
        return this.optionEquipElytraInPriority.getOrDefault(id, false);
    }

    public DeathHandler setOptionKnowledgeMessage(UUID id, boolean value) {
        this.optionKnowledgeMessage.put(id, value);
        return this;
    }

    public boolean getOptionKnowledgeMessage(UUID id) {
        return this.optionKnowledgeMessage.getOrDefault(id, true);
    }

    public DeathHandler setOptionPriorizeToolOnHotbar(UUID id, boolean value) {
        this.optionPriorizeToolOnHotbar.put(id, value);
        return this;
    }

    public boolean getOptionPriorizeToolOnHotbar(UUID id) {
        return this.optionPriorizeToolOnHotbar.getOrDefault(id, false);
    }

    public DeathHandler setOptionActivateGraveBySneaking(UUID id, boolean value) {
        this.optionActivateGraveBySneaking.put(id, value);
        return this;
    }

    public boolean getOptionActivateGraveBySneaking(UUID id) {
        return this.optionActivateGraveBySneaking.getOrDefault(id, false);
    }

    public DeathHandler setOptionDenyGraveOnDeath(UUID id, boolean value) {
        this.optionDenyGraveOnDeath.put(id, value);
        return this;
    }

    public boolean getOptionDenyGraveOnDeath(UUID id) {
        return this.optionDenyGraveOnDeath.getOrDefault(id, false);
    }

    public void handleMobDrops(EntityLivingBase entity, @Nullable DamageSource damageSource, List<EntityItem> drops) {
        EntityPlayerMP player;
        EntityPlayerMP entityPlayerMP = player = damageSource != null && EntityHelper.isValidPlayerMP(damageSource.func_76346_g()) ? (EntityPlayerMP)damageSource.func_76346_g() : null;
        if (entity.func_70662_br()) {
            int chanceModifier = EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.bone_collector) * 100;
            if (Helper.getRandom(1, 1000 - chanceModifier) <= ConfigTombstone.loot.chanceGraveDust + chanceModifier) {
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ItemCraftingIngredient.IconType.GRAVE_DUST.getStack(Helper.getRandom(1, 2))));
            }
            if (ConfigTombstone.loot.undeadCanDropSkull && entity instanceof AbstractSkeleton && Helper.getRandom(1, 1000 - chanceModifier) <= 5) {
                ItemStack skullStack = new ItemStack(Items.field_151144_bL, 1, entity instanceof EntityWitherSkeleton ? 1 : 0);
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, skullStack));
            }
            if (!entity.func_184222_aU()) {
                ItemStack stack;
                if (ConfigTombstone.loot.chanceSoulReceptacleOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceSoulReceptacleOnBoss) {
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Item)ModItems.soul_receptacle)));
                }
                if (ConfigTombstone.loot.chanceRandomScrollOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceRandomScrollOnBoss) {
                    stack = new ItemStack((Item)ModItems.scroll_buff, 1, ItemScrollBuff.SpellBuff.getRandomBuff().ordinal());
                    NBTStackHelper.setBoolean(stack, "enchant", true);
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                }
                if (ConfigTombstone.loot.chanceRandomPoppetOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceRandomPoppetOnBoss) {
                    stack = new ItemStack((Item)ModItems.voodoo_poppet);
                    ModItems.voodoo_poppet.addProtection(stack, ItemVoodooPoppet.PoppetProtections.getRandomProtection());
                    NBTStackHelper.setBoolean(stack, "enchant", true);
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                }
                if (player != null && ConfigTombstone.loot.chanceDecorativeGraveOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceDecorativeGraveOnBoss) {
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(GraveModel.getRandomGraveModel().getDecorativeGrave(), Helper.random.nextInt(2))));
                }
            }
        }
        if (entity instanceof EntityMob && player != null && (Helper.isContributor((EntityPlayer)player) || Helper.isDateAroundHalloween(player.field_70170_p)) && Helper.getRandom(1, 1000) <= 100) {
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(ModItems.lollypop, 1, Helper.getRandom(0, 4))));
        }
    }

    public void clear() {
        this.optionFavoriteGrave.clear();
        this.optionEquipElytraInPriority.clear();
        this.optionKnowledgeMessage.clear();
        this.optionPriorizeToolOnHotbar.clear();
        this.optionActivateGraveBySneaking.clear();
        this.optionDenyGraveOnDeath.clear();
        this.lastGraveList.clear();
    }
}

