/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SupportStructures;

public class SpawnHelper {
    private final World world;
    private final BlockPos initPos;
    private List<BlockPos> positions;
    private final Map<BlockPos, EnumSpawnPlace> spawnPlaces = new HashMap<BlockPos, EnumSpawnPlace>();
    private BlockPos spawnPos = null;
    private EnumSpawnType spawnType = EnumSpawnType.NONE;
    private final boolean isWaterWorld;
    private final boolean isCubicWorld;
    private final boolean isBelowBedRock;

    public SpawnHelper(WorldServer world, BlockPos initPos) {
        this(world, initPos, true);
    }

    public SpawnHelper(WorldServer world, BlockPos initPos, boolean generate) {
        this.world = world;
        this.initPos = Helper.getCloserValidPos((World)world, initPos);
        if (generate && !world.func_190526_b(initPos.func_177958_n(), initPos.func_177952_p())) {
            SpawnHelper.generateChunk(world, initPos);
        }
        this.isCubicWorld = SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld();
        this.isWaterWorld = SupportMods.CAVERN.isLoaded() && world.field_73011_w.func_186058_p().func_186065_b().equals("aqua_cavern");
        this.isBelowBedRock = SupportMods.FUTURE_PACK.isLoaded() && world.field_73011_w.func_186058_p().func_186065_b().equals("belowbedrock");
    }

    public Location findSpawnPlace() {
        return this.findSpawnPlace(false);
    }

    public Location findSafePlace(int range, boolean withHeight, boolean playerPlace) {
        this.spawnPlaces.clear();
        Iterable it = BlockPos.func_177980_a((BlockPos)this.initPos.func_177982_a(-range, withHeight ? -range : 0, -range), (BlockPos)this.initPos.func_177982_a(range, withHeight ? range : 0, range));
        this.positions = StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList());
        this.positions.sort(Comparator.comparingDouble(pos0 -> pos0.func_177951_i((Vec3i)this.initPos)));
        for (BlockPos currentPos : this.positions) {
            if (!(playerPlace ? this.isValidSpawnPlace(currentPos) : this.isSafePlace(currentPos))) continue;
            return new Location(currentPos, this.world);
        }
        return this.spawnType.ordinal() >= EnumSpawnType.NORMAL.ordinal() ? new Location(this.spawnPos, this.world) : Location.ORIGIN;
    }

    public Location findPlaceInStructure(SupportStructures struct) {
        this.positions = this.initPositions();
        int maxY = !this.isCubicWorld ? Math.min(struct.getY() + 16, this.world.field_73011_w.getActualHeight()) : struct.getY() + 16;
        int minY = !this.isCubicWorld ? Math.max(struct.getY() - 16, 0) : struct.getY() - 16;
        int yUp = this.initPos.func_177956_o();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && this.isValidSpawnPlace(currentPos = new BlockPos(pos.func_177958_n(), yUp, pos.func_177952_p()))) {
                    return new Location(currentPos, this.world);
                }
                if (!canGoDown || !this.isValidSpawnPlace(currentPos = new BlockPos(pos.func_177958_n(), yDown, pos.func_177952_p()))) continue;
                return new Location(currentPos, this.world);
            }
            ++yUp;
            --yDown;
        }
        return this.spawnType.ordinal() >= EnumSpawnType.NORMAL.ordinal() ? new Location(this.spawnPos, this.world) : Location.ORIGIN;
    }

    public Location findSpawnPlace(boolean isGrave) {
        int minY;
        int maxY;
        boolean wasInLiquid;
        this.positions = this.initPositions();
        this.spawnPos = null;
        this.spawnType = EnumSpawnType.NONE;
        this.spawnPlaces.clear();
        BlockPos adjustedPos = this.initPos;
        boolean bl = wasInLiquid = !this.isWaterWorld && (this.world.func_180495_p(adjustedPos).func_185904_a().func_76224_d() || this.world.func_175701_a(adjustedPos.func_177984_a()) && this.world.func_180495_p(adjustedPos.func_177984_a()).func_185904_a().func_76224_d());
        if (wasInLiquid) {
            adjustedPos = adjustedPos.func_177984_a();
            while (this.world.func_180495_p(adjustedPos).func_185904_a().func_76224_d()) {
                if (this.world.func_175701_a(adjustedPos = adjustedPos.func_177984_a()) && adjustedPos.func_177956_o() - this.initPos.func_177956_o() <= 300) continue;
                adjustedPos = this.initPos;
                wasInLiquid = false;
                break;
            }
        }
        if (!isGrave) {
            maxY = !this.isCubicWorld ? Math.min(adjustedPos.func_177956_o() + 70, this.isBelowBedRock ? 256 : this.world.field_73011_w.getActualHeight()) : adjustedPos.func_177956_o() + 70;
            minY = !this.isCubicWorld ? Math.max(adjustedPos.func_177956_o() - 70, 0) : adjustedPos.func_177956_o() - 70;
        } else {
            maxY = !this.isCubicWorld ? (this.isBelowBedRock ? 256 : this.world.field_73011_w.getActualHeight()) : adjustedPos.func_177956_o() + 300;
            minY = !this.isCubicWorld ? 0 : adjustedPos.func_177956_o() - 300;
        }
        int yUp = adjustedPos.func_177956_o();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                boolean valid;
                BlockPos currentPos;
                if (canGoUp) {
                    currentPos = new BlockPos(pos.func_177958_n(), yUp, pos.func_177952_p());
                    boolean bl2 = valid = !isGrave ? this.isValidSpawnPlace(currentPos) : this.isValidGravePlace(currentPos);
                    if (valid) {
                        return new Location(currentPos, this.world);
                    }
                }
                if (!canGoDown) continue;
                currentPos = new BlockPos(pos.func_177958_n(), yDown, pos.func_177952_p());
                valid = !isGrave ? this.isValidSpawnPlace(currentPos) : this.isValidGravePlace(currentPos);
                if (!valid) continue;
                return new Location(currentPos, this.world);
            }
            ++yUp;
            --yDown;
        }
        boolean valid = false;
        if (isGrave) {
            if (this.spawnType != EnumSpawnType.NONE) {
                valid = true;
            }
        } else if (this.spawnType.ordinal() >= EnumSpawnType.NORMAL.ordinal()) {
            valid = true;
        }
        return valid ? new Location(this.spawnPos, this.world) : Location.ORIGIN;
    }

    private boolean isWaterPlace(BlockPos pos) {
        return this.getPlaceType(pos).isWater();
    }

    private boolean isSafePlace(BlockPos pos) {
        EnumSpawnPlace placeType = this.getPlaceType(pos);
        return placeType.isSafe() || this.isWaterWorld && placeType.isWater();
    }

    private boolean isSafeGround(BlockPos pos) {
        EnumSpawnPlace placeType = this.getPlaceType(pos);
        return placeType.isGround() || this.isWaterWorld && placeType.isWater();
    }

    private boolean isGravePlace(BlockPos pos) {
        return this.isSafePlace(pos) && this.world.func_175625_s(pos) == null;
    }

    private boolean isValidSpawnPlace(BlockPos pos) {
        if (this.isSafeGround(pos.func_177977_b()) && this.isSafePlace(pos) && this.isSafePlace(pos.func_177984_a())) {
            this.setTypeAndPosition(EnumSpawnType.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isValidGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            this.setTypeAndPosition(EnumSpawnType.MINIMAL, pos);
            if (this.isSafeGround(pos.func_177977_b())) {
                this.setTypeAndPosition(EnumSpawnType.NORMAL, pos);
                if (this.isSafePlace(pos.func_177984_a())) {
                    this.setTypeAndPosition(EnumSpawnType.FIT, pos);
                    if (this.isSafePlace(pos.func_177981_b(2))) {
                        this.setTypeAndPosition(EnumSpawnType.IDEAL, pos);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void setTypeAndPosition(EnumSpawnType type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private EnumSpawnPlace getPlaceType(BlockPos pos) {
        return this.spawnPlaces.computeIfAbsent(pos, p -> SpawnHelper.getPathNodeTypeRaw(this.world, p));
    }

    private static void generateChunk(WorldServer world, BlockPos initPos) {
        ChunkPos chunkPos = new ChunkPos(initPos);
        for (int x = chunkPos.field_77276_a - 1; x <= chunkPos.field_77276_a + 1; ++x) {
            for (int z = chunkPos.field_77275_b - 1; z <= chunkPos.field_77275_b + 1; ++z) {
                ChunkPos currentChunk = new ChunkPos(x, z);
                world.func_180495_p(currentChunk.func_180331_a(0, 0, 0));
            }
        }
    }

    private List<BlockPos> initPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        Iterable it = BlockPos.func_177980_a((BlockPos)new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d()), (BlockPos)new BlockPos(chunkPos.func_180332_e(), 0, chunkPos.func_180330_f()));
        this.positions = StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList());
        this.positions.sort((pos0, pos1) -> {
            double dist0 = pos0.func_177954_c((double)this.initPos.func_177958_n(), 0.0, (double)this.initPos.func_177952_p());
            double dist1 = pos1.func_177954_c((double)this.initPos.func_177958_n(), 0.0, (double)this.initPos.func_177952_p());
            return Double.compare(dist0, dist1);
        });
        return this.positions;
    }

    private static <T extends World> EnumSpawnPlace getPathNodeTypeRaw(T world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!Helper.isValidPos(world, pos) || !world.func_175667_e(pos)) {
            return EnumSpawnPlace.UNSAFE;
        }
        PathNodeType type = block.getAiPathNodeType(state, world, pos);
        if (type == null) {
            if (mat == Material.field_151579_a) {
                return EnumSpawnPlace.SAFE;
            }
            if (mat == Material.field_151586_h) {
                return EnumSpawnPlace.WATER;
            }
            if (mat == Material.field_151587_i || mat == Material.field_151581_o || mat == Material.field_151567_E) {
                return EnumSpawnPlace.UNSAFE;
            }
            if (block instanceof BlockSlab || block instanceof BlockStairs || block instanceof BlockCarpet) {
                return EnumSpawnPlace.GROUND;
            }
            if (block instanceof BlockCactus || block instanceof BlockMagma || block instanceof BlockTrapDoor || block instanceof BlockDoor || block instanceof BlockWall || block instanceof BlockFence || block instanceof BlockFenceGate) {
                return EnumSpawnPlace.UNSAFE;
            }
            return block.func_176205_b(world, pos) ? EnumSpawnPlace.SAFE : (block.func_149730_j(state) ? EnumSpawnPlace.GROUND : EnumSpawnPlace.UNSAFE);
        }
        switch (type) {
            case OPEN: {
                return EnumSpawnPlace.SAFE;
            }
            case BLOCKED: 
            case WALKABLE: {
                return EnumSpawnPlace.GROUND;
            }
        }
        return EnumSpawnPlace.UNSAFE;
    }

    public static enum EnumSpawnType {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;

    }

    public static enum EnumSpawnPlace {
        SAFE,
        GROUND,
        UNSAFE,
        WATER;


        public boolean isSafe() {
            return this == SAFE;
        }

        public boolean isGround() {
            return this == GROUND;
        }

        public boolean isWater() {
            return this == WATER;
        }
    }
}

