/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.registry.ModTriggers;

public class UpdateServerMessage
implements IMessage {
    private GraveModel graveModel;
    private BlockGraveMarble.MarbleType marbleType;
    private boolean equipElytraInPriority;
    private boolean displayKnowledgeMessage;
    private boolean priorizeToolOnHotbar;
    private boolean activateGraveBySneaking;
    private boolean denyGraveOnDeath;
    private boolean isLogin;

    public UpdateServerMessage() {
    }

    public UpdateServerMessage(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, boolean equipElytraInPriority, boolean displayKnowledgeMessage, boolean priorizeToolOnHotbar, boolean activateGraveBySneaking, boolean denyGraveOnDeath, boolean isLogin) {
        this.graveModel = graveModel;
        this.marbleType = marbleType;
        this.equipElytraInPriority = equipElytraInPriority;
        this.displayKnowledgeMessage = displayKnowledgeMessage;
        this.priorizeToolOnHotbar = priorizeToolOnHotbar;
        this.activateGraveBySneaking = activateGraveBySneaking;
        this.denyGraveOnDeath = denyGraveOnDeath;
        this.isLogin = isLogin;
    }

    public void fromBytes(ByteBuf buf) {
        this.graveModel = GraveModel.getModel(buf.readByte());
        this.marbleType = BlockGraveMarble.MarbleType.byId(buf.readByte());
        this.equipElytraInPriority = buf.readBoolean();
        this.displayKnowledgeMessage = buf.readBoolean();
        this.priorizeToolOnHotbar = buf.readBoolean();
        this.activateGraveBySneaking = buf.readBoolean();
        this.denyGraveOnDeath = buf.readBoolean();
        this.isLogin = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.graveModel.ordinal());
        buf.writeByte(this.marbleType.ordinal());
        buf.writeBoolean(this.equipElytraInPriority);
        buf.writeBoolean(this.displayKnowledgeMessage);
        buf.writeBoolean(this.priorizeToolOnHotbar);
        buf.writeBoolean(this.activateGraveBySneaking);
        buf.writeBoolean(this.denyGraveOnDeath);
        buf.writeBoolean(this.isLogin);
    }

    public static class Handler
    implements IMessageHandler<UpdateServerMessage, IMessage> {
        public IMessage onMessage(UpdateServerMessage message, MessageContext ctx) {
            IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                DeathHandler.INSTANCE.setOptionFavoriteGrave(player.func_110124_au(), message.graveModel, message.marbleType).setOptionEquipElytraInPriority(player.func_110124_au(), message.equipElytraInPriority).setOptionKnowledgeMessage(player.func_110124_au(), message.displayKnowledgeMessage).setOptionPriorizeToolOnHotbar(player.func_110124_au(), message.priorizeToolOnHotbar).setOptionActivateGraveBySneaking(player.func_110124_au(), message.activateGraveBySneaking).setOptionDenyGraveOnDeath(player.func_110124_au(), message.denyGraveOnDeath);
                if (!message.isLogin) {
                    ModTriggers.CHOOSE_GRAVE_TYPE.trigger(player);
                }
            });
            return null;
        }
    }
}

