/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.util.I18N;
import binnie.extrabees.utils.Utils;
import com.google.common.collect.ImmutableList;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.oredict.OreDictionary;

public enum ExtraBeesFlowers implements IFlowerProvider,
IAlleleFlowers
{
    WATER,
    SUGAR,
    ROCK,
    BOOK,
    DEAD,
    REDSTONE,
    WOOD,
    LEAVES,
    SAPLING,
    FRUIT,
    MYSTICAL;

    private final boolean dominant;

    private ExtraBeesFlowers() {
        this.dominant = true;
    }

    public static void doInit() {
        for (ExtraBeesFlowers effect : ExtraBeesFlowers.values()) {
            effect.register();
        }
    }

    public String getUID() {
        return "extrabees.flower." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IFlowerProvider getProvider() {
        return this;
    }

    public String getDescription() {
        return I18N.localise("extrabees.flowers." + this.name().toLowerCase() + ".name");
    }

    public void register() {
        IFlowerRegistry flowerRegistry = FlowerManager.flowerRegistry;
        for (Block block : this.getAcceptableBlocks()) {
            flowerRegistry.registerAcceptableFlower(block, new String[]{this.getUID()});
        }
        switch (this) {
            case ROCK: {
                flowerRegistry.registerAcceptableFlowerRule((blockState, world, pos, flowerType) -> blockState.func_185904_a() == Material.field_151576_e, new String[]{this.getUID()});
                break;
            }
            case LEAVES: {
                flowerRegistry.registerAcceptableFlowerRule((blockState, world, pos, flowerType) -> blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)world, pos), new String[]{this.getUID()});
                break;
            }
            case WOOD: {
                flowerRegistry.registerAcceptableFlowerRule((blockState, world, pos, flowerType) -> blockState.func_177230_c().isWood((IBlockAccess)world, pos), new String[]{this.getUID()});
            }
        }
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumBeeChromosome.FLOWER_PROVIDER});
    }

    public List<Block> getAcceptableBlocks() {
        switch (this) {
            case WATER: {
                return Collections.singletonList(Blocks.field_150392_bi);
            }
            case SUGAR: {
                return Collections.singletonList(Blocks.field_150436_aH);
            }
            case ROCK: {
                return ImmutableList.of((Object)Blocks.field_150347_e, (Object)Blocks.field_150348_b);
            }
            case BOOK: {
                return Collections.singletonList(Blocks.field_150342_X);
            }
            case REDSTONE: {
                return ImmutableList.of((Object)Blocks.field_150429_aA, (Object)Blocks.field_150451_bX, (Object)Blocks.field_150450_ax, (Object)Blocks.field_150439_ay);
            }
            case DEAD: {
                return Collections.singletonList(Blocks.field_150330_I);
            }
            case FRUIT: {
                return Collections.emptyList();
            }
            case SAPLING: {
                ArrayList<Block> saplingBlocks = new ArrayList<Block>();
                for (ItemStack itemStack : OreDictionary.getOres((String)"treeSapling")) {
                    saplingBlocks.add(Block.func_149634_a((Item)itemStack.func_77973_b()));
                }
                return saplingBlocks;
            }
            case MYSTICAL: {
                Block flower = Utils.getBotaniaBlock("flower");
                return flower == null ? Collections.emptyList() : Collections.singletonList(flower);
            }
        }
        return Collections.emptyList();
    }

    public boolean isAcceptedFlower(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        switch (this) {
            case WATER: {
                return block == Blocks.field_150392_bi;
            }
            case ROCK: {
                return world.func_180495_p(pos).func_185904_a() == Material.field_151576_e;
            }
            case SUGAR: {
                return block == Blocks.field_150436_aH;
            }
            case BOOK: {
                return block == Blocks.field_150342_X;
            }
            case REDSTONE: {
                return block == Blocks.field_150429_aA;
            }
            case DEAD: {
                return block == Blocks.field_150330_I;
            }
            case WOOD: {
                return block.isWood((IBlockAccess)world, pos);
            }
            case FRUIT: {
                return world.func_175625_s(pos) instanceof IFruitBearer;
            }
            case LEAVES: {
                return block.isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos);
            }
            case SAPLING: {
                return block.getClass().getName().toLowerCase().contains("sapling");
            }
            case MYSTICAL: {
                return block == Utils.getBotaniaBlock("flower");
            }
        }
        return false;
    }

    public String getName() {
        return this.getDescription();
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    public String getFlowerType() {
        return this.getUID();
    }

    public boolean isAcceptedPollinatable(World world, ICheckPollinatable pollinatable) {
        return pollinatable.getPlantType() != EnumPlantType.Nether;
    }

    public NonNullList<ItemStack> affectProducts(World world, IIndividual individual, BlockPos pos, NonNullList<ItemStack> products) {
        if (this == MYSTICAL) {
            NonNullList prods = NonNullList.func_191196_a();
            prods.addAll(products);
            for (int k = 0; k < 50; ++k) {
                int z2;
                int y2;
                int tX = 7;
                int tY = 7;
                int tZ = 3;
                int x2 = pos.func_177958_n() - 7 + world.field_73012_v.nextInt(15);
                BlockPos pos2 = new BlockPos(x2, y2 = pos.func_177956_o() - 7 + world.field_73012_v.nextInt(15), z2 = pos.func_177952_p() - 3 + world.field_73012_v.nextInt(7));
                Block block = world.func_180495_p(pos2).func_177230_c();
                if (block != Utils.getBotaniaBlock("flower")) continue;
                int meta = world.func_180495_p(pos2).func_177230_c().func_176201_c(world.func_180495_p(pos2));
                Item item = Utils.getBotaniaItem("petal");
                if (item == null) continue;
                prods.add((Object)new ItemStack(item, 1, meta));
            }
            return prods;
        }
        return products;
    }
}

