/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.loader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.json.factory.IObjectFactory;
import com.teamacronymcoders.base.recipesystem.Recipe;
import com.teamacronymcoders.base.recipesystem.RecipeSystem;
import com.teamacronymcoders.base.recipesystem.condition.ICondition;
import com.teamacronymcoders.base.recipesystem.event.RegisterRecipeFactoriesEvent;
import com.teamacronymcoders.base.recipesystem.input.IInput;
import com.teamacronymcoders.base.recipesystem.loader.ILoader;
import com.teamacronymcoders.base.recipesystem.output.IOutput;
import com.teamacronymcoders.base.recipesystem.type.RecipeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import org.apache.commons.io.FilenameUtils;

public abstract class JsonRecipeLoader
implements ILoader {
    private static boolean loadedFactories = false;
    private static final Map<String, IObjectFactory<? extends IInput>> inputFactories = Maps.newHashMap();
    private static final Map<String, IObjectFactory<? extends IOutput>> outputFactories = Maps.newHashMap();
    private static final Map<String, IObjectFactory<? extends ICondition>> conditionFactories = Maps.newHashMap();
    private final Gson GSON = new Gson();

    protected JsonRecipeLoader() {
        this.loadFactories();
    }

    private void loadFactories() {
        if (!loadedFactories) {
            RegisterRecipeFactoriesEvent<IInput> inputEvent = new RegisterRecipeFactoriesEvent<IInput>(IInput.class);
            MinecraftForge.EVENT_BUS.post(inputEvent);
            inputFactories.putAll(inputEvent.getFactories());
            RegisterRecipeFactoriesEvent<IOutput> outputEvent = new RegisterRecipeFactoriesEvent<IOutput>(IOutput.class);
            MinecraftForge.EVENT_BUS.post(outputEvent);
            outputFactories.putAll(outputEvent.getFactories());
            RegisterRecipeFactoriesEvent<ICondition> conditionEvent = new RegisterRecipeFactoriesEvent<ICondition>(ICondition.class);
            MinecraftForge.EVENT_BUS.post(conditionEvent);
            conditionFactories.putAll(conditionEvent.getFactories());
            loadedFactories = true;
        }
    }

    @Override
    public abstract List<Recipe> loadRecipes();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Recipe loadRecipe(JsonContext ctx, Path root, Path file) {
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) return null;
        if (relative.startsWith("_")) {
            return null;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
        try (BufferedReader bufferedReader = Files.newBufferedReader(file);){
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193839_a((Gson)this.GSON, (Reader)bufferedReader, JsonObject.class);
            if (jsonObject == null) return null;
            if (!jsonObject.has("type")) return null;
            String typeName = jsonObject.get("type").getAsString();
            RecipeType recipeType = RecipeSystem.getRecipeType(typeName);
            if (recipeType == null) throw new JsonParseException("No Recipe Type found for: " + typeName);
            boolean loadRecipe = true;
            if (jsonObject.has("load_conditions")) {
                loadRecipe = CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"load_conditions"), (JsonContext)ctx);
            }
            if (!loadRecipe) return null;
            int priority = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"priority", (int)0);
            JsonArray inputsJson = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"inputs");
            JsonArray outputsJson = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"outputs");
            JsonArray conditionsJson = JsonUtils.func_151213_a((JsonObject)jsonObject, (String)"conditions", (JsonArray)new JsonArray());
            List inputList = JsonRecipeLoader.processJsonArray(inputsJson, ctx, inputFactories::get, "Input");
            List<IOutput> outputList = JsonRecipeLoader.processOutputs(outputsJson, ctx);
            List conditionList = JsonRecipeLoader.processJsonArray(conditionsJson, ctx, conditionFactories::get, "Conditions");
            Recipe recipe = new Recipe(key, priority, this.getRecipeSource(), recipeType, inputList, outputList, conditionList);
            return recipe;
        }
        catch (JsonParseException | IOException e) {
            Base.instance.getLogger().getLogger().warn("Error in recipe: " + key.toString(), e);
        }
        return null;
    }

    public static List<IOutput> processOutputs(JsonArray jsonElements, JsonContext context) {
        return JsonRecipeLoader.processJsonArray(jsonElements, context, outputFactories::get, "Output");
    }

    private static <T> List<T> processJsonArray(JsonArray jsonElements, JsonContext context, Function<String, IObjectFactory<? extends T>> factoryFunction, String name) {
        ArrayList processedList = Lists.newArrayList();
        for (JsonElement element : jsonElements) {
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                String typeName = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"type");
                IObjectFactory<T> factory = factoryFunction.apply(typeName);
                jsonObject.remove("type");
                if (factory != null) {
                    processedList.add(factory.parse(context, (JsonElement)jsonObject));
                    continue;
                }
                throw new JsonParseException("No " + name + " found for type: " + typeName);
            }
            throw new JsonParseException(name + "s must be JSON Objects");
        }
        return processedList;
    }
}

