/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockElectricGate;
import cassiokf.industrialrenewal.blocks.BlockLight;
import cassiokf.industrialrenewal.blocks.BlockWindow;
import cassiokf.industrialrenewal.blocks.redstone.BlockSignalIndicator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBaseWall
extends BlockBase {
    public static final PropertyBool CORE = PropertyBool.func_177716_a((String)"core");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static float NORTHZ1 = 0.25f;
    private static float SOUTHZ2 = 0.75f;
    private static float WESTX1 = 0.25f;
    private static float EASTX2 = 0.75f;
    private static final float DOWNY1 = 0.0f;
    private static final float UPY2 = 1.0f;

    public BlockBaseWall(String name, CreativeTabs tab) {
        super(Material.field_151576_e, name, tab);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        NORTHZ1 = this.isConnected(actualState, NORTH) ? 0.0f : 0.25f;
        SOUTHZ2 = this.isConnected(actualState, SOUTH) ? 1.0f : 0.75f;
        WESTX1 = this.isConnected(actualState, WEST) ? 0.0f : 0.25f;
        EASTX2 = this.isConnected(actualState, EAST) ? 1.0f : 0.75f;
        return new AxisAlignedBB((double)WESTX1, 0.0, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        NORTHZ1 = this.isConnected(state, NORTH) ? 0.0f : 0.25f;
        SOUTHZ2 = this.isConnected(state, SOUTH) ? 1.0f : 0.75f;
        WESTX1 = this.isConnected(state, WEST) ? 0.0f : 0.25f;
        EASTX2 = this.isConnected(state, EAST) ? 1.0f : 0.75f;
        AxisAlignedBB AA_BB = new AxisAlignedBB((double)WESTX1, 0.0, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
        BlockBaseWall.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AA_BB);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CORE, NORTH, SOUTH, EAST, WEST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    private boolean shouldRenderCenter(IBlockAccess world, BlockPos ownPos) {
        return !(this.canCenterConnectTo(world, ownPos, EnumFacing.NORTH) && this.canCenterConnectTo(world, ownPos, EnumFacing.SOUTH) && !this.canCenterConnectTo(world, ownPos, EnumFacing.EAST) && !this.canCenterConnectTo(world, ownPos, EnumFacing.WEST) || !this.canCenterConnectTo(world, ownPos, EnumFacing.NORTH) && !this.canCenterConnectTo(world, ownPos, EnumFacing.SOUTH) && this.canCenterConnectTo(world, ownPos, EnumFacing.EAST) && this.canCenterConnectTo(world, ownPos, EnumFacing.WEST));
    }

    private boolean canCenterConnectTo(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        Block nb = neighbourState.func_177230_c();
        return nb instanceof BlockBaseWall || nb.func_149686_d(neighbourState) || nb instanceof BlockWindow;
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        Block nb = neighbourState.func_177230_c();
        return nb instanceof BlockBaseWall || nb.func_149686_d(neighbourState) || nb instanceof BlockElectricGate || nb instanceof BlockLight || nb instanceof BlockSignalIndicator || nb instanceof BlockWindow;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, EnumFacing.WEST))).func_177226_a((IProperty)CORE, (Comparable)Boolean.valueOf(this.shouldRenderCenter(world, pos)));
        return state;
    }

    public final boolean isConnected(IBlockState state, PropertyBool property) {
        return (Boolean)state.func_177229_b((IProperty)property);
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

