/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockElectricGate;
import cassiokf.industrialrenewal.blocks.abstracts.BlockBasicElectricFence;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockBigFenceColumn
extends BlockBasicElectricFence {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger INDEX = PropertyInteger.func_177719_a((String)"index", (int)0, (int)2);
    public static final IUnlistedProperty<Boolean> CORE = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"core"));
    public static final IUnlistedProperty<Boolean> ACTIVE_LEFT = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"active_left"));
    public static final IUnlistedProperty<Boolean> ACTIVE_RIGHT = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"active_right"));
    public static final IUnlistedProperty<Boolean> ACTIVE_LEFT_TOP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"active_left_top"));
    public static final IUnlistedProperty<Boolean> ACTIVE_RIGHT_TOP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"active_right_top"));
    public static final IUnlistedProperty<Boolean> ACTIVE_LEFT_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"active_left_down"));
    public static final IUnlistedProperty<Boolean> ACTIVE_RIGHT_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"active_right_down"));

    public BlockBigFenceColumn(String name, CreativeTabs tab) {
        super(name, tab);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)INDEX) == 0) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)INDEX, (Comparable)Integer.valueOf(1)));
            worldIn.func_175656_a(pos.func_177981_b(2), state.func_177226_a((IProperty)INDEX, (Comparable)Integer.valueOf(2)));
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)INDEX)) {
            case 0: {
                if (this.IsBigFence(worldIn, pos.func_177984_a())) {
                    worldIn.func_175698_g(pos.func_177984_a());
                }
                if (!this.IsBigFence(worldIn, pos.func_177981_b(2))) break;
                worldIn.func_175698_g(pos.func_177981_b(2));
                break;
            }
            case 1: {
                if (this.IsBigFence(worldIn, pos.func_177977_b())) {
                    worldIn.func_175698_g(pos.func_177977_b());
                }
                if (!this.IsBigFence(worldIn, pos.func_177984_a())) break;
                worldIn.func_175698_g(pos.func_177984_a());
                break;
            }
            case 2: {
                if (this.IsBigFence(worldIn, pos.func_177977_b())) {
                    worldIn.func_175698_g(pos.func_177977_b());
                }
                if (!this.IsBigFence(worldIn, pos.func_177979_c(2))) break;
                worldIn.func_175698_g(pos.func_177979_c(2));
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public boolean IsBigFence(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockBigFenceColumn;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(2));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FACING, INDEX};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{CORE, ACTIVE_LEFT, ACTIVE_RIGHT, ACTIVE_LEFT_TOP, ACTIVE_RIGHT_TOP, ACTIVE_LEFT_DOWN, ACTIVE_RIGHT_DOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    @Deprecated
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)INDEX) == 2 ? 15 : 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)INDEX, (Comparable)Integer.valueOf(0));
    }

    public IBlockState func_176203_a(int meta) {
        int directionIndex = meta;
        if (meta > 3 && meta < 8) {
            directionIndex -= 4;
        }
        if (meta > 7) {
            directionIndex -= 8;
        }
        int index = 0;
        if (meta > 3 && meta < 8) {
            index = 1;
        }
        if (meta > 7) {
            index = 2;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)directionIndex)).func_177226_a((IProperty)INDEX, (Comparable)Integer.valueOf(index));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if ((Integer)state.func_177229_b((IProperty)INDEX) == 1) {
            i += 4;
        }
        if ((Integer)state.func_177229_b((IProperty)INDEX) == 2) {
            i += 8;
        }
        return i;
    }

    public boolean ActiveSide(IBlockAccess world, BlockPos pos, IBlockState state, boolean left, boolean top, boolean down) {
        int index = (Integer)state.func_177229_b((IProperty)INDEX);
        if (!top && index == 2) {
            return false;
        }
        if (top && index != 2) {
            return false;
        }
        if (!down && index == 0) {
            return false;
        }
        if (down && index != 0) {
            return false;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if ((!left || face != facing.func_176735_f()) && (left || face != facing.func_176746_e())) continue;
            IBlockState sideState = world.func_180495_p(pos.func_177972_a(face));
            Block block = sideState.func_177230_c();
            return sideState.func_185913_b() || block instanceof BlockElectricGate || block instanceof BlockBasicElectricFence;
        }
        return false;
    }

    private boolean isCore(IBlockState state) {
        int index = (Integer)state.func_177229_b((IProperty)INDEX);
        return index == 1;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)state;
            return eState.withProperty(CORE, (Object)this.isCore(state)).withProperty(ACTIVE_LEFT, (Object)this.ActiveSide(world, pos, state, true, false, false)).withProperty(ACTIVE_RIGHT, (Object)this.ActiveSide(world, pos, state, false, false, false)).withProperty(ACTIVE_LEFT_TOP, (Object)this.ActiveSide(world, pos, state, true, true, false)).withProperty(ACTIVE_RIGHT_TOP, (Object)this.ActiveSide(world, pos, state, false, true, false)).withProperty(ACTIVE_LEFT_DOWN, (Object)this.ActiveSide(world, pos, state, true, false, true)).withProperty(ACTIVE_RIGHT_DOWN, (Object)this.ActiveSide(world, pos, state, false, false, true));
        }
        return state;
    }
}

