/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.redstone;

import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntity;
import cassiokf.industrialrenewal.blocks.redstone.BlockFuseBox;
import cassiokf.industrialrenewal.blocks.redstone.BlockFuseBoxConduitExtension;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.tileentity.TileEntityBoxConnector;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFuseBoxConnector
extends BlockTileEntity<TileEntityBoxConnector> {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger UPCONDUIT = PropertyInteger.func_177719_a((String)"up", (int)0, (int)2);
    private static final AxisAlignedBB WEST_EAST_BLOCK_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.125, 1.0);
    private static final AxisAlignedBB NORTH_SOUTH_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 0.125, 0.625);

    public BlockFuseBoxConnector(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side == ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e() || side == ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f();
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBoxConnector te = (TileEntityBoxConnector)world.func_175625_s(pos);
        int value = te.passRedstone();
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f() == side ? value : 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entity.field_71071_by.func_70448_g().func_77973_b() == ModItems.screwDrive) {
            this.rotateBlock(world, pos, state);
            return true;
        }
        return false;
    }

    private void rotateBlock(World world, BlockPos pos, IBlockState state) {
        EnumFacing newFace = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)newFace));
    }

    private int canConnectConduit(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        if (upState.func_177230_c() instanceof BlockFuseBox || upState.func_177230_c() instanceof BlockFuseBoxConduitExtension) {
            if (state.func_177229_b((IProperty)FACING) == upState.func_177229_b((IProperty)FACING)) {
                return 1;
            }
            if (state.func_177229_b((IProperty)FACING) == ((EnumFacing)upState.func_177229_b((IProperty)FACING)).func_176734_d()) {
                return 2;
            }
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)UPCONDUIT, (Comparable)Integer.valueOf(this.canConnectConduit(state, world, pos)));
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)UPCONDUIT, (Comparable)Integer.valueOf(0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, UPCONDUIT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_185899_b(source, pos).func_177229_b((IProperty)FACING)) {
            default: {
                return NORTH_SOUTH_BLOCK_AABB;
            }
            case EAST: 
            case WEST: 
        }
        return WEST_EAST_BLOCK_AABB;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public TileEntityBoxConnector createTileEntity(World world, IBlockState state) {
        return new TileEntityBoxConnector();
    }
}

