/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.gui;

import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.util.buttons.ButtonBookOverIcon;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GUIManual
extends GuiScreen {
    private static final ResourceLocation bookBackground = new ResourceLocation("industrialrenewal", "textures/gui/book_background.png");
    private static final ResourceLocation logoIMG = new ResourceLocation("industrialrenewal", "textures/gui/book/logo.png");
    private static final ResourceLocation railroadIMG = new ResourceLocation("industrialrenewal", "textures/gui/book/railroad.png");
    private static final ResourceLocation redstoneIMG = new ResourceLocation("industrialrenewal", "textures/gui/book/redstone.png");
    private static final ResourceLocation utilsIMG = new ResourceLocation("industrialrenewal", "textures/gui/book/utils.png");
    private static final ResourceLocation warning = new ResourceLocation("industrialrenewal", "textures/gui/book/warning.png");
    private final int bookImageWidth = 256;
    private final int bookImageHeight = 171;
    private final World world;
    private final EntityPlayer player;
    private final ArrayList<ItemStack> items = new ArrayList();
    private final ArrayList<String> texts = new ArrayList();
    private final ArrayList<ItemStack> railroadItems = new ArrayList();
    private final ArrayList<ItemStack> redstoneItems = new ArrayList();
    private final ArrayList<ItemStack> utilsItems = new ArrayList();
    private int xOffset;
    private int yOffset;
    private int page = 0;
    private ButtonBookOverIcon button1;
    private ButtonBookOverIcon button2;
    private ButtonBookOverIcon button3;
    private ButtonBookOverIcon button4;
    private ButtonBookOverIcon button5;
    private ButtonBookOverIcon button6;
    private ButtonBookOverIcon buttonRailroad1;
    private ButtonBookOverIcon buttonRailroad2;
    private ButtonBookOverIcon buttonRailroad3;
    private ButtonBookOverIcon buttonRailroad4;
    private ButtonBookOverIcon buttonRedstone1;
    private ButtonBookOverIcon buttonRedstone2;
    private ButtonBookOverIcon buttonRedstone3;
    private ButtonBookOverIcon buttonUtils1;
    private ButtonBookOverIcon buttonUtils2;
    private ButtonBookOverIcon buttonUtils3;
    private ButtonBookOverIcon buttonBack;

    public GUIManual(World world, EntityPlayer player) {
        this.world = world;
        this.player = player;
        this.items.clear();
        this.texts.clear();
        this.railroadItems.clear();
        this.utilsItems.clear();
        this.items.add(new ItemStack((Item)ModItems.steamLocomotive));
        this.texts.add(I18n.func_135052_a((String)"gui.industrialrenewal.railroad.category", (Object[])new Object[0]));
        this.items.add(new ItemStack((Block)ModBlocks.fuseBox));
        this.texts.add(I18n.func_135052_a((String)"gui.industrialrenewal.redstone.category", (Object[])new Object[0]));
        this.items.add(new ItemStack((Block)ModBlocks.catWalk));
        this.texts.add(I18n.func_135052_a((String)"gui.industrialrenewal.catwalk.category", (Object[])new Object[0]));
        this.items.add(new ItemStack((Block)ModBlocks.efence));
        this.texts.add(I18n.func_135052_a((String)"gui.industrialrenewal.fences.category", (Object[])new Object[0]));
        this.items.add(new ItemStack((Item)ModItems.fireExtinguisher));
        this.texts.add(I18n.func_135052_a((String)"gui.industrialrenewal.utilities.category", (Object[])new Object[0]));
        this.items.add(new ItemStack((Block)ModBlocks.pillar));
        this.texts.add(I18n.func_135052_a((String)"gui.industrialrenewal.construction.category", (Object[])new Object[0]));
        this.railroadItems.add(new ItemStack((Item)ModItems.steamLocomotive));
        this.railroadItems.add(new ItemStack((Item)ModItems.cargoContainer));
        this.railroadItems.add(new ItemStack((Item)ModItems.fluidContainer));
        this.railroadItems.add(new ItemStack((Block)ModBlocks.normalRail));
        this.redstoneItems.add(new ItemStack((Block)ModBlocks.fuseBox));
        this.redstoneItems.add(new ItemStack((Block)ModBlocks.flameDetector));
        this.redstoneItems.add(new ItemStack((Block)ModBlocks.entityDetector));
        this.utilsItems.add(new ItemStack((Item)ModItems.fireExtinguisher));
        this.utilsItems.add(new ItemStack((Block)ModBlocks.gutter));
        this.utilsItems.add(new ItemStack((Block)ModBlocks.firstAidKit));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.xOffset = (this.field_146294_l - 256) / 2;
        this.yOffset = (this.field_146295_m - 171) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookBackground);
        this.func_73729_b(this.xOffset, this.yOffset, 0, 0, 256, 171);
        switch (this.page) {
            default: {
                this.drawPictureOnTop(warning, 48, 0, 0);
                this.drawText("Please, report this error code: \n \n PAGEERROR" + this.page);
                break;
            }
            case 0: {
                this.drawPictureOnTop(logoIMG, 56, 0, 0);
                this.drawIcons(this.items, this.texts, true);
                break;
            }
            case 1: {
                this.drawPictureOnTop(railroadIMG, 54, 0, 0);
                this.drawIcons(this.railroadItems, null, true);
                break;
            }
            case 2: {
                this.drawPictureOnTop(redstoneIMG, 54, 0, 0);
                this.drawIcons(this.redstoneItems, null, true);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.drawPictureOnTop(utilsIMG, 54, 0, 0);
                this.drawIcons(this.utilsItems, null, true);
                break;
            }
            case 6: {
                break;
            }
            case 11: {
                this.drawPictureOnTop(railroadIMG, 54, 0, 55);
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.steam_locomotive.text0", (Object[])new Object[0]));
                break;
            }
            case 12: {
                this.drawPictureOnTop(railroadIMG, 54, 0, 109);
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.cargo_container.text0", (Object[])new Object[0]));
                break;
            }
            case 13: {
                this.drawPictureOnTop(railroadIMG, 54, 0, 163);
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.fluid_container.text0", (Object[])new Object[0]));
                break;
            }
            case 14: {
                this.drawPictureOnTop(railroadIMG, 54, 101, 0);
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.rails.text0", (Object[])new Object[0]));
                break;
            }
            case 21: {
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.fuse_box.text0", (Object[])new Object[0]));
                break;
            }
            case 22: {
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.flame_detector.text0", (Object[])new Object[0]));
                break;
            }
            case 23: {
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.entity_detector.text0", (Object[])new Object[0]));
                break;
            }
            case 51: {
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.fire_extinguisher.text0", (Object[])new Object[0]));
                break;
            }
            case 52: {
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.gutter.text0", (Object[])new Object[0]));
                break;
            }
            case 53: {
                this.drawText(I18n.func_135052_a((String)"gui.industrialrenewal.first-aid_box.text0", (Object[])new Object[0]));
            }
        }
        this.drawPageName();
        this.drawPageNumber();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawText(String text) {
        String[] words;
        int maxPixelsPerLine = 93;
        StringBuilder currentLine = new StringBuilder();
        int currentWidth = 0;
        int yoffset = 66;
        int xoffset = 18;
        int maxLineFirstPage = 9;
        int currentLineN = 0;
        boolean changeLine = false;
        for (String word : words = text.split("\\s+")) {
            if (currentWidth + this.field_146289_q.func_78256_a(word) <= maxPixelsPerLine && !word.equals("$n")) {
                currentLine.append(word).append(" ");
                currentWidth += this.field_146289_q.func_78256_a(word);
                continue;
            }
            if (++currentLineN > maxLineFirstPage && !changeLine) {
                changeLine = true;
                yoffset = 18;
                xoffset += 110;
            }
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)currentLine.toString(), (Object[])new Object[0]), (this.field_146294_l - 256) / 2 + 5 + xoffset, (this.field_146295_m - 171) / 2 + yoffset, 0x404040);
            currentLine = new StringBuilder();
            currentWidth = 0;
            yoffset += this.field_146289_q.field_78288_b;
            if (word.equals("$n")) continue;
            currentLine.append(word).append(" ");
            currentWidth += this.field_146289_q.func_78256_a(word);
        }
        if (currentWidth != 0) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)currentLine.toString(), (Object[])new Object[0]), (this.field_146294_l - 256) / 2 + 5 + xoffset, (this.field_146295_m - 171) / 2 + yoffset, 0x404040);
        }
    }

    private void drawIcons(ArrayList<ItemStack> array, ArrayList<String> texts, boolean pictureOnTop) {
        int x = this.xOffset + 22;
        int y = this.yOffset + 12;
        if (pictureOnTop) {
            y += 52;
        }
        boolean secondSide = false;
        for (ItemStack item : array) {
            String text = texts == null || texts.get(this.items.indexOf(item)) == null ? item.func_82833_r() : texts.get(this.items.indexOf(item));
            this.drawIcon(text, item, x, y);
            if ((y += 20) <= this.yOffset + 150 || secondSide) continue;
            y = this.yOffset + 12;
            x += 108;
            secondSide = true;
        }
    }

    private void drawIcon(String text, ItemStack item, int x, int y) {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        this.field_146296_j.func_175042_a(item, x, y);
        this.field_146289_q.func_78276_b(text, x += 20, y + 5, 0);
        RenderHelper.func_74519_b();
    }

    private void drawPictureOnTop(ResourceLocation resourceLocation, int yImage, int startX, int startY) {
        int x = this.xOffset + 24;
        int y = this.yOffset + 9;
        GlStateManager.func_179094_E();
        this.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
        this.func_73729_b(x, y, startX, startY, 100, yImage);
        GlStateManager.func_179121_F();
    }

    private void drawPageName() {
        if (this.page < 7 && this.page > 0) {
            int x = this.xOffset + 64 - 4;
            int y = this.yOffset + 1;
            String name = this.texts.get(this.page - 1);
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            this.field_146289_q.func_78276_b(name, x -= name.length() / 2, y, 0xFF0000);
            RenderHelper.func_74519_b();
        }
    }

    private void drawPageNumber() {
        if (this.page != 0) {
            int x = this.xOffset + 222;
            int y = this.yOffset + 3;
            this.field_146289_q.func_78276_b(String.valueOf(this.page), x, y, 0);
        }
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146127_k < 200) {
            this.page = b.field_146127_k;
        }
        if (b.field_146127_k == 200) {
            if (this.page <= 10) {
                this.page = 0;
            } else {
                int x = Math.abs(this.page);
                this.page = (int)Math.floor((double)x / Math.pow(10.0, Math.floor(Math.log10(x))));
            }
        }
    }

    public void func_73876_c() {
        this.button1.field_146125_m = this.page == 0;
        this.button2.field_146125_m = this.page == 0;
        this.button3.field_146125_m = this.page == 0;
        this.button4.field_146125_m = this.page == 0;
        this.button5.field_146125_m = this.page == 0;
        this.button6.field_146125_m = this.page == 0;
        this.buttonRailroad1.field_146125_m = this.page == 1;
        this.buttonRailroad2.field_146125_m = this.page == 1;
        this.buttonRailroad3.field_146125_m = this.page == 1;
        this.buttonRailroad4.field_146125_m = this.page == 1;
        this.buttonRedstone1.field_146125_m = this.page == 2;
        this.buttonRedstone2.field_146125_m = this.page == 2;
        this.buttonRedstone3.field_146125_m = this.page == 2;
        this.buttonUtils1.field_146125_m = this.page == 5;
        this.buttonUtils2.field_146125_m = this.page == 5;
        this.buttonUtils3.field_146125_m = this.page == 5;
        this.buttonBack.field_146125_m = this.page != 0;
    }

    public void func_73866_w_() {
        this.xOffset = (this.field_146294_l - 256) / 2;
        this.yOffset = (this.field_146295_m - 171) / 2;
        int x = this.xOffset + 22;
        int y = this.yOffset + 62;
        this.button1 = new ButtonBookOverIcon(1, x, y, 103, 20, " ");
        this.field_146292_n.add(this.button1);
        this.button2 = new ButtonBookOverIcon(2, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.button2);
        this.button3 = new ButtonBookOverIcon(3, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.button3);
        this.button4 = new ButtonBookOverIcon(4, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.button4);
        this.button5 = new ButtonBookOverIcon(5, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.button5);
        y = this.yOffset + 10;
        this.button6 = new ButtonBookOverIcon(6, x += 108, y, 103, 20, " ");
        this.field_146292_n.add(this.button6);
        x = this.xOffset + 22;
        y = this.yOffset + 62;
        this.buttonRailroad1 = new ButtonBookOverIcon(11, x, y, 103, 20, " ");
        this.field_146292_n.add(this.buttonRailroad1);
        this.buttonRailroad2 = new ButtonBookOverIcon(12, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonRailroad2);
        this.buttonRailroad3 = new ButtonBookOverIcon(13, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonRailroad3);
        this.buttonRailroad4 = new ButtonBookOverIcon(14, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonRailroad4);
        x = this.xOffset + 22;
        y = this.yOffset + 62;
        this.buttonRedstone1 = new ButtonBookOverIcon(21, x, y, 103, 20, " ");
        this.field_146292_n.add(this.buttonRedstone1);
        this.buttonRedstone2 = new ButtonBookOverIcon(22, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonRedstone2);
        this.buttonRedstone3 = new ButtonBookOverIcon(23, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonRedstone3);
        x = this.xOffset + 22;
        y = this.yOffset + 62;
        this.buttonUtils1 = new ButtonBookOverIcon(51, x, y, 103, 20, " ");
        this.field_146292_n.add(this.buttonUtils1);
        this.buttonUtils2 = new ButtonBookOverIcon(52, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonUtils2);
        this.buttonUtils3 = new ButtonBookOverIcon(53, x, y += 20, 103, 20, " ");
        this.field_146292_n.add(this.buttonUtils3);
        this.buttonBack = new ButtonBookOverIcon(200, this.xOffset + 20, this.yOffset + 144, 20, 20, "<<");
        this.field_146292_n.add(this.buttonBack);
    }

    public boolean func_73868_f() {
        return true;
    }

    public void func_146281_b() {
        this.world.func_184133_a(this.player, this.player.func_180425_c(), IRSoundRegister.BOOK_FLIP, SoundCategory.BLOCKS, 1.0f, 0.8f);
    }
}

