/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.handlers;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.TileEntityChunkLoader;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkManagerCallback
implements ForgeChunkManager.PlayerOrderedLoadingCallback {
    public static boolean isTicketValid(IBlockAccess blockAccess, ForgeChunkManager.Ticket ticket) {
        NBTTagCompound modData = ticket.getModData();
        if (!modData.func_74764_b("blockPosition")) {
            return false;
        }
        BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)modData.func_74775_l("blockPosition"));
        TileEntity te = blockAccess.func_175625_s(pos);
        return te instanceof TileEntityChunkLoader && ((TileEntityChunkLoader)te).isMaster();
    }

    public static void activateTicket(World world, ForgeChunkManager.Ticket ticket) {
        if (!ChunkManagerCallback.isTicketValid((IBlockAccess)world, ticket)) {
            return;
        }
        NBTTagCompound modData = ticket.getModData();
        BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)modData.func_74775_l("blockPosition"));
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityChunkLoader) || !((TileEntityChunkLoader)te).isMaster()) {
            return;
        }
        TileEntityChunkLoader tileEntity = (TileEntityChunkLoader)te;
        int size = modData.func_74762_e("size");
        ChunkPos chunk = new ChunkPos(pos);
        int minX = chunk.field_77276_a - (int)((float)size / 2.0f);
        int maxX = chunk.field_77276_a + (int)((float)(size - 1) / 2.0f);
        int minZ = chunk.field_77275_b - (int)((float)size / 2.0f);
        int maxZ = chunk.field_77275_b + (int)((float)(size - 1) / 2.0f);
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                ChunkPos ticketChunk = new ChunkPos(x, z);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ticketChunk);
            }
        }
        tileEntity.setTicket(ticket);
        String playerName = ticket.getPlayerName();
        EntityPlayerMP player = ChunkManagerCallback.getOnlinePlayerByName(world.func_73046_m(), playerName);
        if (player != null) {
            tileEntity.addTrackedPlayer((EntityPlayer)player);
        }
    }

    public static EntityPlayerMP getOnlinePlayerByName(MinecraftServer server, String playerName) {
        EntityPlayerMP locatedPlayer = null;
        if (server == null || server.func_184103_al() == null || playerName == null) {
            return null;
        }
        PlayerList playerList = server.func_184103_al();
        for (EntityPlayerMP entityPlayerMP : playerList.func_181057_v()) {
            if (!playerName.equals(entityPlayerMP.func_70005_c_())) continue;
            locatedPlayer = entityPlayerMP;
            break;
        }
        return locatedPlayer;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        ArrayListMultimap returnedTickets = ArrayListMultimap.create();
        if (IRConfig.MainConfig.Main.emergencyMode) {
            return returnedTickets;
        }
        for (Map.Entry playerTicketMap : tickets.asMap().entrySet()) {
            String player = (String)playerTicketMap.getKey();
            for (ForgeChunkManager.Ticket ticket : (Collection)playerTicketMap.getValue()) {
                if (!ChunkManagerCallback.isTicketValid((IBlockAccess)world, ticket)) continue;
                returnedTickets.put((Object)player, (Object)ticket);
            }
        }
        return returnedTickets;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound modData = ticket.getModData();
            if (!modData.func_74764_b("blockPosition")) continue;
            ChunkManagerCallback.activateTicket(world, ticket);
        }
    }
}

