/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tesr;

import cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class TESRBase<T extends TileEntity>
extends TileEntitySpecialRenderer<T> {
    public static final ItemStack cutter = new ItemStack((Item)ModItems.cutter);
    public static final ItemStack energyBarLevel = new ItemStack((Item)ModItems.barLevel);
    public static final ItemStack pointerLong = new ItemStack((Item)ModItems.pointerLong);
    public static final ItemStack pointer = new ItemStack((Item)ModItems.pointer);
    public static final ItemStack limiter = new ItemStack((Item)ModItems.limiter);
    public static final ItemStack indicator_on = new ItemStack((Item)ModItems.indicator_on);
    public static final ItemStack indicator_off = new ItemStack((Item)ModItems.indicator_off);
    public static final ItemStack switch_on = new ItemStack((Item)ModItems.switch_on);
    public static final ItemStack switch_off = new ItemStack((Item)ModItems.switch_off);
    public static final ItemStack push_button = new ItemStack((Item)ModItems.push_button);
    public static final ItemStack label_5 = new ItemStack((Item)ModItems.label_5);
    public double xPos = 0.0;
    public double zPos = 0.0;

    public static void renderScreenTexts(EnumFacing facing, double x, double y, double z, String[] text, float spacing, float scale) {
        double lY = y;
        for (String line : text) {
            TESRBase.renderText(facing, x, lY, z, TextFormatting.GREEN + line, scale, false);
            lY -= (double)spacing;
        }
    }

    public static void renderText(EnumFacing facing, double x, double y, double z, String st, float scale) {
        TESRBase.renderText(facing, x, y, z, st, scale, true);
    }

    private static void renderText(EnumFacing facing, double x, double y, double z, String st, float scale, boolean centerText) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        RenderHelper.func_74518_a();
        TESRBase.rotateAccordingly(facing);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int xh = centerText ? -fontRenderer.func_78256_a(st) / 2 : 0;
        fontRenderer.func_78276_b(st, xh, 0, -1);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    public static ItemStack getIndicator(boolean value) {
        return value ? indicator_on : indicator_off;
    }

    public static ItemStack getSwitch(boolean value) {
        return value ? switch_on : switch_off;
    }

    public static void render3dItem(EnumFacing facing, World world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight) {
        TESRBase.render3dItem(facing, world, x, y, z, stack, scale, disableLight, false, 0.0f, 0.0f, 0.0f, 0.0f, false, false);
    }

    public static void render3dItem(EnumFacing facing, World world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight, float rotation, float rX, float rY, float rZ) {
        TESRBase.render3dItem(facing, world, x, y, z, stack, scale, disableLight, true, rotation, rX, rY, rZ, false, false);
    }

    public static void render3dItem(EnumFacing facing, World world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight, boolean applyRotation, float rotation, float rX, float rY, float rZ, boolean rotateHorizontal, boolean rotateVertical) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        if (disableLight) {
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        TESRBase.rotateAccordingly(facing);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (rotateHorizontal) {
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotateVertical) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (applyRotation) {
            GlStateManager.func_179114_b((float)rotation, (float)rX, (float)rY, (float)rZ);
        }
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, null);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        if (disableLight) {
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179084_k();
    }

    public static void render2dItem(EnumFacing facing, World world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        if (disableLight) {
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        TESRBase.rotateAccordingly(facing);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, null);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        if (disableLight) {
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179084_k();
    }

    public static void renderBarLevel(EnumFacing facing, double x, double y, double z, float fill, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        TESRBase.rotateAccordingly(facing);
        GlStateManager.func_179152_a((float)scale, (float)(fill * scale), (float)0.05f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(energyBarLevel, ItemCameraTransforms.TransformType.GUI);
        GlStateManager.func_179121_F();
    }

    public static void renderPointer(EnumFacing facing, double x, double y, double z, float angle, ItemStack pointer, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        TESRBase.rotateAccordingly(facing);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(pointer, ItemCameraTransforms.TransformType.GUI);
        GlStateManager.func_179121_F();
    }

    public static void rotateAccordingly(EnumFacing facing) {
        switch (facing) {
            default: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    public static float smoothAnimation(float rotation, float oldRotation, float partialTick, boolean invert) {
        float r = oldRotation + (rotation - oldRotation) * partialTick;
        return invert ? -r : r;
    }

    public abstract void func_192841_a(T var1, double var2, double var4, double var6, float var8, int var9, float var10);

    public void doTheMath(EnumFacing facing, double x, double z, double offset, double sidePlus) {
        switch (facing) {
            case SOUTH: {
                this.xPos = x + (0.5 - sidePlus);
                this.zPos = z + (1.0 - offset);
                return;
            }
            case NORTH: {
                this.xPos = x + (0.5 + sidePlus);
                this.zPos = z + offset;
                return;
            }
            case EAST: {
                this.xPos = x + (1.0 - offset);
                this.zPos = z + (0.5 + sidePlus);
                return;
            }
            case WEST: {
                this.xPos = x + offset;
                this.zPos = z + (0.5 - sidePlus);
            }
        }
    }
}

