/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import cassiokf.industrialrenewal.util.interfaces.IDynamicSound;
import cassiokf.industrialrenewal.util.interfaces.IMecanicalEnergy;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityDamGenerator
extends TileEntityMultiBlockBase<TileEntityDamGenerator>
implements IMecanicalEnergy,
IDynamicSound {
    public static final int maxGeneration = IRConfig.MainConfig.Main.damGeneratorEnergyPerTick;
    private static final VoltsEnergyContainer energyContainer = new VoltsEnergyContainer(0, 0, 0){

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return false;
        }
    };
    private static final float volume = IRConfig.MainConfig.Sounds.turbineVolume * IRConfig.MainConfig.Sounds.masterVolumeMult;
    private int oldGeneration;
    private int generation;
    private int rotation;

    @Override
    public void onTick() {
        if (this.isMaster()) {
            if (!this.field_145850_b.field_72995_K) {
                IEnergyStorage energyStorage;
                TileEntity te;
                this.generation = (int)(Utils.normalizeClamped(this.rotation, 0.0f, 6000.0f) * (float)maxGeneration);
                if (this.generation > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2))) != null && (energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) != null) {
                    energyStorage.receiveEnergy(this.generation, false);
                }
                if (this.generation != this.oldGeneration) {
                    this.oldGeneration = this.generation;
                    this.sync();
                }
                this.rotation = 0;
            } else {
                this.updateSound(this.getPitch());
            }
        }
    }

    private void updateSound(float pitch) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.generation > 0) {
            IRSoundHandler.playRepeatableSound(IRSoundRegister.MOTOR_ROTATION_RESOURCEL, volume, pitch, this.field_174879_c);
        } else {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    @Override
    public void onMasterBreak() {
        if (this.field_145850_b.field_72995_K) {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    @Override
    public float getPitch() {
        return Utils.normalizeClamped(this.generation, 0.0f, maxGeneration) * 1.4f;
    }

    @Override
    public float getVolume() {
        return volume;
    }

    @Override
    public boolean canAcceptRotation(BlockPos pos, EnumFacing side) {
        return pos.equals((Object)((TileEntityDamGenerator)this.getMaster()).func_174877_v().func_177977_b()) && side == EnumFacing.DOWN;
    }

    @Override
    public int passRotation(int amount) {
        if (this.func_145837_r() || ((TileEntityDamGenerator)this.getMaster()).func_145837_r()) {
            return 0;
        }
        if (!this.isMaster()) {
            return ((TileEntityDamGenerator)this.getMaster()).passRotation(amount);
        }
        this.rotation = amount;
        return amount;
    }

    @Override
    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x2x3CenteredPlus1OnTop(centerPosition);
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TileEntityDamGenerator;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == EnumFacing.UP && this.field_174879_c.equals((Object)((TileEntityDamGenerator)this.getMaster()).func_174877_v().func_177984_a()) && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("generation", this.generation);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.generation = compound.func_74762_e("generation");
        super.func_145839_a(compound);
    }

    public String getGenerationText() {
        return Utils.formatEnergyString(this.generation) + "/t";
    }

    public float getGenerationFill() {
        return Utils.normalizeClamped(this.generation, 0.0f, maxGeneration) * 90.0f;
    }
}

