/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.tubes;

import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import cassiokf.industrialrenewal.util.MultiBlockHelper;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileEntityEnergyCable
extends TileEntityMultiBlocksTube<TileEntityEnergyCable> {
    public final VoltsEnergyContainer energyContainer = new VoltsEnergyContainer(this.getMaxEnergyToTransport(), this.getMaxEnergyToTransport(), this.getMaxEnergyToTransport()){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TileEntityEnergyCable.this.onEnergyReceived(maxReceive, simulate);
        }
    };
    public int averageEnergy;
    public int potentialEnergy;
    private int oldPotential = -1;
    private int oldEnergy;
    private int tick;

    @Override
    public void tick() {
        if (!this.field_145850_b.field_72995_K && this.isMaster()) {
            if (this.tick >= 10) {
                this.tick = 0;
                this.averageEnergy = this.outPut / 10;
                this.outPut = 0;
                if (this.averageEnergy != this.oldEnergy || this.potentialEnergy != this.oldPotential) {
                    this.oldPotential = this.potentialEnergy;
                    this.oldEnergy = this.averageEnergy;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    public abstract int getMaxEnergyToTransport();

    public int onEnergyReceived(int maxReceive, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        if (!this.isMaster()) {
            return ((TileEntityEnergyCable)this.getMaster()).onEnergyReceived(maxReceive, simulate);
        }
        if (this.inUse) {
            return 0;
        }
        this.inUse = true;
        int maxTransfer = Math.min(maxReceive, this.energyContainer.getMaxOutput());
        if (!simulate) {
            this.potentialEnergy = maxTransfer;
        }
        if (maxReceive <= 0) {
            this.inUse = false;
            return 0;
        }
        List<Integer> out = MultiBlockHelper.outputEnergy(this, maxTransfer, this.energyContainer.getMaxOutput(), simulate, this.field_145850_b);
        if (!simulate) {
            this.outPut += out.get(0).intValue();
        }
        this.outPutCount = out.get(1);
        this.inUse = false;
        return out.get(0);
    }

    @Override
    public void checkForOutPuts() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos currentPos = this.field_174879_c.func_177972_a(face);
            TileEntity te = this.field_145850_b.func_175625_s(currentPos);
            boolean hasMachine = te != null && !(te instanceof TileEntityEnergyCable);
            IEnergyStorage eStorage = null;
            if (hasMachine) {
                eStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
            }
            if (!hasMachine || eStorage == null || !eStorage.canReceive()) continue;
            this.addMachine(te, face);
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)((TileEntityEnergyCable)this.getMaster()).energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.averageEnergy = compound.func_74762_e("energy_average");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("energy_average", this.averageEnergy);
        return super.func_189515_b(compound);
    }
}

