/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.util;

import cassiokf.industrialrenewal.config.IRConfig;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    private static final Random RANDOM = new Random();
    private static final DecimalFormat form = new DecimalFormat("0.0");
    private static final DecimalFormat preciseForm = new DecimalFormat("0.00");

    public static void sendChatMessage(EntityPlayer player, String str) {
        if (player == null) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(str);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(str));
        }
    }

    public static void sendConsoleMessage(String str) {
        System.out.println(str);
    }

    public static String blockPosToString(BlockPos pos) {
        return "X: " + pos.func_177958_n() + " Y: " + pos.func_177956_o() + " Z: " + pos.func_177952_p();
    }

    public static boolean isWood(ItemStack stack) {
        int[] array = OreDictionary.getOreIDs((ItemStack)stack);
        int size = array.length;
        ArrayList<Integer> oreList = new ArrayList<Integer>();
        oreList.add(OreDictionary.getOreID((String)"logWood"));
        oreList.add(OreDictionary.getOreID((String)"logRubber"));
        boolean isLog = false;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (!oreList.contains(array[i])) continue;
                isLog = true;
                break;
            }
        }
        return isLog;
    }

    public static boolean IsInventoryEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean IsInventoryFull(IItemHandler handler) {
        int slotsFull = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            ++slotsFull;
        }
        return slotsFull == handler.getSlots();
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, ItemStackHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            Utils.spawnItemStack(worldIn, pos, itemstack);
        }
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            Utils.spawnItemStack(worldIn, pos, itemstack);
        }
    }

    public static void spawnItemStack(World worldIn, BlockPos pos, ItemStack stack) {
        if (worldIn.field_72995_K) {
            return;
        }
        float f = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + (double)f, (double)pos.func_177956_o() + (double)f1, (double)pos.func_177952_p() + (double)f2, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)0.05f;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)0.05f + (double)0.2f;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)0.05f;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static IFluidHandler wrapFluidBlock(Block block, World world, BlockPos pos) {
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, pos);
        }
        return new BlockWrapper(block, world, pos);
    }

    public static float getInvNorm(IItemHandler inventory) {
        float items = 0.0f;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            items += 1.0f;
        }
        return items / (float)inventory.getSlots();
    }

    public static float getConvertedTemperature(float temp) {
        switch (IRConfig.MainConfig.Main.temperatureScale) {
            default: {
                return temp;
            }
            case 1: {
                return (float)((double)temp * 1.8 + 32.0);
            }
            case 2: 
        }
        return (float)((double)temp + 273.15);
    }

    public static String getConvertedTemperatureString(float temp) {
        String st;
        switch (IRConfig.MainConfig.Main.temperatureScale) {
            default: {
                st = " " + I18n.func_135052_a((String)"render.industrialrenewal.c", (Object[])new Object[0]);
                break;
            }
            case 1: {
                st = " " + I18n.func_135052_a((String)"render.industrialrenewal.f", (Object[])new Object[0]);
                break;
            }
            case 2: {
                st = " " + I18n.func_135052_a((String)"render.industrialrenewal.k", (Object[])new Object[0]);
            }
        }
        return (int)Utils.getConvertedTemperature(temp) + st;
    }

    public static String formatEnergyString(int energy) {
        String text = energy + " FE";
        if (energy >= 1000 && energy < 1000000) {
            text = form.format((float)energy / 1000.0f) + "K FE";
        } else if (energy >= 1000000 && energy < 1000000000) {
            text = form.format((float)energy / 1000000.0f) + "M FE";
        } else if (energy >= 1000000000) {
            text = form.format((float)energy / 1.0E9f) + "B FE";
        }
        return text;
    }

    public static String formatPreciseEnergyString(int energy) {
        String text = energy + " FE";
        if (energy >= 1000 && energy < 1000000) {
            text = preciseForm.format((float)energy / 1000.0f) + "K FE";
        } else if (energy >= 1000000 && energy < 1000000000) {
            text = preciseForm.format((float)energy / 1000000.0f) + "M FE";
        } else if (energy >= 1000000000) {
            text = preciseForm.format((float)energy / 1.0E9f) + "B FE";
        }
        return text;
    }

    public static float normalizeClamped(float value, float min, float max) {
        return MathHelper.func_76131_a((float)(value - min), (float)0.0f, (float)(max - min)) / (max - min);
    }

    public static int roundtoInteger(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    public static int getDistancePointToPoint(BlockPos pos1, BlockPos pos2) {
        int deltaX = pos1.func_177958_n() - pos2.func_177958_n();
        int deltaY = pos1.func_177956_o() - pos2.func_177956_o();
        int deltaZ = pos1.func_177952_p() - pos2.func_177952_p();
        return (int)MathHelper.func_76129_c((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
    }

    public static boolean moveItemsBetweenInventories(IItemHandler from, IItemHandler to) {
        return Utils.moveItemsBetweenInventories(from, to, true, Integer.MAX_VALUE);
    }

    public static boolean moveItemsBetweenInventories(IItemHandler from, IItemHandler to, int maxStackCount) {
        return Utils.moveItemsBetweenInventories(from, to, true, maxStackCount);
    }

    private static boolean moveItemsBetweenInventories(IItemHandler from, IItemHandler to, boolean stackPerTick, int maxStackCount) {
        boolean movement = false;
        for (int i = 0; i < from.getSlots(); ++i) {
            boolean needBreak = false;
            ItemStack stack = from.extractItem(i, maxStackCount, true);
            for (int j = 0; j < to.getSlots(); ++j) {
                ItemStack left;
                if (stack.func_190926_b() || !to.isItemValid(j, stack) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(left = to.insertItem(j, stack, false)))) continue;
                int toExtract = stack.func_190916_E() - left.func_190916_E();
                from.extractItem(i, toExtract, false);
                movement = true;
                if (!stackPerTick) continue;
                needBreak = true;
                break;
            }
            if (stackPerTick && needBreak) break;
        }
        return movement;
    }

    public static boolean moveItemToInventory(IItemHandler from, int slot, IItemHandler to) {
        boolean movement = false;
        for (int j = 0; j < to.getSlots(); ++j) {
            ItemStack left;
            ItemStack stack = from.getStackInSlot(slot);
            if (stack.func_190926_b() || !to.isItemValid(j, stack) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(left = to.insertItem(j, stack, false)))) continue;
            int toExtract = stack.func_190916_E() - left.func_190916_E();
            from.extractItem(slot, toExtract, false);
            movement = true;
        }
        return movement;
    }
}

