/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.ZUtils;

public class ItemSatellite
extends ItemIdWithName {
    public EmbeddedInventory readInvFromNBT(@Nonnull ItemStack stackIn) {
        EmbeddedInventory inv = new EmbeddedInventory(7);
        if (!stackIn.func_77942_o() || !stackIn.func_77978_p().func_74764_b("inv")) {
            return inv;
        }
        inv.readFromNBT(stackIn.func_77978_p().func_74775_l("inv"));
        return inv;
    }

    public void writeInvToNBT(@Nonnull ItemStack stackIn, EmbeddedInventory inv) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (!stackIn.func_77942_o()) {
            stackIn.func_77982_d(nbt);
        } else {
            nbt = stackIn.func_77978_p();
        }
        NBTTagCompound tag = new NBTTagCompound();
        inv.writeToNBT(tag);
        nbt.func_74782_a("inv", (NBTBase)tag);
    }

    public void setSatellite(@Nonnull ItemStack stack, SatelliteProperties properties) {
        SatelliteBase testSatellite = SatelliteRegistry.getNewSatellite(properties.getSatelliteType());
        if (testSatellite != null) {
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            properties.writeToNBT(nbt);
            stack.func_77982_d(nbt);
            this.setName(stack, testSatellite.getName());
        } else {
            stack.func_77982_d(null);
        }
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag bool) {
        if (stack.func_77973_b() instanceof ItemSatellite && SatelliteRegistry.getSatelliteProperties(stack) != null) {
            SatelliteProperties properties = SatelliteRegistry.getSatelliteProperties(stack);
            list.add(this.getName(stack));
            list.add("ID: " + properties.getId());
            if (SatelliteProperties.Property.BATTERY.isOfType(properties.getPropertyFlag())) {
                int powerStorage = properties.getPowerStorage();
                if (powerStorage > 0) {
                    list.add(LibVulpes.proxy.getLocalizedString("msg.itemsatellite.pwr") + powerStorage);
                } else {
                    list.add(ChatFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.nopwr"));
                }
            }
            if (SatelliteProperties.Property.POWER_GEN.isOfType(properties.getPropertyFlag())) {
                int powerGeneration = properties.getPowerGeneration();
                if (powerGeneration > 0) {
                    list.add(LibVulpes.proxy.getLocalizedString("msg.itemsatellite.pwrgen") + powerGeneration);
                } else {
                    list.add(ChatFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.nopwrgen"));
                }
            }
            if (SatelliteProperties.Property.DATA.isOfType(properties.getPropertyFlag())) {
                int dataStorage = properties.getMaxDataStorage();
                if (dataStorage > 0) {
                    list.add(LibVulpes.proxy.getLocalizedString("msg.itemsatellite.data") + ZUtils.formatNumber((int)dataStorage));
                } else {
                    list.add(ChatFormatting.YELLOW + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.nodata"));
                }
            }
        } else {
            list.add(ChatFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.empty"));
        }
    }
}

