/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.util.ZUtils;

public class TileWarpCore
extends TileMultiBlock {
    private SpaceStationObject station;
    public static final Object[][][] structure = new Object[][][]{{{"blockWarpCoreRim", "blockWarpCoreRim", "blockWarpCoreRim"}, {"blockWarpCoreRim", Character.valueOf('I'), "blockWarpCoreRim"}, {"blockWarpCoreRim", "blockWarpCoreRim", "blockWarpCoreRim"}}, {{null, new BlockMeta(LibVulpesBlocks.blockStructureBlock), null}, {new BlockMeta(LibVulpesBlocks.blockStructureBlock), "blockWarpCoreCore", new BlockMeta(LibVulpesBlocks.blockStructureBlock)}, {null, new BlockMeta(LibVulpesBlocks.blockStructureBlock), null}}, {{"blockWarpCoreRim", Character.valueOf('c'), "blockWarpCoreRim"}, {"blockWarpCoreRim", "blockWarpCoreCore", "blockWarpCoreRim"}, {"blockWarpCoreRim", "blockWarpCoreRim", "blockWarpCoreRim"}}};

    private SpaceStationObject getSpaceObject() {
        ISpaceObject spaceObject;
        if (this.station == null && this.field_145850_b.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceStationObject) {
            this.station = (SpaceStationObject)spaceObject;
        }
        return this.station;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return pos.compareTo((Vec3i)this.field_174879_c) == 0;
    }

    public void onInventoryUpdated() {
        if (this.itemInPorts.isEmpty()) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        if (this.getSpaceObject() == null || this.getSpaceObject().getMaxFuelAmount() - this.getSpaceObject().getFuelAmount() < ARConfiguration.getCurrentConfig().fuelPointsPerDilithium) {
            return;
        }
        for (IInventory inv : this.itemInPorts) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i).func_77946_l();
                stack.func_190920_e(1);
                int amt = 0;
                if (stack.func_190926_b() || !ZUtils.isItemInOreDict((ItemStack)stack, (String)"gemDilithium")) continue;
                if (!this.field_145850_b.field_72995_K) {
                    amt = this.getSpaceObject().addFuel(ARConfiguration.getCurrentConfig().fuelPointsPerDilithium);
                }
                inv.func_70298_a(i, amt / ARConfiguration.getCurrentConfig().fuelPointsPerDilithium);
                inv.func_70296_d();
                if (this.getSpaceObject().getMaxFuelAmount() - this.getSpaceObject().getFuelAmount() >= ARConfiguration.getCurrentConfig().fuelPointsPerDilithium) continue;
                return;
            }
        }
    }

    public String getMachineName() {
        return AdvancedRocketryBlocks.blockWarpCore.func_149732_F();
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }
}

