/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.misc;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.utility.ChunkBlockAccess;

public class CubeTools {
    public static int getCubeSize(IBlockAccess world, int coord) {
        BlockPos base;
        int yOffset = 40;
        if (world instanceof ChunkBlockAccess) {
            yOffset = 0;
        }
        if (world.func_180495_p((base = new BlockPos(coord * 1024, yOffset, 0)).func_177982_a(14, 0, 0)).func_177230_c() == Blockss.wall) {
            return 5;
        }
        if (world.func_180495_p(base.func_177982_a(12, 0, 0)).func_177230_c() == Blockss.wall) {
            return 4;
        }
        if (world.func_180495_p(base.func_177982_a(10, 0, 0)).func_177230_c() == Blockss.wall) {
            return 3;
        }
        if (world.func_180495_p(base.func_177982_a(8, 0, 0)).func_177230_c() == Blockss.wall) {
            return 2;
        }
        if (world.func_180495_p(base.func_177982_a(6, 0, 0)).func_177230_c() == Blockss.wall) {
            return 1;
        }
        return 0;
    }

    public static boolean shouldSideBeRendered(IBlockAccess world, BlockPos pos, EnumFacing side) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int yOffset = 40;
        if (world instanceof ChunkBlockAccess) {
            yOffset = 0;
        }
        int coord = x / 1024;
        int size = EnumMachineSize.getFromMeta(CubeTools.getCubeSize(world, coord)).getDimension();
        int relativeX = x - coord * 1024;
        if (y == yOffset && relativeX > 0 && relativeX < size && z < size && z > 0 && side == EnumFacing.UP) {
            return true;
        }
        if (y == yOffset + size && relativeX > 0 && relativeX < size && z < size && z > 0 && side == EnumFacing.DOWN) {
            return true;
        }
        if (y > yOffset && y < yOffset + size) {
            if (side == EnumFacing.EAST && relativeX == 0 && z < size && z > 0) {
                return true;
            }
            if (side == EnumFacing.WEST && relativeX == size && z < size && z > 0) {
                return true;
            }
            if (side == EnumFacing.NORTH && z == size && relativeX < size && relativeX > 0) {
                return true;
            }
            if (side == EnumFacing.SOUTH && z == 0 && relativeX < size && relativeX > 0) {
                return true;
            }
        }
        return false;
    }
}

