/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util.mst;

import greymerk.roguelike.util.graph.Edge;
import greymerk.roguelike.util.graph.Graph;
import greymerk.roguelike.util.mst.MSTPoint;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class MinimumSpanningTree {
    List<MSTPoint> points = new ArrayList<MSTPoint>();
    Set<Edge<MSTPoint>> mstEdges = new HashSet<Edge<MSTPoint>>();

    public MinimumSpanningTree(Random rand, int size, int edgeLength) {
        this(rand, size, edgeLength, new Coord(0, 0, 0));
    }

    public MinimumSpanningTree(Random rand, int size, int edgeLength, Coord origin) {
        int offset = size / 2 * edgeLength;
        for (int i = 0; i < size; ++i) {
            Coord temp = new Coord(origin);
            temp.add(Cardinal.NORTH, offset);
            temp.add(Cardinal.WEST, offset);
            temp.add(Cardinal.SOUTH, edgeLength * i);
            for (int j = 0; j < size; ++j) {
                this.points.add(new MSTPoint(new Coord(temp), rand));
                temp.add(Cardinal.EAST, edgeLength);
            }
        }
        ArrayList<Edge<MSTPoint>> edges = new ArrayList<Edge<MSTPoint>>();
        for (MSTPoint mSTPoint : this.points) {
            for (MSTPoint o : this.points) {
                if (mSTPoint.equals(o)) continue;
                edges.add(new Edge<MSTPoint>(mSTPoint, o, mSTPoint.distance(o)));
            }
        }
        Collections.sort(edges);
        for (Edge edge : edges) {
            MSTPoint start = (MSTPoint)edge.getStart();
            MSTPoint end = (MSTPoint)edge.getEnd();
            if (this.find(start) == this.find(end)) continue;
            this.union(start, end);
            this.mstEdges.add(edge);
        }
    }

    private void union(MSTPoint a, MSTPoint b) {
        MSTPoint root2;
        MSTPoint root1 = this.find(a);
        if (root1 == (root2 = this.find(b))) {
            return;
        }
        if (root1.getRank() > root2.getRank()) {
            root2.setParent(root1);
        } else {
            root1.setParent(root2);
            if (root1.getRank() == root2.getRank()) {
                root2.incRank();
            }
        }
    }

    private MSTPoint find(MSTPoint p) {
        if (p.getParent() == p) {
            return p;
        }
        p.setParent(this.find(p.getParent()));
        return p.getParent();
    }

    public void generate(IWorldEditor editor, Random rand, IBlockFactory blocks, Coord pos) {
        for (Edge<MSTPoint> e : this.mstEdges) {
            Coord start = e.getStart().getPosition();
            start.add(pos);
            Coord end = e.getEnd().getPosition();
            end.add(pos);
            RectHollow.fill(editor, rand, start, end, blocks);
        }
    }

    public List<Edge<MSTPoint>> getEdges() {
        ArrayList<Edge<MSTPoint>> toReturn = new ArrayList<Edge<MSTPoint>>();
        toReturn.addAll(this.mstEdges);
        return toReturn;
    }

    public Graph<Coord> getGraph() {
        Graph<Coord> layout = new Graph<Coord>();
        for (Edge<MSTPoint> e : this.mstEdges) {
            Coord start = e.getStart().getPosition();
            Coord end = e.getEnd().getPosition();
            layout.addEdge(new Edge<Coord>(start, end, start.distance(end)));
        }
        return layout;
    }
}

