/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import wile.rsgauges.blocks.BlockGauge;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockIndicator
extends BlockGauge {
    public static final PropertyBool POWER = PropertyBool.func_177716_a((String)"power");

    public BlockIndicator(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(registryName, unrotatedBB, config, powerOnSound, powerOffSound);
    }

    public BlockIndicator(String registryName, AxisAlignedBB unrotatedBB, long config) {
        super(registryName, unrotatedBB, config, null, null);
    }

    public BlockIndicator(String registryName, AxisAlignedBB unrotatedBB) {
        super(registryName, unrotatedBB, 0L, null, null);
    }

    @Override
    public IBlockState getBlockStateWithPower(IBlockState orig, int power) {
        return orig.func_177226_a((IProperty)POWER, (Comparable)Boolean.valueOf(power > 0));
    }

    @Override
    public int getBlockStatePower(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWER) != false ? 15 : 0;
    }

    @Override
    public boolean cmpBlockStatePower(IBlockState state, int power) {
        return (Boolean)state.func_177229_b((IProperty)POWER) == (power != 0);
    }

    @Override
    public int getColorMultiplierRGBA(@Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        if (pos == null || world == null) {
            return -1;
        }
        BlockGauge.TileEntityGauge te = this.getTe(world, pos);
        if (te == null) {
            return -1;
        }
        return ModAuxiliaries.DyeColorFilters.byIndex(te.color_tint());
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWER});
    }
}

