/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.DipoleMagnet;
import lach_01298.qmd.accelerator.QuadrupoleMagnet;
import lach_01298.qmd.accelerator.RFCavity;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorCooler;
import lach_01298.qmd.accelerator.tile.TileAcceleratorEnergyPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRedstonePort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorVent;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.block.property.BlockProperties;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import nc.util.MaterialHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class AcceleratorLogic
extends MultiblockLogic<Accelerator, AcceleratorLogic, IAcceleratorPart, AcceleratorUpdatePacket> {
    public boolean searchFlag = false;
    public final ObjectSet<TileAcceleratorCooler> coolerCache = new ObjectOpenHashSet();
    public final Long2ObjectMap<TileAcceleratorCooler> componentFailCache = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<TileAcceleratorCooler> assumedValidCache = new Long2ObjectOpenHashMap();
    public static final int thickness = 5;
    private boolean operational = false;
    private int excessCoolant = 0;

    public AcceleratorLogic(Accelerator accelerator) {
        super((Multiblock)accelerator);
    }

    public AcceleratorLogic(AcceleratorLogic oldLogic) {
        super((MultiblockLogic)oldLogic);
    }

    public String getID() {
        return "";
    }

    public Accelerator getAccelerator() {
        return (Accelerator)this.multiblock;
    }

    public void onResetStats() {
    }

    public int getMinimumInteriorLength() {
        return 3;
    }

    public int getMaximumInteriorLength() {
        return QMDConfig.accelerator_linear_max_size;
    }

    public void onMachineAssembled() {
        this.onAcceleratorFormed();
    }

    public void onMachineRestored() {
        this.onAcceleratorFormed();
    }

    public int getBeamLength() {
        return 0;
    }

    public double getBeamRadius() {
        return 0.0;
    }

    public void onAcceleratorFormed() {
        ObjectIterator objectIterator = this.getPartMap(IAcceleratorController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IAcceleratorController contr;
            this.getAccelerator().controller = contr = (IAcceleratorController)objectIterator.next();
        }
        this.getAccelerator().energyStorage.setStorageCapacity((long)(QMDConfig.accelerator_base_energy_capacity * this.getCapacityMultiplier()));
        this.getAccelerator().energyStorage.setMaxTransfer(QMDConfig.accelerator_base_energy_capacity * this.getCapacityMultiplier());
        this.getAccelerator().heatBuffer.setHeatCapacity((long)(QMDConfig.accelerator_base_heat_capacity * this.getCapacityMultiplier()));
        this.getAccelerator().ambientTemp = 273 + (int)(this.getWorld().func_180494_b(this.getAccelerator().getMiddleCoord()).func_180626_a(this.getAccelerator().getMiddleCoord()) * 20.0f);
        this.getAccelerator().tanks.get(0).setCapacity(QMDConfig.accelerator_base_input_tank_capacity * this.getCapacityMultiplier());
        this.getAccelerator().tanks.get(1).setCapacity(QMDConfig.accelerator_base_output_tank_capacity * this.getCapacityMultiplier());
        if (!this.getWorld().field_72995_K) {
            if (!this.getAccelerator().cold) {
                HeatBuffer heatBuffer = this.getAccelerator().heatBuffer;
                long l = (long)this.getAccelerator().ambientTemp * this.getAccelerator().heatBuffer.getHeatCapacity();
                this.getAccelerator();
                heatBuffer.setHeatStored(l / 400L);
            }
            this.getAccelerator().cold = true;
            this.getAccelerator().currentHeating = 0L;
            this.getAccelerator().updateActivity();
            for (ParticleStorageAccelerator beam : this.getAccelerator().beams) {
                beam.setMaxEnergy(Long.MAX_VALUE);
            }
            this.getAccelerator().cooling = 0L;
            Accelerator accelerator = this.getAccelerator();
            this.getAccelerator();
            accelerator.maxOperatingTemp = 400;
            this.componentFailCache.clear();
            do {
                this.assumedValidCache.clear();
                this.refreshCoolers();
            } while (this.searchFlag);
            for (IAcceleratorComponent part : this.getAccelerator().getPartMap(IAcceleratorComponent.class).values()) {
                if (part instanceof TileAcceleratorCooler) {
                    TileAcceleratorCooler cooler = (TileAcceleratorCooler)part;
                    if (!part.isFunctional()) continue;
                    this.getAccelerator().cooling += (long)cooler.coolingRate;
                    continue;
                }
                if (!(part instanceof TileAcceleratorMagnet) && !(part instanceof TileAcceleratorRFCavity) || part.getMaxOperatingTemp() >= this.getAccelerator().maxOperatingTemp) continue;
                this.getAccelerator().maxOperatingTemp = part.getMaxOperatingTemp();
            }
        }
    }

    private void refreshCoolers() {
        this.searchFlag = false;
        if (this.getPartMap(TileAcceleratorCooler.class).isEmpty()) {
            return;
        }
        for (TileAcceleratorCooler cooler : this.getParts(TileAcceleratorCooler.class)) {
            cooler.isInValidPosition = false;
            cooler.isSearched = false;
        }
        this.coolerCache.clear();
        for (TileAcceleratorCooler cooler : this.getParts(TileAcceleratorCooler.class)) {
            if (!cooler.isSearchRoot()) continue;
            this.iterateCoolerSearch(cooler, this.coolerCache);
        }
        for (TileAcceleratorCooler cooler : this.assumedValidCache.values()) {
            if (cooler.isInValidPosition) continue;
            this.componentFailCache.put(cooler.func_174877_v().func_177986_g(), (Object)cooler);
            this.searchFlag = true;
        }
    }

    private void iterateCoolerSearch(TileAcceleratorCooler rootCooler, ObjectSet<TileAcceleratorCooler> coolerCache) {
        ObjectOpenHashSet searchCache = new ObjectOpenHashSet();
        rootCooler.coolerSearch(coolerCache, (ObjectSet<TileAcceleratorCooler>)searchCache, this.componentFailCache, this.assumedValidCache);
        do {
            ObjectIterator searchIterator = searchCache.iterator();
            ObjectOpenHashSet searchSubCache = new ObjectOpenHashSet();
            while (searchIterator.hasNext()) {
                TileAcceleratorCooler component = (TileAcceleratorCooler)searchIterator.next();
                searchIterator.remove();
                component.coolerSearch(coolerCache, (ObjectSet<TileAcceleratorCooler>)searchSubCache, this.componentFailCache, this.assumedValidCache);
            }
            searchCache.addAll((Collection)searchSubCache);
        } while (!searchCache.isEmpty());
    }

    public int getCapacityMultiplier() {
        return this.getAccelerator().getInteriorVolume();
    }

    public void onMachinePaused() {
        this.onAcceleratorBroken();
    }

    public void onMachineDisassembled() {
        Accelerator acc = this.getAccelerator();
        for (RFCavity cavity : acc.getRFCavityMap().values()) {
            for (IAcceleratorComponent componet : cavity.getComponents().values()) {
                componet.setFunctional(false);
            }
        }
        for (QuadrupoleMagnet quad : acc.getQuadrupoleMap().values()) {
            for (IAcceleratorComponent componet : quad.getComponents().values()) {
                componet.setFunctional(false);
            }
        }
        for (DipoleMagnet dipole : acc.dipoleMap.values()) {
            for (IAcceleratorComponent componet : dipole.getComponents().values()) {
                componet.setFunctional(false);
            }
        }
        acc.getRFCavityMap().clear();
        acc.getQuadrupoleMap().clear();
        acc.dipoleMap.clear();
        for (TileAcceleratorBeam beam : acc.getPartMap(TileAcceleratorBeam.class).values()) {
            beam.setFunctional(false);
        }
        for (TileAcceleratorCooler cooler : acc.getPartMap(TileAcceleratorCooler.class).values()) {
            cooler.setFunctional(false);
        }
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            port.setRedstoneLevel(0);
        }
        this.operational = false;
        this.onAcceleratorBroken();
    }

    public void onAcceleratorBroken() {
        if (!this.getWorld().field_72995_K) {
            this.getAccelerator().updateActivity();
        }
    }

    public boolean isMachineWhole() {
        boolean inlet = false;
        boolean outlet = false;
        for (TileAcceleratorVent vent : this.getPartMap(TileAcceleratorVent.class).values()) {
            if (!((Boolean)vent.getBlockState(vent.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                inlet = true;
                continue;
            }
            outlet = true;
        }
        if (!inlet) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.no_inlet", null, new Object[0]);
            return false;
        }
        if (!outlet) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.no_outlet", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileAcceleratorEnergyPort.class).size() < 1) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return true;
    }

    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends IAcceleratorPart>, String>>();
    }

    public void onAssimilate(Multiblock assimilated) {
        if (assimilated instanceof Accelerator) {
            Accelerator assimilatedAccelerator = (Accelerator)assimilated;
            this.getAccelerator().heatBuffer.mergeHeatBuffers(assimilatedAccelerator.heatBuffer);
            this.getAccelerator().energyStorage.mergeEnergyStorage(assimilatedAccelerator.energyStorage);
        }
        if (this.getAccelerator().isAssembled()) {
            this.onAcceleratorFormed();
        } else {
            this.onAcceleratorBroken();
        }
    }

    public void onAssimilated(Multiblock assimilator) {
    }

    public void refreshStats() {
        TileAcceleratorMagnet magnet;
        int energy = 0;
        long heat = 0L;
        int parts = 0;
        double efficiency = 0.0;
        double quadStrength = 0.0;
        double dipoleStrength = 0.0;
        int voltage = 0;
        block0: for (DipoleMagnet dipole : this.getAccelerator().dipoleMap.values()) {
            for (IAcceleratorComponent componet : dipole.getComponents().values()) {
                if (!(componet instanceof TileAcceleratorMagnet)) continue;
                magnet = (TileAcceleratorMagnet)componet;
                dipoleStrength += magnet.strength;
                heat += (long)magnet.heat;
                energy += magnet.basePower;
                ++parts;
                efficiency += magnet.efficiency;
                continue block0;
            }
        }
        block2: for (QuadrupoleMagnet quad : this.getAccelerator().getQuadrupoleMap().values()) {
            for (IAcceleratorComponent componet : quad.getComponents().values()) {
                if (!(componet instanceof TileAcceleratorMagnet)) continue;
                magnet = (TileAcceleratorMagnet)componet;
                quadStrength += magnet.strength;
                heat += (long)magnet.heat;
                energy += magnet.basePower;
                ++parts;
                efficiency += magnet.efficiency;
                continue block2;
            }
        }
        block4: for (RFCavity cavity : this.getAccelerator().getRFCavityMap().values()) {
            for (IAcceleratorComponent componet : cavity.getComponents().values()) {
                if (!(componet instanceof TileAcceleratorRFCavity)) continue;
                TileAcceleratorRFCavity cav = (TileAcceleratorRFCavity)componet;
                voltage += cav.voltage;
                heat += (long)cav.heat;
                energy += cav.basePower;
                ++parts;
                efficiency += cav.efficiency;
                continue block4;
            }
        }
        this.getAccelerator().requiredEnergy = (int)((double)energy / (efficiency /= (double)parts));
        this.getAccelerator().rawHeating = heat;
        this.getAccelerator().dipoleStrength = dipoleStrength;
        this.getAccelerator().quadrupoleStrength = quadStrength;
        this.getAccelerator().efficiency = efficiency;
        this.getAccelerator().acceleratingVoltage = voltage;
    }

    public boolean onUpdateServer() {
        this.getAccelerator().currentHeating = 0L;
        if (this.isRedstonePowered() && !this.getAccelerator().computerControlled || this.getAccelerator().computerControlled && this.getAccelerator().energyPercentage > 0) {
            if (this.getAccelerator().energyStorage.extractEnergy(this.getAccelerator().requiredEnergy, true) == this.getAccelerator().requiredEnergy) {
                this.getAccelerator().energyStorage.changeEnergyStored((long)(-this.getAccelerator().requiredEnergy));
                this.internalHeating();
                if (this.getAccelerator().getTemperature() <= this.getAccelerator().maxOperatingTemp) {
                    this.operational = true;
                } else {
                    if (this.operational) {
                        this.quenchMagnets();
                    }
                    this.operational = false;
                    this.getAccelerator().errorCode = 1;
                }
            } else {
                this.operational = false;
                this.getAccelerator().errorCode = 2;
            }
        } else {
            this.operational = false;
        }
        this.externalHeating();
        this.refreshFluidRecipe();
        if (this.canProcessFluidInputs()) {
            this.produceFluidProducts();
        }
        this.updateRedstone();
        this.getAccelerator().sendUpdateToListeningPlayers();
        return true;
    }

    protected void refreshFluidRecipe() {
        this.getAccelerator().coolingRecipeInfo = QMDRecipes.accelerator_cooling.getRecipeInfoFromInputs(new ArrayList(), this.getAccelerator().tanks.subList(0, 1));
        if (this.getAccelerator().coolingRecipeInfo != null) {
            this.getAccelerator().maxCoolantIn = 1000 / ((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (int)(this.getAccelerator().cooling * (long)((IFluidIngredient)((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getMaxStackSize(0));
            this.getAccelerator().maxCoolantOut = 1000 / ((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (int)(this.getAccelerator().cooling * (long)((IFluidIngredient)((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0)).getMaxStackSize(0));
        }
    }

    protected boolean canProcessFluidInputs() {
        if (this.getAccelerator().coolingRecipeInfo == null) {
            return false;
        }
        if (this.getAccelerator().getTemperature() <= ((FluidStack)((IFluidIngredient)((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getStack()).getFluid().getTemperature()) {
            return false;
        }
        IFluidIngredient fluidProduct = (IFluidIngredient)((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        if (fluidProduct.getMaxStackSize(0) <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        if (!this.getAccelerator().tanks.get(1).isEmpty()) {
            if (!this.getAccelerator().tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getAccelerator().tanks.get(1).getFluidAmount() + (this.getAccelerator().maxCoolantIn / 1000 + 1) * fluidProduct.getNextStack((int)0).amount > this.getAccelerator().tanks.get(1).getCapacity()) {
                return false;
            }
            if (this.getAccelerator().heatBuffer.getHeatStored() < 1L) {
                return false;
            }
        }
        return true;
    }

    private void produceFluidProducts() {
        int uBConsumed = this.getAccelerator().maxCoolantIn;
        if (uBConsumed > this.getAccelerator().tanks.get(0).getFluidAmount() * 1000) {
            uBConsumed = this.getAccelerator().tanks.get(0).getFluidAmount() * 1000;
        }
        if ((long)uBConsumed > this.getAccelerator().heatBuffer.getHeatStored()) {
            uBConsumed = (int)this.getAccelerator().heatBuffer.getHeatStored();
        }
        int mBConsumed = 0;
        if (uBConsumed % 1000 != 0) {
            mBConsumed = (uBConsumed + (1000 - uBConsumed % 1000)) / 1000;
            this.excessCoolant += 1000 - uBConsumed % 1000;
        } else {
            mBConsumed = uBConsumed / 1000;
        }
        if (this.excessCoolant > 1000) {
            mBConsumed -= this.excessCoolant / 1000;
            this.excessCoolant %= 1000;
        }
        this.getAccelerator().tanks.get(0).changeFluidAmount(-mBConsumed);
        if (this.getAccelerator().tanks.get(0).getFluidAmount() <= 0) {
            this.getAccelerator().tanks.get(0).setFluidStored(null);
        }
        this.getAccelerator().heatBuffer.changeHeatStored((long)(-mBConsumed * ((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB()));
        IFluidIngredient fluidProduct = (IFluidIngredient)((BasicRecipe)this.getAccelerator().coolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        int producedCoolant = mBConsumed * fluidProduct.getNextStack((int)0).amount;
        if (this.getAccelerator().tanks.get(1).isEmpty()) {
            this.getAccelerator().tanks.get(1).changeFluidStored(fluidProduct.getNextStack(0).getFluid(), producedCoolant);
        } else {
            this.getAccelerator().tanks.get(1).changeFluidAmount(producedCoolant);
        }
    }

    private void externalHeating() {
        this.getAccelerator().heatBuffer.addHeat(this.getAccelerator().getExternalHeating(), false);
        this.getAccelerator().currentHeating += this.getAccelerator().getExternalHeating();
    }

    private void internalHeating() {
        this.getAccelerator().heatBuffer.addHeat(this.getAccelerator().rawHeating, false);
        this.getAccelerator().currentHeating += this.getAccelerator().rawHeating;
    }

    public boolean isAcceleratorOn() {
        return this.operational;
    }

    protected boolean isRedstonePowered() {
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || !port.checkIsRedstonePowered(this.getWorld(), port.func_174877_v())) continue;
            return true;
        }
        return this.getAccelerator().controller != null && this.getAccelerator().controller.checkIsRedstonePowered(this.getWorld(), this.getAccelerator().controller.getTilePos());
    }

    protected int getRedstoneLevel() {
        int level = this.getWorld().func_175687_A(this.getAccelerator().controller.getTilePos());
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            if (((Boolean)this.getWorld().func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue() || this.getWorld().func_175687_A(port.func_174877_v()) <= level) continue;
            level = this.getWorld().func_175687_A(port.func_174877_v());
        }
        return level;
    }

    protected void updateRedstone() {
        for (TileAcceleratorRedstonePort port : this.getPartMap(TileAcceleratorRedstonePort.class).values()) {
            if (!((Boolean)this.getAccelerator().WORLD.func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) continue;
            port.setRedstoneLevel((int)(15.0 * ((double)this.getAccelerator().getTemperature() / (double)this.getAccelerator().maxOperatingTemp)));
        }
    }

    public void quenchMagnets() {
        ArrayList<BlockPos> components = new ArrayList<BlockPos>();
        for (TileAcceleratorMagnet magnet : this.getPartMap(TileAcceleratorMagnet.class).values()) {
            if (!magnet.isToHot()) continue;
            components.add(magnet.func_174877_v());
        }
        for (TileAcceleratorRFCavity cavity : this.getPartMap(TileAcceleratorRFCavity.class).values()) {
            if (!cavity.isToHot()) continue;
            components.add(cavity.func_174877_v());
        }
        if (!components.isEmpty()) {
            int explosions = 1 + this.rand.nextInt(1 + components.size() / 10);
            for (int i = 0; i < explosions; ++i) {
                int j = this.rand.nextInt(components.size());
                BlockPos component = (BlockPos)components.get(j);
                ((Accelerator)this.multiblock).WORLD.func_72876_a(null, (double)component.func_177958_n(), (double)component.func_177956_o(), (double)component.func_177952_p(), 6.0f, true);
                components.remove(j);
            }
        }
    }

    public void onUpdateClient() {
    }

    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        logicTag.func_74768_a("excessCoolant", this.excessCoolant);
    }

    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        this.excessCoolant = logicTag.func_74762_e("excessCoolant");
    }

    public AcceleratorUpdatePacket getUpdatePacket() {
        return null;
    }

    public void onPacket(AcceleratorUpdatePacket message) {
    }

    public ContainerMultiblockController<Accelerator, IAcceleratorController> getContainer(EntityPlayer player) {
        return null;
    }

    public void clearAllMaterial() {
        for (Tank tank : this.getAccelerator().tanks) {
            tank.setFluidStored(null);
        }
    }

    public boolean isBlockGoodForInterior(World world, BlockPos pos) {
        if (MaterialHelper.isReplaceable((Material)world.func_180495_p(pos).func_185904_a()) || world.func_175625_s(pos) instanceof TileAcceleratorPart) {
            return true;
        }
        return this.getAccelerator().standardLastError(pos);
    }

    protected void push() {
        TileEntity tile;
        if (this.getAccelerator().output != null && this.getAccelerator().output.getExternalFacing() != null && (tile = this.getAccelerator().WORLD.func_175625_s(this.getAccelerator().output.func_174877_v().func_177972_a(this.getAccelerator().output.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getAccelerator().output.getExternalFacing().func_176734_d())) {
            IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getAccelerator().output.getExternalFacing().func_176734_d());
            otherStorage.reciveParticle(this.getAccelerator().output.getExternalFacing().func_176734_d(), this.getAccelerator().beams.get(1).getParticleStack());
        }
    }

    protected void pull() {
        TileEntity tile;
        if (this.getAccelerator().input != null && this.getAccelerator().input.getExternalFacing() != null && (tile = this.getAccelerator().WORLD.func_175625_s(this.getAccelerator().input.func_174877_v().func_177972_a(this.getAccelerator().input.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getAccelerator().input.getExternalFacing().func_176734_d())) {
            IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getAccelerator().input.getExternalFacing().func_176734_d());
            ParticleStack stack = otherStorage.extractParticle(this.getAccelerator().input.getExternalFacing().func_176734_d());
            if (!this.getAccelerator().beams.get(0).reciveParticle(this.getAccelerator().input.getExternalFacing(), stack)) {
                this.getAccelerator().errorCode = stack.getMeanEnergy() > this.getAccelerator().beams.get(0).getMaxEnergy() ? 5 : 4;
            }
        }
    }

    @Nonnull
    public List<Tank> getVentTanks(List<Tank> backupTanks) {
        return this.getAccelerator().isAssembled() ? this.getAccelerator().tanks : backupTanks;
    }
}

