/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import com.google.common.collect.Lists;
import java.util.List;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.DipoleMagnet;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.IAcceleratorController;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSource;
import lach_01298.qmd.accelerator.tile.TileAcceleratorSynchrotronPort;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.container.ContainerBeamSplitterController;
import lach_01298.qmd.multiblock.network.AcceleratorUpdatePacket;
import lach_01298.qmd.multiblock.network.BeamSplitterUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Equations;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.tile.TileBeefAbstract;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.tuple.Pair;

public class BeamSplitterLogic
extends AcceleratorLogic {
    public static final List<Pair<Class<? extends IAcceleratorPart>, String>> PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileAcceleratorSynchrotronPort.class, (Object)"qmd.multiblock_validation.accelerator.no_synch_ports"), Pair.of(TileAcceleratorRFCavity.class, (Object)"qmd.multiblock_validation.accelerator.no_rf_cavity"), Pair.of(TileAcceleratorSource.class, (Object)"qmd.multiblock_validation.accelerator.no_source")});

    public BeamSplitterLogic(AcceleratorLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "beam_splitter";
    }

    @Override
    public boolean isMachineWhole() {
        Accelerator acc = this.getAccelerator();
        if (acc.getExteriorLengthX() != 5 || acc.getExteriorLengthY() != 5 || acc.getExteriorLengthZ() != 5) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.beam_director.must_be_cube", null, new Object[0]);
            return false;
        }
        if (!(acc.WORLD.func_175625_s(acc.getMiddleCoord()) instanceof TileAcceleratorBeam)) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.beam_director.must_be_beam", acc.getMiddleCoord(), new Object[0]);
            return false;
        }
        if (!acc.isValidDipole(acc.getMiddleCoord(), false) && !acc.isValidDipole(acc.getMiddleCoord(), true)) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.beam_director.must_be_dipole", acc.getMiddleCoord(), new Object[0]);
            return false;
        }
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            boolean valid = false;
            if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177981_b(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177979_c(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177964_d(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177970_e(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177965_g(2).func_177986_g()) {
                valid = true;
            } else if (port.func_174877_v().func_177986_g() == acc.getMiddleCoord().func_177985_f(2).func_177986_g()) {
                valid = true;
            }
            if (valid) continue;
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.invalid_beam_port", port.func_174877_v(), new Object[0]);
            return false;
        }
        int inputs = 0;
        int outputs = 0;
        for (TileAcceleratorBeamPort port : this.getPartMap(TileAcceleratorBeamPort.class).values()) {
            port.recalculateExternalDirection(acc.getMinimumCoord(), acc.getMaximumCoord());
            if (port.getExternalFacing() == null) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.something_is_wrong", port.func_174877_v(), new Object[0]);
                return false;
            }
            if (!(acc.WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing().func_176734_d())) instanceof TileAcceleratorBeam)) {
                ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.ring.beam_port_must_connect", port.func_174877_v().func_177972_a(port.getExternalFacing().func_176734_d()), new Object[0]);
                return false;
            }
            if (port.getIOType() == EnumTypes.IOType.INPUT) {
                ++inputs;
            }
            if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
            ++outputs;
        }
        if (inputs != 1 || outputs != 2) {
            ((Accelerator)this.multiblock).setLastError("qmd.multiblock_validation.accelerator.splitter.must_have_io", null, new Object[0]);
            return false;
        }
        if (this.containsBlacklistedPart()) {
            return false;
        }
        return super.isMachineWhole();
    }

    @Override
    public void onAcceleratorFormed() {
        Accelerator acc = this.getAccelerator();
        if (!this.getWorld().field_72995_K) {
            acc.beams.get(0).setMinEnergy(0L);
            for (TileAcceleratorBeamPort port : acc.getPartMap(TileAcceleratorBeamPort.class).values()) {
                if (port.getIOType() == EnumTypes.IOType.INPUT) {
                    acc.input = port;
                }
                if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                acc.output = port;
            }
            if (acc.isValidDipole(acc.getMiddleCoord(), false) || acc.isValidDipole(acc.getMiddleCoord(), true)) {
                acc.getDipoleMap().put(acc.getMiddleCoord().func_177986_g(), (Object)new DipoleMagnet(acc, acc.getMiddleCoord()));
            }
            for (DipoleMagnet dipole : acc.getDipoleMap().values()) {
                for (IAcceleratorComponent componet : dipole.getComponents().values()) {
                    componet.setFunctional(true);
                }
            }
        }
        this.refreshStats();
        super.onAcceleratorFormed();
        acc.cooling = 2L * (acc.rawHeating + acc.getMaxExternalHeating());
    }

    @Override
    public void onMachineDisassembled() {
        super.onMachineDisassembled();
    }

    @Override
    public boolean onUpdateServer() {
        this.getAccelerator().errorCode = 0;
        this.getAccelerator().beams.get(0).setParticleStack(null);
        this.pull();
        if (this.getAccelerator().isAcceleratorOn) {
            this.produceBeam();
        } else {
            this.resetBeam();
        }
        this.push();
        return super.onUpdateServer();
    }

    @Override
    protected void push() {
        if (this.getAccelerator().input != null && this.getAccelerator().input.getExternalFacing() != null) {
            for (TileAcceleratorBeamPort port : this.getAccelerator().getPartMap(TileAcceleratorBeamPort.class).values()) {
                IParticleStackHandler otherStorage;
                TileEntity tile;
                if (port.getExternalFacing() == null || port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
                if (port.func_174877_v().func_177967_a(port.getExternalFacing().func_176734_d(), 4).equals((Object)this.getAccelerator().input.func_174877_v())) {
                    tile = this.getAccelerator().WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing()));
                    if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d())) continue;
                    otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d());
                    otherStorage.reciveParticle(port.getExternalFacing().func_176734_d(), this.getAccelerator().beams.get(2).getParticleStack());
                    continue;
                }
                tile = this.getAccelerator().WORLD.func_175625_s(port.func_174877_v().func_177972_a(port.getExternalFacing()));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d())) continue;
                otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, port.getExternalFacing().func_176734_d());
                otherStorage.reciveParticle(port.getExternalFacing().func_176734_d(), this.getAccelerator().beams.get(1).getParticleStack());
            }
        }
    }

    public long getMaxEnergy() {
        if (this.getAccelerator().beams.get(0).getParticleStack() != null) {
            Particle particle = this.getAccelerator().beams.get(0).getParticleStack().getParticle();
            return Equations.ringEnergyMaxEnergyFromDipole(this.getAccelerator().dipoleStrength, this.getBeamRadius(), particle.getCharge(), particle.getMass());
        }
        return 0L;
    }

    public long getAcceleratorMaxEnergy(Particle particle) {
        if (particle != null) {
            return Equations.ringEnergyMaxEnergyFromDipole(this.getAccelerator().dipoleStrength, this.getBeamRadius(), particle.getCharge(), particle.getMass());
        }
        return 0L;
    }

    @Override
    public int getBeamLength() {
        return this.getAccelerator().getExteriorLengthX();
    }

    @Override
    public double getBeamRadius() {
        return QMDConfig.beamDiverterRadius;
    }

    public long getEnergyLoss() {
        return Equations.cornerEnergyLoss(this.getAccelerator().beams.get(0).getParticleStack(), this.getBeamRadius());
    }

    private void resetBeam() {
        this.getAccelerator().beams.get(1).setParticleStack(null);
        this.getAccelerator().beams.get(2).setParticleStack(null);
    }

    private void produceBeam() {
        if (this.getAccelerator().beams.get(0).getParticleStack() != null) {
            ParticleStack stackIn = this.getAccelerator().beams.get(0).getParticleStack();
            this.getAccelerator().beams.get(1).setParticleStack(stackIn.copy());
            this.getAccelerator().beams.get(1).getParticleStack().setAmount(stackIn.getAmount() / 2);
            this.getAccelerator().beams.get(2).setParticleStack(stackIn.copy());
            this.getAccelerator().beams.get(2).getParticleStack().setAmount(stackIn.getAmount() / 2);
            if (stackIn.getMeanEnergy() <= this.getMaxEnergy()) {
                ParticleStack particleOut = this.getAccelerator().beams.get(1).getParticleStack();
                ParticleStack particleStraightOut = this.getAccelerator().beams.get(2).getParticleStack();
                particleOut.addMeanEnergy(-Equations.cornerEnergyLoss(stackIn, this.getBeamRadius()));
                particleOut.addFocus(-Equations.focusLoss(QMDConfig.beamAttenuationRate, this.getBeamLength(), stackIn));
                particleStraightOut.addFocus(-Equations.focusLoss(QMDConfig.beamAttenuationRate, this.getBeamLength(), stackIn));
                if (particleOut.getFocus() <= 0.0) {
                    particleOut = null;
                    this.getAccelerator().errorCode = 3;
                }
                if (particleStraightOut.getFocus() <= 0.0) {
                    particleStraightOut = null;
                    this.getAccelerator().errorCode = 3;
                }
            }
        } else {
            this.resetBeam();
        }
    }

    @Override
    protected void pull() {
        IParticleStackHandler otherStorage;
        ParticleStack stack;
        TileEntity tile;
        if (this.getAccelerator().input != null && this.getAccelerator().input.getExternalFacing() != null && (tile = this.getAccelerator().WORLD.func_175625_s(this.getAccelerator().input.func_174877_v().func_177972_a(this.getAccelerator().input.getExternalFacing()))) != null && tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getAccelerator().input.getExternalFacing().func_176734_d()) && (stack = (otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, this.getAccelerator().input.getExternalFacing().func_176734_d())).extractParticle(this.getAccelerator().input.getExternalFacing().func_176734_d())) != null) {
            this.getAccelerator().beams.get(0).setMaxEnergy(this.getAcceleratorMaxEnergy(stack.getParticle()));
            if (!this.getAccelerator().beams.get(0).reciveParticle(this.getAccelerator().input.getExternalFacing(), stack)) {
                if (stack.getMeanEnergy() > this.getAccelerator().beams.get(0).getMaxEnergy()) {
                    this.getAccelerator().errorCode = 5;
                } else if (stack.getMeanEnergy() < this.getAccelerator().beams.get(0).getMinEnergy()) {
                    this.getAccelerator().errorCode = 4;
                }
            }
        }
    }

    @Override
    public BeamSplitterUpdatePacket getUpdatePacket() {
        return new BeamSplitterUpdatePacket(this.getAccelerator().controller.getTilePos(), this.getAccelerator().isAcceleratorOn, this.getAccelerator().cooling, this.getAccelerator().rawHeating, this.getAccelerator().currentHeating, this.getAccelerator().maxCoolantIn, this.getAccelerator().maxCoolantOut, this.getAccelerator().maxOperatingTemp, this.getAccelerator().requiredEnergy, this.getAccelerator().efficiency, this.getAccelerator().acceleratingVoltage, this.getAccelerator().RFCavityNumber, this.getAccelerator().quadrupoleNumber, this.getAccelerator().quadrupoleStrength, this.getAccelerator().dipoleNumber, this.getAccelerator().dipoleStrength, this.getAccelerator().errorCode, this.getAccelerator().heatBuffer, this.getAccelerator().energyStorage, this.getAccelerator().tanks, this.getAccelerator().beams);
    }

    @Override
    public void onPacket(AcceleratorUpdatePacket message) {
        super.onPacket(message);
        if (message instanceof BeamSplitterUpdatePacket) {
            BeamSplitterUpdatePacket beamSplitterUpdatePacket = (BeamSplitterUpdatePacket)message;
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
    }

    @Override
    public ContainerMultiblockController<Accelerator, IAcceleratorController> getContainer(EntityPlayer player) {
        return new ContainerBeamSplitterController(player, this.getAccelerator().controller);
    }

    @Override
    public List<Pair<Class<? extends IAcceleratorPart>, String>> getPartBlacklist() {
        return PART_BLACKLIST;
    }
}

