/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.enums.BlockTypes;
import lach_01298.qmd.util.Util;
import net.minecraft.util.math.BlockPos;

public class DipoleMagnet {
    private final Accelerator accelerator;
    private BlockPos pos;
    private final Long2ObjectMap<IAcceleratorComponent> components = new Long2ObjectOpenHashMap();
    private BlockTypes.MagnetType type;

    public DipoleMagnet(Accelerator accelerator, BlockPos pos) {
        this.accelerator = accelerator;
        this.pos = pos;
        this.setType();
        this.addComponents();
    }

    private void setType() {
        if (this.accelerator.WORLD.func_175625_s(this.pos.func_177984_a()) instanceof TileAcceleratorMagnet) {
            TileAcceleratorMagnet magnet = (TileAcceleratorMagnet)this.accelerator.WORLD.func_175625_s(this.pos.func_177984_a());
            this.type = BlockTypes.MagnetType.valueOf(magnet.name.toUpperCase());
        } else if (this.accelerator.WORLD.func_175625_s(this.pos.func_177978_c()) instanceof TileAcceleratorMagnet) {
            TileAcceleratorMagnet magnet = (TileAcceleratorMagnet)this.accelerator.WORLD.func_175625_s(this.pos.func_177978_c());
            this.type = BlockTypes.MagnetType.valueOf(magnet.name.toUpperCase());
        } else if (this.accelerator.WORLD.func_175625_s(this.pos.func_177974_f()) instanceof TileAcceleratorMagnet) {
            TileAcceleratorMagnet magnet = (TileAcceleratorMagnet)this.accelerator.WORLD.func_175625_s(this.pos.func_177974_f());
            this.type = BlockTypes.MagnetType.valueOf(magnet.name.toUpperCase());
        } else {
            Util.getLogger().error("could not set dipole type becuase" + this.accelerator.WORLD.func_175625_s(this.pos.func_177984_a()) + " at " + this.pos.func_177984_a() + " is not a instance of TileAcceleratorMagnet");
        }
    }

    private void addComponents() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.addComponent(this.pos.func_177982_a(x, y, z));
                }
            }
        }
    }

    private void addComponent(BlockPos postion) {
        if (this.accelerator.WORLD.func_175625_s(postion) instanceof IAcceleratorComponent) {
            this.components.put(postion.func_177986_g(), (Object)((IAcceleratorComponent)this.accelerator.WORLD.func_175625_s(postion)));
        } else {
            Util.getLogger().error("could not add tile to dipole becuase" + this.accelerator.WORLD.func_175625_s(postion) + " at " + postion + " is not a instance of IAcceleratorComponent");
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Long2ObjectMap<IAcceleratorComponent> getComponents() {
        return this.components;
    }

    public BlockTypes.MagnetType getType() {
        return this.type;
    }
}

